#include"CGraphic.h"

#include"../auxiliary/CString.h"

namespace Maid
{

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵XvCg`悷
/*!
 *	\param	Pos		[i ]	]W
 *	\param	Sprite	[i ]	`\[X
 *	\param	Alpha	[i ]	sx 0xFF ŊSɌiftHg0xFF)
 *
 */
void CGraphic::BltSprite  ( const POINT2DF& Pos, const SPRITE& Sprite, unt08 Alpha )
{
	const CTexture&			tex  = Sprite.Texture;
	const MySTL::vector<RECT2DI>&	cell = Sprite.CellList;
	const CSpriteFile::SPRITEDATA&	dat  = Sprite.SpriteData;

	for( int i=(int)dat.PartsList.size()-1; 0<=i; --i )
	{
		const CSpriteFile::SPRITEDATA::PARTS& parts = dat.PartsList[i];
		const POINT2DF& pos    = Pos;
		const RECT2DI&  rc     = cell[parts.CellNo];
		const POINT2DF  offset = parts.DrawPos;

		Blt( pos, tex, rc, offset, Alpha );
	}
}

void CGraphic::BltSpriteS ( const POINT2DF& Pos, const SPRITE& Sprite, const SIZE2DF& Scale, unt08 Alpha )
{
	const CTexture&			tex  = Sprite.Texture;
	const MySTL::vector<RECT2DI>&	cell = Sprite.CellList;
	const CSpriteFile::SPRITEDATA&	dat  = Sprite.SpriteData;

	for( int i=(int)dat.PartsList.size()-1; 0<=i; --i )
	{
		const CSpriteFile::SPRITEDATA::PARTS& parts = dat.PartsList[i];
		const POINT2DF& pos    = Pos;
		const RECT2DI&  rc     = cell[parts.CellNo];
		const POINT2DF  offset = parts.DrawPos;

		BltS( pos, tex, rc, Scale, offset, Alpha );
	}
}

void CGraphic::BltSpriteR ( const POINT2DF& Pos, const SPRITE& Sprite, float32 Rotate, const VECTOR3DF& vec, unt08 Alpha )
{
	const CTexture&			tex  = Sprite.Texture;
	const MySTL::vector<RECT2DI>&	cell = Sprite.CellList;
	const CSpriteFile::SPRITEDATA&	dat  = Sprite.SpriteData;

	for( int i=(int)dat.PartsList.size()-1; 0<=i; --i )
	{
		const CSpriteFile::SPRITEDATA::PARTS& parts = dat.PartsList[i];
		const POINT2DF& pos    = Pos;
		const RECT2DI&  rc     = cell[parts.CellNo];
		const POINT2DF  offset = parts.DrawPos;

		BltR( pos, tex, rc, Rotate, vec, offset, Alpha );
	}
}


void CGraphic::BltSpriteSR( const POINT2DF& Pos, const SPRITE& Sprite, const SIZE2DF& Scale, float32 Rotate, const VECTOR3DF& vec, unt08 Alpha )
{
	const CTexture&			tex  = Sprite.Texture;
	const MySTL::vector<RECT2DI>&	cell = Sprite.CellList;
	const CSpriteFile::SPRITEDATA&	dat  = Sprite.SpriteData;

	for( int i=(int)dat.PartsList.size()-1; 0<=i; --i )
	{
		const CSpriteFile::SPRITEDATA::PARTS& parts = dat.PartsList[i];
		const POINT2DF& pos    = Pos;
		const RECT2DI&  rc     = cell[parts.CellNo];
		const POINT2DF  offset = parts.DrawPos;

		BltSR( pos, tex, rc, Scale, Rotate, vec, offset, Alpha );
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! `Ww肵Ă̑p``
/*!
 *	TRIANGLE_STRIP ŕ`悷̂ŁAz͂ƂĂĂ 
 *
 *	\param	Pos			[i ]	]W
 *	\param	Src			[i ]	`ɎgeNX`
 *	\param	Poly		[i ]	؂蔲W
 *	\param	Alpha		[i ]	`悷铧x
 */
void CGraphic::BltPolygon( const POINT2DF& Pos, const CTexture& Src, const MySTL::vector<POINT2DI>& Poly, unt08 Alpha )
{
	const float PosX   = Pos.x - 0.5f;
	const float PosY   = Pos.y - 0.5f;
	const float TexW = (float)Src.GetTextureSize().w;
	const float TexH = (float)Src.GetTextureSize().h;
	const COLOR_A08R08G08B08I Color(Alpha,0xFF,0xFF,0xFF);

	MySTL::vector<CUSTOMVERTEX_SPRITE> VertexList( Poly.size() );


	for( int i=0; i<(int)VertexList.size(); ++i )
	{
		CUSTOMVERTEX_SPRITE& v = VertexList[i];
		const VECTOR2DI SrcPos(Poly[0],Poly[i]);
		const POINT2DI& tex   = Poly[i];

		v.Position.x = PosX + SrcPos.x;
		v.Position.y = PosY + SrcPos.y;
		v.Position.z = 0;

		v.RHW = 1.0f;
		v.Color = Color;

		v.Texture[0] = POINT2DF(float(tex.x)/TexW,float(tex.y)/TexH);

	}

	SetRenderStateZWriteEnable(false);
	SetRenderStateZTestEnable(false);
	SetCullingMode(CULLINGMODE_NONE);
	SetSamplerStateMagFilter( 0, m_FilterType );
	SetSamplerStateMinFilter( 0, m_FilterType );

	UnsetAllTexture();
	SetTexture( Src );
	SetVertexShader( m_VertexShaderBlt[0] );
	SetPixelShader( m_PixelShaderBlt[m_BltState] );
	DrawPrimitiveUP( PRIMITIVE_TRIANGLESTRIP, &(VertexList[0]), VertexList[0].GetStructSize(), (int)VertexList.size()-2 );
}

}

