/*!
 	@file
 	@brief	tHgeNX`̃LbVǗNX
 */

#ifndef CTextureFontCache_h
#define CTextureFontCache_h

#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Macro.h"
#include"../../Auxiliary/Debug/CAssert.h"
#include"../../template/CacheManager.h"
#include"CTexture.h"
#include"Core/Driver/CFontDriver.h"
#include"Core/Driver/CSurfaceBuffer.h"
#include<map>
#include<boost/smart_ptr.hpp>

namespace Maid
{
	class CFontCache
	{
		class CTextureFont : public CTexture
		{
		public:
			CTextureFont();
			CTextureFont( const CTextureFont& rha );
			~CTextureFont();
			void Load( const SPSURFACEBUFFER& pBuff );
			void Destroy();

			virtual SIZE2DI		GetSize()const;
			virtual PIXELFORMAT	GetPixelFormat()const;
			virtual mstring GetID() const;
		public:
			CTextureFont& operator = ( const CTextureFont& rha );

		private:

			struct INFO
			{
				SIZE2DI		ImageSize;
				PIXELFORMAT	Format;
				int			ID;
			};

			boost::shared_ptr<INFO>	m_pInfo;

			static int s_AutoInc;
		};

	public:
		CFontCache();
		~CFontCache();

		void Initialize( const SPFONTDRIVER& pFont );
		void Finalize();
		const CTexture& GetCache( const SPFONT& pFont, unt32 FontCode );
		void ClearCache();
		void SetCacheSize( int Size );
		void Garbage();

	private:

		//!	ɎgLbVL[
		struct CACHEKEY
		{
			CACHEKEY(){}
			CACHEKEY( const SPFONT& p, unt32 code );
			mstring	FontName;
			SIZE2DI Size;
			unt32	Code;

			bool	IsAntialias;
			bool	IsBold;
			bool	IsItalic;

			bool operator < ( const CACHEKEY& rhs ) const;
		};


		typedef CacheManager<CACHEKEY,CTextureFont> CACHETABLE;

		CACHETABLE	m_CacheTable;

		SPFONTDRIVER	m_pFontDriver;
	};


}
#endif
