#include"CCamera.h"
#include"../template/Collision.h"


namespace Maid
{

/*!
 	@class	CCamera CCamera.h
 	@brief	JNX
\n			r[}gNXAvWFNV}gNXǗ
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CCamera::CCamera()
{
	m_IsCalcViewMatrix = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 *
 */
CCamera::~CCamera()
{
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ˉe}gNX̍쐬
/*!
 	@param	Fov		[i ]	J̎p
 	@param	Aspect	[i ]	XN[̃AXyNg
 	@param	Near	[i ]	NbvŐ
 	@param	Far		[i ]	Nbv鉜̋
 */
void CCamera::SetPerspective( float Fov, float Aspect, float Near, float Far )
{
	m_ProjectionMatrix.SetPerspective(Fov,Aspect,Near,Far );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ˉe}gNX̍쐬
/*!
 	@param	Fov		[i ]	J̎p
 	@param	Aspect	[i ]	XN[̃AXyNg
 	@param	Near	[i ]	NbvŐ
 	@param	Far		[i ]	Nbv鉜̋
 	@param	ProjectionDepth		[i ]	ۂɎˉeʒuBJ猩Wׂ͂
 										(x,y,ProjectionDepth) ɂ̂Ƃĕ`悳
 */
void CCamera::SetOrthogonal( float Fov, float Aspect, float Near, float Far, float ProjectionDepth )
{
	MATRIX4DF m;

	m.SetOrthogonal( Fov, Aspect, ProjectionDepth, Far );

	const float CenterD = (ProjectionDepth-Near) / (Far - Near);
	m_ProjectionMatrix = m * MATRIX4DF().SetTranslate(0,0,CenterD);
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RcԒłQc\ɕ֗ȃJݒ
/*!
 	_(0,                      0,0)@XN[W(0,0) 
\n	_(0,          -ScreenHeight,0)@XN[W(0,ScreenHeight) 
\n	_(ScreenWidth,-ScreenHeight,0)@XN[W(ScreenWidth,ScreenHeight) 
\n	Ȃ悤ɃJWvZ܂
 
 
 	\param	ScreenWidth		[i ]	ʉTCY
 	\param	ScreenHeight	[i ]	ʏcTCY
 	\param	Near			[i ]	ʎŐ
 	\param	Far				[i ]	ʉ̋
 */
void CCamera::Set2DPosition( int ScreenWidth, int ScreenHeight, float Near, float Far )
{
	const float Width  = float(ScreenWidth /2);
	const float Height = float(ScreenHeight/2);
	const float Fovy   = DEGtoRAD(60.0f);
	const float Depth  = Height/Math<float>::tan(Fovy/2.0f);

	const POINT3DF DefaultPosition( Width, Height, -Depth );
	const POINT3DF DefaultTarget  ( Width, Height,      0 );

	SetPerspective( Fovy, Width/Height, Near, Far );
	SetPosition( DefaultPosition );
	SetTarget  ( DefaultTarget );
	SetUpVector( VECTOR3DF( 0, 1, 0) );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ĴW̐ݒ
/*!
 	@param	pos	[i ]	Vݒ肷W
 */
void CCamera::SetPosition( const POINT3DF&  pos )
{
	m_Pos = pos;
	m_IsCalcViewMatrix = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J̒W̐ݒ
/*!
 	@param	pos	[i ]	Vݒ肷W
 */
void CCamera::SetTarget  ( const POINT3DF&  pos )
{
	m_Target = pos;
	m_IsCalcViewMatrix = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J̏̐ݒ
/*!
 	@param	vec	[i ]	Vݒ肷W
 */
void CCamera::SetUpVector( const VECTOR3DF& vec )
{
	m_Up = vec;
	m_Up.Normalize();
	m_IsCalcViewMatrix = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! r[}gNX̎擾
/*!
 	@return r[}gNX
 */
const MATRIX4DF& CCamera::GetViewMatrix() const
{
	if( !m_IsCalcViewMatrix )
	{
		CCamera* pThis = const_cast<CCamera*>(this);
		pThis->m_ViewMatrix.SetLookAt( m_Pos, m_Target, m_Up );

		pThis->m_IsCalcViewMatrix = true;
	}

	return m_ViewMatrix;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! vWFNV}gNX̎擾
/*!
 	@return vWFNV}gNX
 */
const MATRIX4DF& CCamera::GetProjectionMatrix() const
{
	return m_ProjectionMatrix;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J̈ړ
/*!
 	WɈړ܂
 
 	@param	offset	[i ]	ړ
 */
void  CCamera::Move( const VECTOR3DF& offset )
{
	Move( offset, offset );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J̈ړ
/*!
 	@param	pos		[i ]	J̍Ẅړ
 	@param	target	[i ]	Ẅړ
 */
void  CCamera::Move( const VECTOR3DF& pos, const VECTOR3DF& target )
{
	m_Pos    += pos;
	m_Target += target;
	m_IsCalcViewMatrix = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JW̎擾
/*!
 	@return JW
 */
const POINT3DF&  CCamera::GetPosition() const
{
	return m_Pos;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! W̎擾
/*!
 	@return W
 */
const POINT3DF&  CCamera::GetTarget  () const
{
	return m_Target;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! J̏̎擾
/*!
 	@return J̏
 */
const VECTOR3DF& CCamera::GetUpVector() const
{
	return m_Up;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵RcWJɓĂ邩ׂ
/*!
 	@param	pos	ׂW
 
 	@return ĂȂ true
 */
bool CCamera::IsCameraIn( const POINT3DF& pos ) const
{
	const MATRIX4DF& CameraMat = GetViewMatrix();
	const MATRIX4DF& ProjecMat = GetProjectionMatrix();

	MATRIX4DF vp = CameraMat * ProjecMat;

	const float x = pos.x*vp.m11 + pos.y*vp.m21 + pos.z*vp.m31 + vp.m41;
	const float y = pos.x*vp.m12 + pos.y*vp.m22 + pos.z*vp.m32 + vp.m42;
	const float z = pos.x*vp.m13 + pos.y*vp.m23 + pos.z*vp.m33 + vp.m43;

	POINT3DF p( x/z, y/z, ProjecMat.m33+ProjecMat.m43/z );

	return Collision<float>::IsPointToRect( p.x, p.y, p.z, -1, -1, -1, 1, 1, 1 );
 
}

}