
#include"CWindow.h"

#include"../../Auxiliary/Debug/CAssert.h"
#include"../../Auxiliary/CString.h"
#include"../../Auxiliary/Debug/CException.h"
#include"../../Auxiliary/Debug/CTrace.h"

#include"CApplicationWindows.h"
#include<shellapi.h>

namespace Maid
{
/*!
 	@class	CWindow CWindow.h
 	@brief	EBhENX
\n			PEBhEɂPNXłB
 */ 

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CWindow::CWindow()
{
	m_Caption = MAIDTEXT("window");
	m_Pos  = POINT2DI(CW_USEDEFAULT,CW_USEDEFAULT);
	m_Size = SIZE2DI(320, 240);
	m_Style= WINDOWSTYLE_NORMAL;

	m_IsShow  = false;
	m_IsDandD = false;
	m_hWnd = NULL;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CWindow::~CWindow()
{
	Destory();
}


HWND CWindow::GetHWND()
{
	return m_hWnd;
}

SIZE2DI CWindow::GetSize()
{
	return m_Size;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! bZ[WłƂɃR[obN֐̐ݒ
/*!
 *	\param	Msg			[i ]	Ŏw肵bZ[WłƃR[obN܂
 *	\param	Function	[i ]	bZ[WƂɌĂԗ\̊֐
 */
void CWindow::RegistCallBack( UINT Msg, const MESSAGEFUNCTION& Function )
{
	m_MessageMap[Msg] = Function;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! bZ[WłƂɃR[obN֐̍폜
/*!
 *	\param	Msg			[i ]	폜֐
 */
void CWindow::DeleteCallBack( UINT Msg )
{
	m_MessageMap.erase( Msg );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! 쐬ꂽEBhE\܂
/*!
 */
void CWindow::Show()
{
	MAID_ASSERT( m_hWnd==NULL, "܂EBhE쐬Ă܂" );

//	if( !m_IsShow ) 
	{
		::ShowWindow(m_hWnd, SW_SHOW );
		m_IsShow = true;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! 쐬ꂽEBhE\ɂ܂
/*!
 */
void CWindow::Hide()
{
	MAID_ASSERT( m_hWnd==NULL, "܂EBhE쐬Ă܂" );

	if( m_IsShow )
	{
		ShowWindow(m_hWnd, SW_HIDE );
		m_IsShow = false;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhE̕\ʒu̕ύX
/*!
 	@param	pos [i ]	炵ݒ肷\W
 */
void CWindow::SetPosition( const POINT2DI& pos )
{
	if( m_hWnd!=NULL )
	{
		::SetWindowPos( m_hWnd, NULL, pos.x, pos.y, 0, 0, SWP_NOZORDER|SWP_NOSIZE );
	}

	m_Pos = pos;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhE̕\ʒu̕ύX
/*!
 	@param	size [i ]	炵ݒ肷NCAgTCY
 */
void CWindow::SetSize( const SIZE2DI& size )
{
	if( m_hWnd!=NULL )
	{
		const DWORD StyleFlag = _GetWindowStyle(m_Style);
		::RECT	rc = { 0, 0, size.w, size.h };
		::AdjustWindowRect( &rc, StyleFlag, FALSE );
		const int w = rc.right  - rc.left;
		const int h = rc.bottom - rc.top;

		::SetWindowPos( m_hWnd, NULL, 0, 0, w, h, SWP_NOZORDER|SWP_NOMOVE );
	}

	m_Size = size;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhEX^C̕ύX
/*!
 *
 */
void CWindow::SetStyle( WINDOWSTYLE Style )
{
	if( m_hWnd!=NULL )
	{
		const DWORD StyleFlag = _GetWindowStyle(Style);
		::SetWindowLong( m_hWnd, GWL_STYLE, StyleFlag );

		::SetWindowPos( m_hWnd, NULL,
				-1, -1,
				-1, -1,
				SWP_NOMOVE|SWP_NOSIZE|SWP_NOZORDER|SWP_FRAMECHANGED|SWP_SHOWWINDOW );

	}

	m_Style = Style;

	//	EBhȆ傫邱Ƃ̂ŁAĐݒ
	SetSize(m_Size);
}

void CWindow::SetCaption( const mstring& Name )
{
	m_Caption = Name;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃EBhEւ̂cc邩H
/*!
 	@param	IsAccept	[i ]	true ŋ
 */
void CWindow::SetDragDropMode( bool IsAccept )
{
	if( m_hWnd!=NULL )
	{
		::DragAcceptFiles( m_hWnd, IsAccept? TRUE:FALSE );
	}
	m_IsDandD = IsAccept;
}










/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhE쐬܂
/*!
 	쐬邾ł܂\܂
 	\Ƃ Show() ĂяoKv܂
 
	@exception CException I[vɎsꍇ
 */
void CWindow::Create()
{
	Destory();


	HWND hWnd = NULL;
	DWORD StyleFlag = _GetWindowStyle(m_Style);
	MySTL::string ClassName;
	MySTL::string Caption = CString::ConvertMAIDtoSJIS(m_Caption);

	switch( m_Style )
	{
	case WINDOWSTYLE_CONSOLE: { ClassName = "LISTBOX"; }break;
	default: 
		{
			const mstring name = IApplicationWindows::GetInstance()->GetClassName();
			ClassName = CString::ConvertMAIDtoSJIS(name);
		}
	}


	RECT	rc = { 0, 0, m_Size.w, m_Size.h };
	AdjustWindowRect( &rc, StyleFlag, FALSE );
	const int w = rc.right  - rc.left;
	const int h = rc.bottom - rc.top;

	//	CreateWindowEx() ̓ŃbZ[WĂ\邯
	//	RegistCallBack()ŃtbN悤ƂĂtbNłȂB
	//	ŋɍsĂ܂

	AddProc( NULL );
	hWnd = ::CreateWindowEx(	NULL,
								ClassName.c_str(),
								Caption.c_str(),
								StyleFlag,
								m_Pos.x , m_Pos.y,
								w, h,
								NULL, NULL,
								IApplicationWindows::GetInstance()->GetHINSTANCE(),
								NULL );
	DelProc();

	if( hWnd==NULL )
	{
		MAID_THROWEXCEPTION( MAIDTEXT("EBhE̍쐬Ɏs") );
	}

	AddProc( hWnd );
	m_hWnd = hWnd;

	if( m_IsDandD ) { SetDragDropMode(true); }

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhEj܂
/*!
 */
void CWindow::Destory()
{
	if( m_hWnd!=NULL )
	{
		::DestroyWindow( m_hWnd );
		DelProc();
	}

	m_hWnd = NULL;
	m_IsShow = false;
	m_IsDandD= false;
}




/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CInitializeWindows tbNČĂяo֐
/*!
 	Ȃǂ IMessageHook::WindowProc QƂ邱
 */
IMessageHook::RETURNCODE CWindow::OnMessage( CWindowsMessage& Param )
{
	MySTL::map<UINT,MESSAGEFUNCTION>::iterator ite = m_MessageMap.find( Param.GetMSG() );

	if( ite!=m_MessageMap.end() )
	{
		switch( ite->second( Param ) )
		{
		case CALLBACKCODE_EXIT:		{ return RETURNCODE_EXIT; }break;
		case CALLBACKCODE_CONTINUE:	{ return RETURNCODE_CONTINUE; }break;
		}
	}

	return RETURNCODE_CONTINUE;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! EBhEX^C`oḧɕϊ
/*!
	@param	Style	[i ]	m肽EBhEX^C

	@return ۂ̃EBhEX^C
\n			̂܂ CreateWindow() Ɏg
 */
DWORD	CWindow::_GetWindowStyle( WINDOWSTYLE Style )
{
	DWORD StyleFlag;
	switch( Style )
	{
	case WINDOWSTYLE_NORMAL:
		{
			StyleFlag = WS_SYSMENU | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_DLGFRAME | WS_CAPTION;
		}break;

	case WINDOWSTYLE_OVERLAP:
		{
			StyleFlag = WS_OVERLAPPEDWINDOW;
		}break;

	case WINDOWSTYLE_POPUP:
		{
			StyleFlag = WS_POPUP;
		}break;
	case WINDOWSTYLE_CONSOLE:
		{
			StyleFlag =   WS_VISIBLE | WS_CAPTION | LBS_NOINTEGRALHEIGHT | WS_VSCROLL
							| WS_SIZEBOX									//	TCY͉
							| WS_MAXIMIZEBOX | WS_MINIMIZEBOX| WS_SYSMENU;	//	ƁAEBhÉ~󂪂B
		}break;
	}

	return StyleFlag;
}

}