
/*!
 	@file
 	@brief Windowspt[[N
 */

#ifndef CSingleWindowAppWindows_h
#define CSingleWindowAppWindows_h


#include"../../Setup/CompileMode.h"
#include"../../Auxiliary/Thread/CThreadController.h"
#include"../../Graphic/Core/CGraphicCore.h"
#include"../../Graphic/CGraphic.h"
#include"../../Sound/Core/CSoundCore.h"
#include"../../Sound/CSound.h"
#include"../../Input/CMouse.h"
#include"../../Input/CKeybord.h"
#include"../../Input/CInputMethod.h"
#include"../../Input/Driver/CInputDriver.h"
#include"../../Input/Driver/CInputMethodDriver.h"
#include"../../Storage/CStorage.h"
#include"CApplicationWindows.h"
#include"CWindow.h"
#include"CSingleWindowMessage.h"
#include<boost/smart_ptr.hpp>

namespace Maid
{
	struct APPCONFIG
	{
		struct GRAPHIC
		{
			enum SCREEN
			{
				SCREEN_FULL16=0,
				SCREEN_FULL32,
				SCREEN_WINDOW,
			};

			SCREEN	Screen;

			SIZE2DI Size;
			int		RefreshRate;
			bool	IsSoftTnL;
			bool	IsWaitVSync;

			bool	IsAspectLock;

			mstring	WindowCaption;
		};

		struct SOUND
		{
			int SamplesPerSec;
			int BitsPerSample;
			int Channels;
		};

		GRAPHIC Graphic;
		SOUND Sound;
	};



	class CSingleWindowAppWindows;
	class IGameThread
	{
	public:
		virtual ~IGameThread(){}

		virtual void OnSetup();


		struct BEGINPARAM
		{
			CGraphic::FRAMEINFO* pInfo;
			SPFONTDRIVER		pFontDriver;
			SPKEYBORDDRIVER		pKeybordDriver;
			SPMOUSEDRIVER		pMouseDriver;
			SPCHARCODEDRIVER	pCharCodeDriver;
			SPINPUTMETHODDRIVER	pIMEDriver;
		};

		virtual void OnBegin( const BEGINPARAM& param );
		virtual void OnLoop();
		virtual void OnEnd();
		virtual void OnButtonClose();
		virtual void OnButtonMaximize();
		virtual void OnDrawWindow();

		virtual void OnIMEResult( const mstring& str );
		virtual void OnCharCode( unt32 code );
		virtual void OnActivate( bool IsActive );

		void OnNextFrame( CGraphic& gra );

		bool IsExitGame();
		void OnExitGame();

		const APPCONFIG& GetAppConfig();

	protected:
		virtual void OnLocalSetup( APPCONFIG& conf )=0;
		virtual void OnLocalBegin( const BEGINPARAM& param )=0;
		virtual void OnLocalLoop()=0;
		virtual void OnLocalEnd()=0;

		CSingleWindowAppWindows* GetFrameWork();


	private:
		APPCONFIG	m_Config;
		bool		m_IsExitGame;
	};

	typedef	boost::shared_ptr<IGameThread>	SPGAMETHREAD;


	/*!
	 	@class	ISingleWindowApp CSingleWindowApp.h
	 	@brief	t[[Nx[XNX
	 */ 
	class CSingleWindowAppWindows : public IApplicationWindows
	{
	public:
		CSingleWindowAppWindows( const SPGAMETHREAD& pGame );

		void OnNextFrame( RETURNMESSAGEQUE& ReturnMessage );

	protected:
		
		void ExecuteWindowMessage();
		void HardWareCursorCheck();



	protected:
		virtual void OnSetup();
		virtual void OnLoop();
		virtual void OnCleanup();

		virtual HICON	LoadIcon();

	private:
		unt ThreadFunction( volatile CThreadController::BRIGEDATA& brige );
		CWindow::CALLBACKCODE wmClose( CWindowsMessage& msg );
		CWindow::CALLBACKCODE wmActivate( CWindowsMessage& msg );
		CWindow::CALLBACKCODE wmNcLButtonDblClk( CWindowsMessage& msg ); 
		CWindow::CALLBACKCODE wmSysCommand( CWindowsMessage& msg ); 
		CWindow::CALLBACKCODE wmKeyDown( CWindowsMessage& msg ); 
		CWindow::CALLBACKCODE wmSysKeyDown( CWindowsMessage& msg ); 
		CWindow::CALLBACKCODE wmPaint( CWindowsMessage& msg ); 

		void OnIMEResult( const mstring& str );
		void OnCharCode( unt32 code );

		void PostWindowMessage( const SPSINGLEWINDOWMESSAGE& pMess );

	private:
		HANDLE	m_hAppEvent;
		HANDLE	m_hGameEvent;
		bool	m_Initialize;

		bool	m_IsFrameUpdating;
		CThreadMutex	m_MessageMutex;


		SINGLEWINDOWMESSAGEQUE	m_WindowMessageQue;

		CGraphic::FRAMEINFO	m_FrameInfo;
		RETURNMESSAGEQUE	m_ReturnMessageQue;

	private:
		CWindow	m_Window;
		CGraphicCore	m_GraphicCore;
		CSoundCore		m_SoundCore;

		SPKEYBORDDRIVER		m_pKeybordDriver;
		SPMOUSEDRIVER		m_pMouseDriver;
		SPCHARCODEDRIVER	m_pCharCodeDriver;
		SPINPUTMETHODDRIVER	m_pIMEDriver;


		CThreadController	m_Thread;

	private:


		SPGAMETHREAD	m_pGame;
	};

}
#endif
