/*!
 	@file
 	@brief Win32 pbZ[WvV[W
 */


#ifndef CMessageHook_h
#define CMessageHook_h

#include"../../Setup/CompileMode.h"
#include"../../Setup/Win32.h"
#include"../../Auxiliary/Macro.h"



namespace Maid
{
	/*!
	 	@class	CWindowsMessage CMessageHook.h
	 	@brief	vV[WpҏWNX
	 */
	class CWindowsMessage
	{
	public:
		//!	RXgN^
		CWindowsMessage( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
			: m_hWnd(hWnd),m_Msg(msg),m_wParam(wParam),m_lParam(lParam)
		{
		
		}
		

		HWND	GetHWND() const { return m_hWnd; }		//!<	bZ[W̑Mnh
		UINT	GetMSG() const { return m_Msg; }		//!<	ꂽbZ[W̎擾

		enum PARAM
		{
			PARAM_LO,
			PARAM_HI,
			PARAM_ALL
		};


		WPARAM	GetWPARAM(PARAM pos=PARAM_ALL) const 
		{
			if( pos==PARAM_LO ) { return LOWORD(m_wParam); }
			if( pos==PARAM_HI ) { return HIWORD(m_wParam); }
			return m_wParam; 
		}

		LPARAM	GetLPARAM(PARAM pos=PARAM_ALL) const
		{
			if( pos==PARAM_LO ) { return LOWORD(m_lParam); }
			if( pos==PARAM_HI ) { return HIWORD(m_lParam); }
			return m_lParam; 
		}

		void SetHWND( HWND hWnd ) { m_hWnd = hWnd; }
		void SetMSG( UINT msg ) { m_Msg = msg; }
		void SetWPARAM( WPARAM wparam ) { m_wParam = wparam; }
		void SetLPARAM( LPARAM lparam ) { m_lParam = lparam; }

	private:
		HWND	m_hWnd;
		UINT	m_Msg;
		WPARAM	m_wParam;
		LPARAM	m_lParam;
	};


	class IMessageHook
	{
	public:
		IMessageHook();
		virtual ~IMessageHook();

		/*!
		 	WindowProc() Ŗ߂ĂR[h
		 */
		enum RETURNCODE
		{
			RETURNCODE_EXIT=0,		//!<	bZ[W͏ꂽ̂łȍ~͌Ă΂Ȃ
			RETURNCODE_CONTINUE,	//!<	bZ[W[v𑱂
		};

		void AddProc( HWND hWnd );
		void DelProc();

		//! vV[WɃR[obNĂ炤֐
		/*!
		 	̊֐pŎ܂
		 
		 	@param	mess	[i ]	ĂbZ[W
		 
		 	@retval	 RETURNCODE_EXIT		ȍ~bZ[Ws܂
		 	@retval	 RETURNCODE_CONTINUE	܂܂
		 */
		virtual RETURNCODE OnMessage( CWindowsMessage& mess )=0;

	private:
		bool	m_IsHook;	//!<	݃tbNĂ邩
		HWND	m_hWnd;		//!<	݂̃nh
	};
}

#endif
