/*!
 	@file
 	@brief	V[x[XNX
 */


#ifndef CScene_h
#define CScene_h

#include"../Setup/CompileMode.h"
#include<boost/smart_ptr.hpp>

#include"../Graphic/CGraphic.h"

namespace Maid
{
	/*!
	 	@class	ISceneInput CScene.h
	 	@brief	V[ƂɎgNX
	\n			󂯎V[͓K؂ɃLXgĎg
	 */
	class ISceneInput
	{
	public:
		virtual ~ISceneInput(){};
	};

	/*!
	 	@class	ISceneOutput CScene.h
	 	@brief	V[ƂɎgNX
	\n			󂯎e͓K؂ɃLXgĎg
	 */
	class ISceneOutput
	{
	public:
		virtual ~ISceneOutput(){};
	};

	typedef boost::shared_ptr<ISceneInput > SPSCENEINPUT;
	typedef boost::shared_ptr<ISceneOutput> SPSCENEOUTPUT;

	class IScene
	{
	public:
		IScene();
		virtual ~IScene()=0{};

		//! ̃V[
		/*!
		 	@param	pInput	[i ]	eV[Ăf[^
		 */
		virtual void Initialize( const SPSCENEINPUT& pInput )=0;
		//! ̃V[Еt
		/*!
		 	@param	pOutput	[i ]	eV[ɑf[^
		 */
		virtual void Finalize( SPSCENEOUTPUT& pOutput )=0; 

		//! t[̏s
		/*!
		 */
		virtual void OnMove()=0;

		//! `揈s
		/*!
		 	`T[tFCXύXꍇ͌ɖ߂Ă
		 
		 	@param	Render	[i ]	`惌_
		 */
		virtual void OnDraw( CGraphic& Render )=0;

		void ExitScene();
		bool IsExit() const;
	private:
		bool	m_IsExit;
	};

	typedef boost::shared_ptr<IScene> SPSCENE;


}

#endif
