#include"CGUISlider.h"

namespace Maid
{
	/*!
	 *	\class	CGUISlider CGUISlider.h
	 *	\brief	XC_NX
	\n			 Windows ̃{^Ƃ
	\n			{^邾ł
	 */

enum PARTSID
{
	PARTSID_BUTTON=0,	//!<	XC_̃{^
};

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
IGUISlider::IGUISlider()
{
	m_MeterBegin  = 0;
	m_MeterLength = 1;
	m_NowMeter = 0;

	m_BarBegin  = 0;
	m_BarLength = 1;

	m_State = STATE_NORMAL;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! XC_Xi̐ݒ
/*!
 *	\param	pListener	[i ]	ݒ肷郊Xi
 */
void	IGUISlider::SetListener(const SPGUISLIDERLISTENER& pListener )
{
	m_pListener = pListener;

	m_BarBegin  = pListener->GetBarBegin();
	m_BarLength = pListener->GetBarLength();

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! XC_Xi̎擾
/*!
 *	\return XC_Xi
 */
const boost::shared_ptr<IGUISlider::Listener>&	IGUISlider::GetSliderListener() const
{
	return m_pListener;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̐ݒ
/*!
 *	\param	begin	[i ]	̊Jnl
 *	\param	len		[i ]	̐
 */
void	IGUISlider::SetMeterRange( int begin, int len )
{
	MAID_ASSERT( len==0, "O͐ݒł܂" );
	m_MeterBegin  = begin;
	m_MeterLength = len;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̐ݒ
/*!
 *	GUIMESSAGE_SLIDER_MOVEVALUE bZ[W͔s܂
 *
 *	\param	pos	[i ]	Vݒ肷ʒu
 */
void	IGUISlider::SetMeter( int pos )
{
	if( pos < m_MeterBegin                     ){ m_NowMeter = m_MeterBegin;     }
	ef(       m_MeterBegin+m_MeterLength < pos ){ m_NowMeter = m_MeterBegin+m_MeterLength; }
	else										{ m_NowMeter = pos; }
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̐ݒ
/*!
 *	GUIMESSAGE_SLIDER_MOVEVALUE bZ[W𔭍s܂
 *
 *	\param	pos	[i ]	Vݒ肷ʒu
 */
void	IGUISlider::SetMeterCallMessage( int pos )
{
	//	ύXOƓlȂ烁bZ[W͗vȂ
	int old = m_NowMeter;
	SetMeter( pos );
	
	if( old!=m_NowMeter ) { CallBack(GUIMESSAGE_SLIDER_MOVEVALUE); }
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̈ʒu̎擾
/*!
 *	\return ʒu
 */
int	IGUISlider::GetMeter() const
{
	return m_NowMeter;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusIn QƂ邱
 */
void IGUISlider::OnLocalFocusIn()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnFocusIn();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusOut QƂ邱
 */
void IGUISlider::OnLocalFocusOut()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnFocusOut();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! {^̂W̎擾
/*!
 *	\return {^̂W
 */
int	IGUISlider::GetButtonPos() const
{
	return m_NowMeter*m_BarLength/m_MeterLength+m_BarBegin;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵W烁[^[̒lvZ
/*!
 *	\param	pos	[i ]	WiIGUISlider̍Wnj
 *
 *	\return [^[̒l
 */
int	IGUISlider::CalcMeter( int pos ) const
{
	return (pos-m_BarBegin + m_BarLength/m_MeterLength/2)*m_MeterLength/m_BarLength;
}









/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! XC_Ȃ̂cXC_Ȃ̂߂
/*!
 *	\param	type	[i ]	XC_̕
 */
void CGUISliderVH::SetSliderType( TYPE type )
{
	m_Type = type;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[cɃJ[\邩H
/*!
 *	Ȃǂ IGUIParts::IsLocalCollision QƂ邱
 */
bool CGUISliderVH::IsLocalCollision( const POINT2DI& pos ) const
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	if( m_State==STATE_MOVE ) { return true; }

	const VECTOR2DI	offset = GetButtonOffset();

	return m_pListener->IsCollisionBar(pos) || m_pListener->IsCollisionButton(pos-offset);
}

void CGUISliderVH::OnLocalMouseIn  ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnMouseIn();
}

void CGUISliderVH::OnLocalMouseOut ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnMouseOut();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseDown QƂ邱
 */
void CGUISliderVH::OnLocalMouseDown( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	//	{^łhbO[h
	//	o[ŉ{^𓮂


	//	{^̈ʒu̓[^[̒lŕςĂ̂
	//	̕

	const VECTOR2DI	offset = GetButtonOffset();

	if( m_pListener->IsCollisionButton(pos-offset) )
	{
		m_pListener->OnButtonDown();
		m_State = STATE_MOVE;
	}
	ef( m_pListener->IsCollisionBar(pos) )
	{
		const int meter = CalcMeter(pos);
		SetMeterCallMessage(meter);
		m_pListener->OnButtonDown();
		m_State = STATE_MOVE;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseUp QƂ邱
 */
void CGUISliderVH::OnLocalMouseUp  ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	switch( m_State )
	{
	case STATE_NORMAL:
		{
		}break;
	case STATE_MOVE:
		{
			m_pListener->OnButtonUp();
			m_State = STATE_NORMAL;
		}break;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃J[\ɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseMove QƂ邱
 */
void CGUISliderVH::OnLocalMouseMove( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	switch( m_State )
	{
	case STATE_NORMAL:
		{

		}break;

	case STATE_MOVE:
		{
			const int meter = CalcMeter(pos);
			SetMeterCallMessage(meter);
		}break;
	}
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 *	Ȃǂ IGUIParts::OnLocalMove QƂ邱
 */
void CGUISliderVH::OnLocalMove()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnMove();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	Ȃǂ IGUIParts::OnLocalDraw QƂ邱
 */
void CGUISliderVH::OnLocalDraw( const POINT2DI& pos, CGraphic& Render )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	const VECTOR2DI	offset = GetButtonOffset();

	m_pListener->OnDraw( pos, pos+offset, Render );
}


VECTOR2DI CGUISliderVH::GetButtonOffset() const
{
	VECTOR2DI	offset(0,0);

	switch(m_Type)
	{
	case TYPE_V: { offset.y = GetButtonPos(); }break;
	case TYPE_H: { offset.x = GetButtonPos(); }break;
	}

	return offset;
}

int	CGUISliderVH::CalcMeter( const POINT2DI& pos )const
{
	int meter = 0;
	switch(m_Type)
	{
	case TYPE_V: { meter = IGUISlider::CalcMeter(pos.y); }break;
	case TYPE_H: { meter = IGUISlider::CalcMeter(pos.x); }break;
	}
	return meter;
}


void CGUISliderVH::OnLocalKeyDown( unt08 KeyCode )
{
	switch(m_Type)
	{
	case TYPE_V:
		{
			switch(KeyCode)
			{
			case CKeybord::BUTTON_UP:  { SetMeterCallMessage(m_NowMeter-1); }break;
			case CKeybord::BUTTON_DOWN:{ SetMeterCallMessage(m_NowMeter+1); }break;
			}
		}break;

	case TYPE_H:
		{
			switch(KeyCode)
			{
			case CKeybord::BUTTON_LEFT: { SetMeterCallMessage(m_NowMeter-1); }break;
			case CKeybord::BUTTON_RIGHT:{ SetMeterCallMessage(m_NowMeter+1); }break;
			}
		}break;
	}
}


}
