/*!
 *	\file
 *	\brief	fthp[c WI{^NX
 *
 */
#ifndef CGUIRadioButton_h
#define CGUIRadioButton_h

#include"CGUIParts.h"
#include"CGUIButton.h"

namespace Maid
{
	class CGUIRadioButton;
	class CGUIRadioButtonGroup
	{
		friend CGUIRadioButton;
	private:
		MySTL::vector<CGUIRadioButton*>	m_GroupList;
	};

	typedef boost::shared_ptr<CGUIRadioButtonGroup> SPGUIRADIOBUTTONGROUP;

	class CGUIRadioButton : public IGUIParts
	{
	public:
		class Listener
		{
			friend CGUIRadioButton;
		public:
			virtual ~Listener(){}
			virtual bool IsCollision( const POINT2DI& pos )const=0;	//!<	{^͈͓̔ɃJ[\邩
			virtual void OnMouseIn(){}						//!<	}EX͈͓ɗɌĂ΂
			virtual void OnMouseOut(){}						//!<	}EX͈͓痣ꂽɌĂ΂
			virtual void OnMouseDown(){}					//!<	}EX͈͓ŉꂽɌĂ΂
			virtual void OnMouseUp(){}						//!<	}EX͈͓ŗꂽɌĂ΂
			//! ̃{^NbNꂽƂɋN
			/*!
			 *	\param	IsCheck		[i ]	`FbNĂ邩H
			\n								`FbNĂƂɃNbNꂽ true 
			 */
			virtual void OnMouseClick(){}
			virtual void OnMove(){}
			virtual void OnDraw( const POINT2DI& pos, CGraphic& Render ){}
			virtual void OnFocusIn(){}
			virtual void OnFocusOut(){}
			virtual void OnChengeState( bool NewStateEnable, bool NewStateVisible ){}	//!<	ԂύXꂽƂɌĂ΂

		protected:
			bool IsCheck() const { return m_pOwner->IsCheck(); }

		private:
			CGUIRadioButton*	m_pOwner;
		};

	public:
		CGUIRadioButton();
		CGUIRadioButton( const CGUIRadioButton& button );
		~CGUIRadioButton();
		void	SetListener( const boost::shared_ptr<Listener>& pListener );
		const boost::shared_ptr<Listener>&	GetListener() const;

		bool IsCheck() const;
		void SetCheck( bool IsCheck );

		CGUIRadioButton& operator = ( const CGUIRadioButton& rha );

		void SetGroup( const SPGUIRADIOBUTTONGROUP& pGroup );

	protected:
		virtual void OnLocalMove();
		virtual void OnLocalDraw( const POINT2DI& pos, CGraphic& Render );
		virtual bool IsLocalCollision( const POINT2DI& pos ) const;

		virtual void OnLocalMouseIn  ( const POINT2DI& pos );
		virtual void OnLocalMouseOut ( const POINT2DI& pos );
		virtual void OnLocalMouseDown( const POINT2DI& pos );
		virtual void OnLocalMouseUp  ( const POINT2DI& pos );
		virtual void OnLocalMouseMove( const POINT2DI& pos );
		virtual void OnLocalKeyDown( unt08 KeyCode );
		virtual void OnLocalKeyUp( unt08 KeyCode );
		virtual void OnLocalCharCode( const mstring& CharCode ){};
		virtual void OnLocalChangeState( bool NewStateEnable, bool NewStateVisible );
		virtual void OnLocalFocusIn();
		virtual void OnLocalFocusOut();

	private:
		void GUICallBack( unt32 GUIParts, GUIMESSAGE Message );
		void Copy( const CGUIRadioButton& rha );

		CGUIButton					m_Button;
		boost::shared_ptr<Listener> m_pListener;

		bool	m_IsCheck;	//!<	`FbNĂ邩H


		SPGUIRADIOBUTTONGROUP	m_pGroup;
	};

	typedef boost::shared_ptr<CGUIRadioButton::Listener> SPGUIRADIOBUTTONLISTENER;



}

#endif