/*!
 *	\file
 *	\brief	fthp[c `FbN{^NX
 *
 */
#ifndef CGUICheckButton_h
#define CGUICheckButton_h

#include"CGUIParts.h"
#include"CGUIButton.h"

namespace Maid
{

	class CGUICheckButton : public IGUIParts
	{
	public:
		class Listener
		{
			friend CGUICheckButton;
		public:
			virtual ~Listener(){}
			virtual bool IsCollision( const POINT2DI& pos )const=0;	//!<	{^͈͓̔ɃJ[\邩
			virtual void OnMouseIn(){}						//!<	}EX͈͓ɗɌĂ΂
			virtual void OnMouseOut(){}						//!<	}EX͈͓痣ꂽɌĂ΂
			virtual void OnMouseDown(){}					//!<	}EX͈͓ŉꂽɌĂ΂
			virtual void OnMouseUp(){}						//!<	}EX͈͓ŗꂽɌĂ΂
			//! ̃{^NbNꂽƂɋN
			/*!
			 *	\param	IsCheck		[i ]	`FbNĂ邩H
			\n								`FbNĂƂɃNbNꂽ true 
			 */
			virtual void OnMouseClick(){}
			virtual void OnMove(){}
			virtual void OnDraw( const POINT2DI& pos, CGraphic& Render ){}
			virtual void OnFocusIn(){}
			virtual void OnFocusOut(){}
			virtual void OnChengeState( bool NewStateEnable, bool NewStateVisible ){}	//!<	ԂύXꂽƂɌĂ΂

		protected:
			bool IsCheck() const { return m_pOwner->IsCheck(); }

		private:
			CGUICheckButton*	m_pOwner;
		};

	public:
		CGUICheckButton();
		CGUICheckButton( const CGUICheckButton& button );
		void	SetListener( const boost::shared_ptr<Listener>& pListener );
		const boost::shared_ptr<Listener>&	GetListener() const;

		bool IsCheck() const;
		void SetCheck( bool IsCheck );

		CGUICheckButton& operator = ( const CGUICheckButton& rha );

	protected:
		virtual void OnLocalMove();
		virtual void OnLocalDraw( const POINT2DI& pos, CGraphic& Render );
		virtual bool IsLocalCollision( const POINT2DI& pos ) const;

		virtual void OnLocalMouseIn  ( const POINT2DI& pos );
		virtual void OnLocalMouseOut ( const POINT2DI& pos );
		virtual void OnLocalMouseDown( const POINT2DI& pos );
		virtual void OnLocalMouseUp  ( const POINT2DI& pos );
		virtual void OnLocalMouseMove( const POINT2DI& pos );
		virtual void OnLocalKeyDown( unt08 KeyCode );
		virtual void OnLocalKeyUp( unt08 KeyCode );
		virtual void OnLocalCharCode( const mstring& CharCode ){};
		virtual void OnLocalChangeState( bool NewStateEnable, bool NewStateVisible );
		virtual void OnLocalFocusIn();
		virtual void OnLocalFocusOut();

	private:
		void GUICallBack( unt32 GUIParts, GUIMESSAGE Message );
		CGUIButton					m_Button;
		boost::shared_ptr<Listener> m_pListener;

		bool	m_IsCheck;	//!<	`FbNĂ邩H
	};

	typedef boost::shared_ptr<CGUICheckButton::Listener> SPGUICHECKBUTTONLISTENER;



}

#endif