/*!
 	@file
 	@brief	fthp[c{^NX
 */
#ifndef CGUIButton_h
#define CGUIButton_h

#include"CGUIParts.h"

namespace Maid
{

	class CGUIButton : public IGUIParts
	{
	public:
		class Listener
		{
			friend CGUIButton;
		public:
			Listener() : m_pOwner(NULL){}
			virtual ~Listener(){}
			virtual bool IsCollision( const POINT2DI& pos )const{return false;}//!<	{^͈͓̔ɃJ[\邩

			virtual void OnMouseIn(){}						//!<	}EX͈͓ɗɌĂ΂
			virtual void OnMouseOut(){}						//!<	}EX͈͓痣ꂽɌĂ΂
			virtual void OnMouseDown(){}					//!<	}EX͈͓ŉꂽɌĂ΂
			virtual void OnMouseUp(){}						//!<	}EX͈͓ŗꂽɌĂ΂
			virtual void OnMouseClick(){}					//!<	̃{^NbNꂽƂɋN
			virtual void OnChengeState( bool NewStateEnable, bool NewStateVisible ){}	//!<	ԂύXꂽƂɌĂ΂
			virtual void OnMove(){}
			virtual void OnDraw( const POINT2DI& pos, CGraphic& Render ){}
			virtual void OnFocusIn(){}
			virtual void OnFocusOut(){}

		protected:
			CGUIButton*	GetOwner() { return m_pOwner; }

		private:
			CGUIButton*	m_pOwner;
		};

	public:
		CGUIButton();
		void	SetListener( const boost::shared_ptr<Listener>& pListener );
		const boost::shared_ptr<Listener>&	GetListener() const;

	protected:
		virtual void OnLocalMove();
		virtual void OnLocalDraw( const POINT2DI& pos, CGraphic& Render );
		virtual bool IsLocalCollision( const POINT2DI& pos ) const;

		virtual void OnLocalMouseIn  ( const POINT2DI& pos );
		virtual void OnLocalMouseOut ( const POINT2DI& pos );
		virtual void OnLocalMouseDown( const POINT2DI& pos );
		virtual void OnLocalMouseUp  ( const POINT2DI& pos );
		virtual void OnLocalMouseMove( const POINT2DI& pos );
		virtual void OnLocalKeyDown( unt08 KeyCode );
		virtual void OnLocalKeyUp( unt08 KeyCode );
		virtual void OnLocalCharCode( const mstring& CharCode ){};
		virtual void OnLocalChangeState( bool NewStateEnable, bool NewStateVisible );
		virtual void OnLocalFocusIn ();
		virtual void OnLocalFocusOut();

	private:
		boost::shared_ptr<Listener>		m_pListener;

		enum STATE
		{
			STATE_NORMAL,	//!<	
			STATE_DOWN,		//!<	}EXĂ
		};
		STATE	m_State;
		bool	m_IsCollisionIn;	//!<	͈͓ɓĂ邩H
	};

	typedef boost::shared_ptr<CGUIButton::Listener> SPGUIBUTTONLISTENER;
}

#endif