#include"CGUIButton.h"


namespace Maid
{
	/*!
	 *	\class	CGUIButton CGUIButton.h
	 *	\brief	{^NX
	\n			 Windows ̃{^Ƃ
	 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 *
 */
CGUIButton::CGUIButton()
{
	m_State = STATE_NORMAL;
	m_IsCollisionIn = false;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xi̓o^
/*!	Xio^ȂꍇA܂Ȃ̂ŒӁI
 *
 *	\param	pListener	[i ]	VXi
 */
void	CGUIButton::SetListener( const SPGUIBUTTONLISTENER& pListener )
{
	m_pListener = pListener;
	m_pListener->m_pOwner = this;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Xi̎擾
/*!
 *	\return łɐݒ肳Ă郊Xi
 */
const SPGUIBUTTONLISTENER&	CGUIButton::GetListener() const
{
	return m_pListener;
}



/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̏
/*!
 *	Ȃǂ IGUIParts::OnLocalMove QƂ邱
 */
void CGUIButton::OnLocalMove()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	m_pListener->OnMove();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t[̕`
/*!
 *	Ȃǂ IGUIParts::OnLocalDraw QƂ邱
 */
void CGUIButton::OnLocalDraw( const POINT2DI& pos, CGraphic& Render )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	m_pListener->OnDraw( pos, Render );

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ̃p[cɃJ[\邩H
/*!
 *	Ȃǂ IGUIParts::IsLocalCollision QƂ邱
 */
bool CGUIButton::IsLocalCollision( const POINT2DI& pos ) const
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->IsCollision( pos );
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX͈͓ɗɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseIn QƂ邱
 */
void CGUIButton::OnLocalMouseIn  ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->OnMouseIn();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX͈͓痣ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseOut QƂ邱
 */
void CGUIButton::OnLocalMouseOut ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	return m_pListener->OnMouseOut();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseDown QƂ邱
 */
void CGUIButton::OnLocalMouseDown( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	switch( m_State )
	{
	case STATE_NORMAL:
		{
			m_pListener->OnMouseDown();
			CallBack(GUIMESSAGE_BUTTON_MOUSEDOWN);
			m_State = STATE_DOWN;
		}break;

	case STATE_DOWN:		{ }break;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃{^ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseUp QƂ邱
 */
void CGUIButton::OnLocalMouseUp  ( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	const bool IsIn = m_pListener->IsCollision(pos);

	switch( m_State )
	{
	case STATE_NORMAL:  { }break;
	case STATE_DOWN:
		{
			m_pListener->OnMouseUp();
			CallBack(GUIMESSAGE_BUTTON_MOUSEUP);
			if( IsIn )
			{
				m_pListener->OnMouseClick();
				CallBack( GUIMESSAGE_BUTTON_CLICK );
			}
			m_State = STATE_NORMAL;
		}break;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyDown QƂ邱
 */
void CGUIButton::OnLocalKeyDown( unt08 KeyCode )
{
	switch( KeyCode )
	{
	case CKeybord::BUTTON_ENTER:
		{
			m_pListener->OnMouseDown();
			CallBack(GUIMESSAGE_BUTTON_MOUSEDOWN);
			m_State = STATE_DOWN;
		}break;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! L[{[h̃L[ꂽɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalKeyUp QƂ邱
 */
void CGUIButton::OnLocalKeyUp( unt08 KeyCode )
{
	switch( KeyCode )
	{
	case CKeybord::BUTTON_ENTER:
		{
			m_pListener->OnMouseUp();
			CallBack(GUIMESSAGE_BUTTON_MOUSEUP);
			m_pListener->OnMouseClick();
			CallBack( GUIMESSAGE_BUTTON_CLICK );
			m_State = STATE_NORMAL;
		}break;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ԂςɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalChangeState QƂ邱
 */
void CGUIButton::OnLocalChangeState( bool NewStateEnable, bool NewStateVisible )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnChengeState( NewStateEnable, NewStateVisible );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusIn QƂ邱
 */
void CGUIButton::OnLocalFocusIn()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnFocusIn();

	if( m_State==STATE_DOWN )
	{
		m_pListener->OnMouseUp(); 
		CallBack(GUIMESSAGE_BUTTON_MOUSEUP);
		m_State = STATE_NORMAL;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! tH[JXƂɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalFocusOut QƂ邱
 */
void CGUIButton::OnLocalFocusOut()
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );
	m_pListener->OnFocusOut();

	if( m_State==STATE_DOWN )
	{
		m_pListener->OnMouseUp(); 
		CallBack(GUIMESSAGE_BUTTON_MOUSEUP);
		m_State = STATE_NORMAL;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! }EX̃J[\ɌĂ΂
/*!
 *	Ȃǂ IGUIParts::OnLocalMouseMove QƂ邱
 */
void CGUIButton::OnLocalMouseMove( const POINT2DI& pos )
{
	MAID_ASSERT( m_pListener.get()==NULL, "Xi̐ݒ肪Ă܂" );

	switch( m_State )
	{
	case STATE_NORMAL:	{	}break;
	case STATE_DOWN:	{	}break;
	}
}


}