#include"CProcessMutex.h"
#include"../CString.h"
#include"../Debug/CException.h"

namespace Maid
{

/*!
 	@class CProcessMutex CProcessMutex.h
 	@brief vZXx̓IuWFNg
 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CProcessMutex::CProcessMutex()
{
	m_hMutex = NULL;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CProcessMutex::~CProcessMutex()
{
	Close();
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ~[eNX쐬
/*!
 	@param  MutexName	[i ]	쐬~[eNX
 	@param  IsOriginal	[i ]	B̃~[ebNXɂ邩H(ftHgTRUEj
 
	@exception CException 쐬łȂꍇ
 */
void CProcessMutex::Open( const mstring& MutexName, bool IsOriginal )
{
	Close();

	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(MutexName);

	m_hMutex = ::CreateMutex( NULL, TRUE, sjis_name.c_str() );
	if( m_hMutex==NULL ) 
	{
		MAID_THROWEXCEPTION(MutexName + MAIDTEXT("~[ebNX̍쐬Ɏs") );
	}

	if( IsOriginal && (::GetLastError()==ERROR_ALREADY_EXISTS) ) 
	{
		::CloseHandle(m_hMutex); 
		MAID_THROWEXCEPTION(MutexName + MAIDTEXT("~[ebNX͂łɑ݂Ă܂") );
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ~[eNX
/*!
 */
void CProcessMutex::Close()
{
	if( m_hMutex!=NULL )
	{
		::CloseHandle(m_hMutex);
		m_hMutex = NULL;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! w肵~[ebNXłɑ݂Ă邩ׂ
/*!
 *	\param  MutexName		[i ]	ׂ~[eNX
 *
 *	\return	݂Ă true
\n			݂ĂȂ false
 */
bool CProcessMutex::IsExist(  const mstring& MutexName )
{
	const MySTL::string sjis_name = CString::ConvertMAIDtoSJIS(MutexName);

	HANDLE hMutex = ::OpenMutex(MUTEX_ALL_ACCESS, FALSE, sjis_name.c_str());

	if( hMutex != NULL ) { ::CloseHandle(hMutex); return true; }

	return false;
}


}
