#include"CFileReadMemory.h"
#include"../Debug/CAssert.h"

namespace Maid
{

/*!
 	@class	CFileReadMemory CFileReadMemory.h
 	@brief	ɂĂf[^t@CƂĈNX
 */

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! RXgN^
/*!
 */
CFileReadMemory::CFileReadMemory() : m_pBegin(NULL),m_Size(0), m_Position(0)
{

}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! fXgN^
/*!
 */
CFileReadMemory::~CFileReadMemory()
{
	Close();
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CJ(|C^ۏ؂Ăo[W)
/*!
 	@param	pBegin	[i ]	ǂݍ݊JnAhX
 	@param	Size	[i ]	ǂݍݔ͈

	@exception CException I[vɎsꍇ
 */
void CFileReadMemory::Open( const boost::shared_array<unt08>& pBegin, int Size )
{
	OpenNoOwner( pBegin.get(), Size );
	m_pShared = pBegin;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CJ(|C^ۏ؂Ȃo[W)
/*!
 	̃CX^XȂȂ܂ pBegin Ă͂܂
 
 	@param	pBegin	[i ]	ǂݍ݊JnAhX
 	@param	Size	[i ]	ǂݍݔ͈
 
 	@exception CException I[vɎsꍇ
 */
void	CFileReadMemory::OpenNoOwner( const void* pBegin, int Size )
{
	MAID_ASSERT( pBegin==NULL, "̎w肪sł" );

	Close();

	m_pBegin = (unt08*)pBegin;
	m_Size   = Size;
	m_Position = 0;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@Cǂݍ
/*!
 *	Ȃǂ IFileRead::Read() QƂ邱
 */
int CFileReadMemory::Read( void* pData, int Size )
{
	MAID_ASSERT( !m_pBegin, "t@CJĂ܂" );

	const int ReadSize = MySTL::min( m_Size - m_Position, Size );

	if( ReadSize<=0 ) { return 0; }

	memcpy( pData, &(m_pBegin[m_Position]), ReadSize );

	m_Position += ReadSize;

	return ReadSize;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@CTCY̎擾
/*!
 *	Ȃǂ IFileRead::GetSize() QƂ邱
 */
int CFileReadMemory::GetSize() const
{
	MAID_ASSERT( !m_pBegin, "t@CJĂ܂" );

	return m_Size;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃t@C|WV̎擾
/*!
 *	Ȃǂ IFileRead::GetPosition() QƂ邱
 */
int CFileReadMemory::GetPosition() const
{
	MAID_ASSERT( !m_pBegin, "t@CJĂ܂" );

	return m_Position;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! t@C|WV̈ړ
/*!
 *	Ȃǂ IFileRead::Seek() QƂ邱
 */
void CFileReadMemory::Seek( int Size, IFileRead::POSITION ePos )
{
	MAID_ASSERT( !m_pBegin, "t@CJĂ܂" );

	switch( ePos )
	{
	case IFileRead::POSITION_BEGIN:
		{
			if( Size<0 )	{ m_Position = 0; }
			else			{ m_Position = Size; }
		}break;
	case IFileRead::POSITION_END:
		{
			if( 0<Size )	{ m_Position = m_Size; }
			else			{ m_Position = m_Size+Size; }
		}break;

	case IFileRead::POSITION_CURRENT:
		{
			m_Position += Size;
			if( m_Position < 0 )		{ m_Position = 0; }
			if( m_Size < m_Position )	{ m_Position = m_Size; }
		}break;
	}
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! JĂt@C
/*!
 *	Ȃǂ IFileRead::Close() QƂ邱
 */
void CFileReadMemory::Close()
{
	m_pShared.reset();
	m_pBegin     = NULL;
	m_Size       = 0;
	m_Position   = 0;
}


}
