/*!
 	@file 
 	@brief	̃t@Cǂݍ݂T|[gNX
\n			̃t@CpbNĂt@C̓ǂݍ(CPackFileManager)ɂΉĂ܂
 
 	@par A[JCut@C̎gp
 	@code

	CFileRead::GetArchiveFile().Mount( "Arc.dat" );	//	A[JCut@C}Eg


	CFileRead hFile;

	hFile.Open( "Arc\\sample.bmp" );	//   ۂɑ݂Ă Arc\sample.bmp T
										//	Ȃ Arc.dat  sample.bmp T܂B
 	@endcode
 */


#ifndef CFileRead_h
#define CFileRead_h

#include"../../Setup/CompileMode.h"
#include"../Debug/CAssert.h"
#include"../mstring.h"
#include"CFileReadInterface.h"
#include"CPackFileManager.h"
#include<vector>
#include<string>

#include<boost/smart_ptr.hpp>
#include"../Debug/CWarning.h"
#include<windows.h>

namespace Maid
{
	class CFileRead : public IFileRead
	{
	public:
		CFileRead();
		virtual ~CFileRead();

				void	Open( const mstring& FileName );
				void	OpenOnmemory( const mstring& FileName );
		virtual void	Close();
		virtual int		Read( void* pData, int Size );
		virtual void	Seek( int Size, IFileRead::POSITION ePos );
		virtual int		GetSize()    const;
		virtual int		GetPosition()const;

		void	SetPosition( int pos );

		const CFileRead& operator = ( const CFileRead& src )
		{
			if( src.m_pFile.get()==NULL ) { return *this; }

			if( src.m_IsOnmemory )	{ OpenOnmemory(src.m_FileName); }
			else					{ Open(src.m_FileName); }
			Seek( src.GetPosition(), IFileRead::POSITION_BEGIN );
			return *this;
		}

		bool IsEOF() const;

		unt08 Read1ByteBigEndian();
		unt16 Read2ByteBigEndian();
		unt32 Read3ByteBigEndian();
		unt32 Read4ByteBigEndian();
		float ReadfloatBigEndian();
		double ReaddoubleBigEndian();
		unt08 Read1ByteLittleEndian();
		unt16 Read2ByteLittleEndian();
		unt32 Read3ByteLittleEndian();
		unt32 Read4ByteLittleEndian();
		float ReadfloatLittleEndian();
		double ReaddoubleLittleEndian();

		mstring ReadString( int endian=1 );


		//! t@Cꊇǂݍ݂
		/*!
		 	 Open, Read Ə̂߂ǂ̂ŗpӂ܂
		 	ꊇǂݍ݂Ȃ̂ GetSize()%T != 0 ̎͊댯łB
		 
		 	@param	FileName	[i ]	ǂݍރt@C
		 	@param	Data		[ o]	o͐
		 
		 	@return	֐̐ DENRESULT_OK
		\n			ȊO͎s
		 
		 	@code
		 	MySTL::vector<STRUCT>	pData;
		 	CFileRead::Read( "hoge.dat", Data );	//	œǂݍ݂̏I
		 	@endcode
		 */
		
		template <typename T>
		static void	Read( const mstring& FileName, MySTL::vector<T>& Data )
		{
			CFileRead	hFile;

			hFile.Open( FileName );
			const unt32 Size = hFile.GetSize();

			if( Size==0 ) { return ; }

			MAID_ASSERT( Size%sizeof(T)!=0, "t@CTCYł" );

			Data.resize( Size/sizeof(T) );
			hFile.Read( &(Data[0]), Size );
		}

		//! t@Cꊇǂݍ݂BeLXgƂāB
		static void	Read( const mstring& FileName, MySTL::string& Text )
		{
			MySTL::vector<char> dat;

			Read( FileName, dat ); 

			dat.push_back('\0');
			Text = (char*)(&dat[0]);
		}

		static bool		IsExist( const mstring& FileName );
		static CPackFileManager& GetPackFile();

	private:
		boost::shared_ptr<IFileRead>	m_pFile;
		mstring							m_FileName;
		bool							m_IsOnmemory;
	private:
		static CPackFileManager s_PackManager;
	};
}
#endif
