#include"CString.h"
#include"macro.h"

#include<stdio.h>

namespace Maid
{
	namespace CString
	{
		//!	w肵1byteSJISǂf
		/*!	
			@retval true SJISł
			@retval false SJISłȂ
		*/
		bool IsSJIS1( char x )
		{
			return ((unsigned char)((x^0x20)-0xA1)<=0x3B);
		}

		//!	SJIS -> MJIS ւ̕ϊ
		/*!	
			@return MJISɂȂ
		*/
		mstring ConvertSJIStoMAID( const MySTL::string& str )
		{
			mstring ret;
			
			ret.reserve( str.length() );

			for( int i=0; i<(int)str.length(); ++i )
			{
				const char c = str[i];
				unt32 v;

				if( IsSJIS1(c) )
				{
					unt32 a = unt32(c)&0xFF;
					unt32 b = unt32(str[i+1])&0xFF;

					v = (a<<8) | b;
					++i;
				}else
				{
					v = unt32(c)&0xFF;
				}

				ret.push_back(v);
			}

			return ret;
		}

		unt32 ConvertCharaMAIDtoSJIS( const MySTL::string& str )
		{
			if( str.empty() ) { return 0; }
			const char c = str[0];
			unt32 v;

			if( IsSJIS1(c) )
			{
				unt32 a = unt32(c)&0xFF;
				unt32 b = unt32(str[1])&0xFF;

				v = (a<<8) | b;
			}else
			{
				v = unt32(c)&0xFF;
			}

			return v;
		}

		//!	MJIS -> SJIS ւ̕ϊ
		/*!	
			@return SJISɂȂ
		*/
		MySTL::string ConvertMAIDtoSJIS( const mstring& str )
		{
			MySTL::string ret;
			ret.reserve( str.length() );

			for( int i=0; i<(int)str.length(); ++i )
			{
				const unt32 c = str[i];

				ret += ConvertMAIDtoSJIS(c);
			}
			return ret;
		}



		MySTL::string ConvertMAIDtoSJIS( unt32 c )
		{
			MySTL::string ret;
			if( IsHankaku(c) )
			{
				ret.push_back((char)(c));
			}
			ef( IsGaizi(c) )
			{
				//	Ȍꍇ͕\łȂ̂ŃoOۂĂ
				ret += "";
			}
			else
			{
				ret.push_back((c>>8)&0xFF);
				ret.push_back(c&0xFF);
			}

			return ret;
		}

		//!	pH
		/*!
		 	@param	c	[i ]	ׂ镶
		 	@return	pȂ true
		 */
		bool  IsHankaku( unt32 c )
		{
			return c <= 0xFF;
		}

		//!	OH
		/*!
		 	@param	c	[i ]	ׂ镶
		 	@return	pȂ true
		 */
		bool  IsGaizi( unt32 c )
		{
			return IsBitOn(c,31);
		}

		unt32 MakeGaizi( unt32 c )
		{
			return BitOn( c, 31 );
		}

		int		CountByte( const mstring& str )
		{
			int ret = 0;
			for( int i=0; i<(int)str.length(); ++i )
			{
				const unt32 a = str[i];

				if( IsHankaku(a) ){ ret += 1;	}
				else			  { ret += 2;	}
			}

			return ret;
		}

		//!	ׂď
		/*!
		 	@param	str	[i ]	镶
		 	@return	ꂽ
		 */
		mstring ToLower( const mstring& str )
		{
			mstring ret;
			ret.resize( str.length() );
			for( int i=0; i<(int)str.length(); ++i )
			{
				const unt32 a = str[i];

				if( IsHankaku(a) ){ ret[i] = ::tolower((char)a);	}
				else			  { ret[i] = a;	}
			}

			return ret;
		}


		//!	pXfBNgo
		/*!
		 	"hoge/huga"  "hoge" Ԃ܂ ( / ͕t܂ )
		 
		 	@param	Path	[i ]	ofBNg
		 
		 	@return	fBNg
		 */
		mstring GetDirectory( const mstring& Path )
		{
			//	pX납猩ĂāA / or \ ؂ďI
			for( int i=int(Path.length())-1; i>=0; --i )
			{
				const unt32 c = Path[i];

				if( c=='\\' || c=='/' ) 
				{
					return Path.substr(0,i);
				}
			}

			return mstring();
		}


		//!	pXgqo
		/*!
		 	"hoge/huga.bmp"  "bmp" Ԃ܂ ( . ͕t܂ )
		 	"hoge/huga"  "" Ԃ܂ ( gqȂƔ肵܂ )
		 
		 	@param	Path	[i ]	ofBNg
		 
		 	@return	gq
		 */
		mstring GetExtension( const mstring& Path )
		{
			for( int i=0; i<(int)Path.length(); ++i )
			{
				const unt32 a = Path[i];

				if( a == '.'  )
				{
					return Path.substr(i+1);
				}
			}

			return mstring();
		}




		//!	pXt@Co
		/*!
		 	"hoge/huga"  "huga" Ԃ܂
		 
		 	@param	Path	[i ]	ofBNg
		 
		 	@return	t@C
		 */
		mstring GetFileName( const mstring& Path )
		{
			//	pX납猩ĂāA / or \ ؂ďI
			for( int i=int(Path.length())-1; i>=0; --i )
			{
				const wchar_t c = Path[i];

				if( c=='\\' || c=='/' ) 
				{
					return Path.substr(i+1);
				}
			}

			return Path;
		}

		int   AtoI( const mstring& str )
		{
			return ::atoi( ConvertMAIDtoSJIS(str).c_str() );
		}

		float AtoF( const mstring& str )
		{
			return (float)::atof( ConvertMAIDtoSJIS(str).c_str() );
		}

		mstring ItoA( int value )
		{
			char buf[256];
			::sprintf_s( buf, "%d", value );

			return ConvertSJIStoMAID(buf);
		}

		mstring FtoA( float value )
		{
			char buf[256];
			::sprintf_s( buf, "%f", value );

			return ConvertSJIStoMAID(buf);
		}
	}


}
