#include "CRand.h"

#include "Debug/CAssert.h"
#include<math.h>

extern "C" {

#include"../Import/sfmt/sfmt.h"
}
namespace Maid
{
	namespace CRand
	{

/*!
 	@class	CRand CRand.h
 	@brief	NX
 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! 0<=x<n ͈̔͂ŗ擾
/*!
 	@param	n	[i ]	͈́i̓AEgj
 */
unt	Get(unt n)
{
	if( n==0 ) { return 0; }
	return Get()%n;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! Min 0<= x < Max ͈̔͂ŗ擾
/*!
 	͕LȂ̂ŋC邱
 
 	@param	Min	[i ]	ŏl
 	@param	Max	[i ]	ől
 */
int	Get(int Min, int Max )
{
	MAID_ASSERT( !(Min<=Max), "̎w肪΂ł" <<  Min << " <= " << Max );
	return int(Get(abs(Max-Min)))+Min;
}


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! 1/n ̊m𖞂Ă邩ׂ
/*!
 	@param	n	[i ]	m
 */
bool Check(unt n)
{
	return Get(n)==0;
}


void SetSeed( unt Seed)
{
	init_gen_rand( Seed );
}


unt Get() 
{
	return gen_rand32();
}

}
}