/*!
 	@file
 	@brief	`ɏ܂ꂽt@C͂NX
\n			f[^ CData 
\n			̔zɂȂĂ̂ CDataTag
\n			ɂ̔zɂȂĂāAǂݏł̂ CDataFileParser
 */

#ifndef CDataFileParser_h
#define CDataFileParser_h

#include"../Setup/CompileMode.h"
#include"../auxiliary/mstring.h"
#include<vector>
#include<list>
#include<boost/smart_ptr.hpp>

namespace Maid
{
	class CDataFileParser;
	class CData
	{
		friend CDataFileParser;
	public:
		CData();
		CData( const mstring& text );
		CData( int val );

		mstring GetString()	const;
		int GetInteger()	const;

		enum TYPE
		{
			TYPE_STRING,	//!<	
			TYPE_INTEGER,	//!<	
		};

		TYPE GetType() const;

		void Reset( const mstring& str );

		const mstring GetFileTypeData() const;
	private:
		mstring	m_Data;
		TYPE	m_Type;
	};

	class CDataTag
	{
		friend CDataFileParser;
	public:
		CDataTag();
		~CDataTag();

		void	SetTagName( const mstring& TagName );
		void	AddData( const mstring& Data   );
		void	AddData( int Data   );
		void	AddData( const CData& Data   );
		void	SetData( unt Index, const CData& Data   );

		const mstring&	GetTagName() const;
		unt				GetLength() const;
		const CData&	GetData( unt Index ) const;

		mstring	GetStr( unt Index, const mstring& Default=mstring() ) const;
		int		GetNum( unt Index, int Default=0 )const;

	private:
		mstring					m_TagName;
		MySTL::vector<CData>	m_DataList;
	};

	typedef boost::shared_ptr<CDataTag>	SPDATATAG;

	class CDataFileParser
	{
		typedef MySTL::list<SPDATATAG> TAGLIST;
	public :
		CDataFileParser();
		virtual ~CDataFileParser();

		void Load( const mstring& FileName );
		void Load( const MySTL::vector<unt08>& Data );
		void Save( const mstring& FileName, bool IsCmpress=false );
		void Save( MySTL::vector<unt08>& Data, bool IsCmpress=false );

		SPDATATAG	NextTag();
		SPDATATAG	NextTag( const mstring& strTagName );
		SPDATATAG	SerchTag( const mstring& strTagName ) const;

		void InsertTag( const SPDATATAG& pTag );

		void Clear();
		void Reset();
	private:
		void Parse( const mstring& Data );
		bool IsCompressData( const MySTL::vector<unt08>& Data );

	private:
		TAGLIST				m_ParseData;
		TAGLIST::iterator	m_NowLine;
	};
}

#endif
