/*!
 	@file
 	@brief	CPỦZ\͂𒲂ׂNX
 */

#ifndef CCPUID_h
#define CCPUID_h

#include"../Setup/CompileMode.h"
#include"Macro.h"
#include"mstring.h"


namespace Maid
{

	namespace CCPUID
	{
		bool	IsCPUID();
		bool	GetCPUID( unt32 SetEAX, unt32& retEAX, unt32& retEBX, unt32& retECX, unt32& retEDX );
		bool	IsCPUIDFunction( unt32 Function, bool IsAMD=false );
		unt32	GetCPUClock();

		bool GetRDTSC( unt32& Over32, unt32& Less32 );

		enum 
		{
			CPUID_RDTSC			 = 0x00000010,	//!<	NbNJE^[
			CPUID_3DNOW			 = 1<<31,		//!<	3DNow!
			CPUID_EX3DNOW		 = 1<<30,		//!<	GnXh 3DNow!
			CPUID_MMX			 = 1<<23,		//!<	MMX
			CPUID_SSE			 = 1<<25,		//!<	SSE
			CPUID_SSE2			 = 1<<26,		//!<	SSE2
		};

		bool IsCPUMMX();
		bool IsCPUSSE();
		bool IsCPUSSE2();
		bool IsCPU3DNow();
		bool IsCPUEx3DNow();
		mstring	GetCPUName();

	};


}

#endif
