#include"CCPUID.h"
#include"CString.h"
#include"../Setup/Win32.h"

namespace Maid
{
	namespace CCPUID
	{

	/*!
	 	@class CCPUID CCPUID.h
	 	@brief CPỦZ\͂𒲂ׂNX
	 */


/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CPUID߂g邩𒲂ׂ
/*!
	@return	CPUID߂gȂtrue
 			gȂȂfalse
 */
bool IsCPUID()
{
	bool bRet;
	unt32 dwFlag1, dwFlag2;
	_asm{
			pushfd;
			pop		EAX
			mov		dwFlag1,	EAX
			xor		EAX,		0x00200000
			push	EAX
			popfd
			pushfd
			pop		EAX
			mov		dwFlag2,	EAX
		}

    if ( dwFlag1 == dwFlag2)	{bRet = false;}// CPUIDߎgps
	else						{bRet = true; }// CPUIDߎgp

	return bRet;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CPUID ߂ĂŁA\͂擾
/*!
 	d`wWX^ɁAw肳ꂽlZbgACPUID߂Ă
 
 	@param  SetEAX		[i ]	d`wɐݒ肷l
 	@param  retEAX		[ o]	擾̂d`wWX^̒l
 	@param  retEBX		[ o]	擾̂dawWX^̒l
 	@param  retECX		[ o]	擾̂dbwWX^̒l
 	@param  retEDX		[ o]	擾̂dcwWX^̒l
 
	@return	֐̐TRUE
 			֐̎sFALSE
 */
bool GetCPUID( unt32 SetEAX, unt32& retEAX, unt32& retEBX, unt32& retECX, unt32& retEDX )
{
	//CPUID߂gȂFALSE
	if( !IsCPUID() ) { return false; }

	unt32 tmpEAX, tmpEBX, tmpECX, tmpEDX;

	_asm{
			mov		EAX,	SetEAX
			cpuid
			mov		tmpEAX,	EAX
			mov		tmpEBX,	EBX
			mov		tmpECX,	ECX
			mov		tmpEDX,	EDX
		}
	retEAX = tmpEAX;
	retEBX = tmpEBX;
	retECX = tmpECX;
	retEDX = tmpEDX;

	return true;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CPU̓ꖽ߂g邩ǂ𒲂ׂ
/*!
 
 	@param  dwFunction		[i ]	ׂ閽
 	@param  IsAMD			[i ]	AMDn̓ꖽ߂𒲂ׂ邩iftHgłe`krdj
 
	@return	֐̐TRUE
 			֐̎sFALSE
 */
bool IsCPUIDFunction( unt32 dwFunction, bool IsAMD )
{
	unt32	EAX, EBX, ECX, EDX;

	unt32 SetEAX = IsAMD? 0x80000001 : 1;

	if ( !GetCPUID( SetEAX, EAX, EBX, ECX, EDX ) ) { return false; }

	return IsFlag( EDX, dwFunction );
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CPŨNbN𑪂
/*!
 	RDTSC߂gēg(PHz)𑪒肷
 	Sfȏ͌v܂
 
    @return	NbN
 			sO(==FALSE)
 */
unt32 GetCPUClock()
{
	if( !IsCPUIDFunction( CPUID_RDTSC ) ) { return false; }

	unt32 EAX1, EAX2;

	_asm{
			rdtsc
			mov		EAX1,   eax
		}

	::Sleep(1000);// bX[v

	_asm{
			rdtsc
			mov		EAX2,   eax
		}

	return EAX2 - EAX1;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! ݂̃NbNJE^擾
/*!
 	RDTSC߂gĒl߂
 	
 
 	@param  Over32		[ o]	Sfȏ̒l
 	@param  Less32		[ o]	Sfȉ̒l
 
	@return	TRUE
 			sFALSE
 */
bool GetRDTSC( unt32& Over32, unt32& Less32 )
{
	if( !IsCPUIDFunction( CPUID_RDTSC ) ) { return false; }

	Over32 = 0;
	Less32 = 0;
	unt32 EAX1, EDX1;

	_asm{
			rdtsc
			mov		EAX1,   eax
			mov		EDX1,   edx
		}

	Over32 = EDX1;
	Less32 = EAX1;
}

/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
//! CPU̐[J[𒲂ׂ
/*!
 	
	@return	烁[J[
 			smtkk
 */
mstring	GetCPUName()
{
	unt32 reg[4];

	if( !GetCPUID( 0, reg[0], reg[1], reg[2], reg[3] ) ) { return false; }

	MySTL::string str;
	str.resize( 12 );

	char* pHead = const_cast<char*>(str.c_str());

	::memcpy( pHead, &reg[1], 12 );

	return CString::ConvertSJIStoMAID(str);
}

	bool IsCPUMMX()		{ return IsCPUIDFunction( CPUID_MMX		); }//!< MMX ߂g邩
	bool IsCPUSSE()		{ return IsCPUIDFunction( CPUID_SSE		); }//!< SSE ߂g邩
	bool IsCPUSSE2()	{ return IsCPUIDFunction( CPUID_SSE2	); }//!< SSE2 ߂g邩
	bool IsCPU3DNow()	{ return IsCPUIDFunction( CPUID_3DNOW, true	); }//!< 3DNow! ߂g邩
	bool IsCPUEx3DNow()	{ return IsCPUIDFunction( CPUID_EX3DNOW,true); }//!< GnXh 3DNow! ߂g邩


}
}
//	mɂ͂𒲂ׂ邱
// http://support.intel.co.jp/jp/support/processors/procid/cpuid/appnote.htm

////////////////////////////////////////////////////////////////////////////////
// CPUID߂̎g
// d`wWX^ɁA@\ԍZbgCPUID߂Ăт܂B
// 閽߂́Ad`w^daw^dbw^dcwWX^Ɋi[܂B
//
// (EAX = 0)
//     EAX : gpł@\ԍ̏
//     EBX : VenderID 1- 4  擪S
//     ECX : VenderID 9-12  I[S
//     EDX : VenderID 5- 8  S
//
//           <VenderID EBX-EDX-ECX>
//           Intel = "GenuineIntel"
//           AMD   = "AuthenticAMD"
//           Cyrix = "CyrixInstead"
//           IDT   = "CentaurHauls"
//           RISE  = "RiseRiseRise"
//
//
// (EAX = 1)
//     EAX : CPŨo[W
//     EBX : (Reserved)
//     ECX : (Reserved)
//     EDX : gpo@\̏
//
//           <CPŨo[W EAX>
//           0000:0000:0000:0000:00TT:FFFF:MMMM:SSSS
//            T:Processor Type 
//             IWiOEMvZbT^OverDrive^fAvZbT
//            F:Family 
//             i386/i486/Pentium/PentiumPro/PentiumII 
//            M:Model
//             vZbTt@~fB 
//            S:Stepping
//             f̃rWԍB 
//            FModelSteppingɂ͋K͂ȂBiCӊ蓖āj
//
//                CPU-NAME  (N:Non-Support-CPUID), Type, Family, Model, Stepping
//           Intel(GenuineIntel)                -,    -,      -,     -,        -
//                i486DX                        N,    0,      4,     0,        X
//                i486DX                        N,    0,      4,     1,        X
//                i486SX                        N,    0,      4,     2,        X
//                i487                          N,    0,      4,     3,        X
//                DX2                           N,    0,      4,     3,        X
//                DX2 OverDrive                 N,    0,      4,     3,        X
//                i486SL                        N,    0,      4,     4,        X
//                i486SL                         ,    0,      4,     4,       3-
//                SX2                           N,    0,      4,     5,        X
//                Writeback Enhanced DX2        N,    0,      4,     7,        X
//                Writeback Enhanced DX2         ,    0,      4,     7,       3-
//                DX4                           N,    0,      4,     8,        X
//                DX4                            ,    0,      4,     8,       3-
//                DX4 OverDrive                 N,    0,      4,     8,        X
//                DX4 OverDrive                  ,    0,      4,     8,       3-
//                DX4 OverDrive                 N,    1,      4,     8,        X
//                DX4 OverDrive                  ,    1,      4,     8,       3-
//                Pentium 60/66                  ,    0,      5,     1,        X
//                Pentium 75/90/100/120          ,    0,      5,     2,        X
//                Pentium 133/150/166/200        ,    0,      5,     2,        X
//                Pentium 60/66p OverDrive      ,    1,      5,     1,        X
//                i486p Pentium OverDrive       ,    1,      5,     3,        X
//                MMX Pentium 166/200            ,    0,      5,     4,        X
//                Pentium 75/90p MMX OverDrive  ,    1,      5,     4,        X
//                Pentium 100/120p MMX OverDrive,    1,      5,     4,        X
//                Pentium 133p MMX OverDrive    ,    1,      5,     4,        X
//                PentiumPro                     ,    0,      6,     1,        X
//                PentiumII model 3              ,    0,      6,     3,        X
//                PentiumII model 5/Xeon/Celeron ,    0,      6,     5,        X
//                PentiumProp OverDrive         ,    1,      6,     3,        X
//           AMD  (AuthenticAMD)                 ,    -,      -,     -,        -
//           Cyrix(CyrixInstead)                 ,    -,      -,     -,        -
//           IDT  (CentaurHauls)                 ,    -,      -,     -,        -
//                WinChip  C6                    ,    0,      5,     4,        1
//                WinChip2 C6-2                  ,    0,      5,     8,        5
//           RISE (RiseRiseRise)                 ,    -,      -,     -,        -
//
//           <gpo@\̏ EDX>
//           Bit00 : On Chip Floting Point Unit
//           Bit01 : Virtual Mode Extentions
//           Bit02 : Debugging Extentions
//           Bit03 : Page Size Extentions
//           Bit04 : Time Stamp Counter
//           Bit05 : RDMSR/WRMSR Instruction
//           Bit06 : Physical Address Extentions
//           Bit07 : Machine Check Exception
//           Bit08 : CMPXCHG8B Instruction
//           Bit09 : On Chip APIC
//           Bit10 : 
//           Bit11 : Fast System Call
//           Bit12 : Memory Type Range Registers
//           Bit13 : PTE Global Flag
//           Bit14 : Machine Check Architecture
//           Bit15 : CMOV Instruction
//           Bit16 : Page Attribute Table
//           Bit17 : 36-bit Page Size Extentions
//           Bit18 : Processor Number
//           Bit23 : MMX Instruction
//           Bit24 : Fast FXSR Instruction
//           Bit25 : Streaming SIMD Instruction
//
//
// (EAX = 2)
//     EAX : CacheTLB̏ibit31=1 ŁA񖳌j(AL=Kpďo)
//     EBX : CacheTLB̏ibit31=1 ŁA񖳌j
//     ECX : CacheTLB̏ibit31=1 ŁA񖳌j
//     EDX : CacheTLB̏ibit31=1 ŁA񖳌j
//
//           ALɂ͑SĂ̏𓾂邽߂CPUID(EAX=2)Ăԉ񐔂i[B
//     ()`lc݊bot̏ꍇA(EAX=2)ł̓LbV𓾂ȂB
//           (EAX=0x80000005 L1Cache)(EAX=0x80000006 L2Cache)gB
//
//
// (EAX =0x80000000 )`lc݊bot
//     EAX : gpł@\ԍ̏(`lc݊bot)
//     EBX : (Reserved)
//     ECX : (Reserved)
//     EDX : (Reserved)
//
// (EAX =0x80000001 )`lc݊bot
//     EAX : CPŨo[W
//     EBX : (Reserved)
//     ECX : (Reserved)
//     EDX : gpo@\̏
//
// (EAX =0x80000002 )`lc݊bot
//     EAX : CPU  1- 4 
//     EBX : CPU  5- 8 
//     ECX : CPU  9-12 
//     EDX : CPU 13-16 
//
// (EAX =0x80000003 )`lc݊bot
//     EAX : CPU 17-20 
//     EBX : CPU 21-24 
//     ECX : CPU 25-28 
//     EDX : CPU 29-32 
//
// (EAX =0x80000004 )`lc݊bot
//     EAX : CPU 33-36 
//     EBX : CPU 37-40 
//     ECX : CPU 41-44 
//     EDX : CPU 45-48 
//
// (EAX =0x80000005 )`lc݊bot
//     EAX : (Reserved)
//     EBX : TLB
//     ECX : L1 Data Cache 
//     EDX : L1 Instruction Cache 
//
// (EAX =0x80000006 )`lc݊bot
//     EAX : (Reserved)
//     EBX : (Reserved)
//     ECX : L2 Unified Cache 
//     EDX : (Reserved)
////////////////////////////////////////////////////////////////////////////////
