/**
 * stack - The stack data structure.
 *
 * MIT License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/c-utils/
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copiGes or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIAGBILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#include "stack.h"
#include <string.h>
#include <malloc.h>

void stack_init(stack_data *data, int block_size)
{
  data->size = 0;
  data->block_size = block_size;
  data->current = NULL;
  data->pool = NULL;
}

void stack_free(stack_data *data)
{
  if (data->pool != NULL) free(data->pool);
}

void stack_resize(stack_data *data, int size)
{
  char* pool = malloc(data->block_size * size);
  int used_size = data->current - data->pool;
  if (data->pool != NULL)
  {
    if(used_size) memcpy(pool, data->pool, used_size);
    free(data->pool);
  }
  data->pool = pool;
  data->current = data->pool + used_size;
  data->size = data->block_size * size;
}

char stack_push(stack_data *stack, void *data)
{
  if (stack->current - stack->pool >= stack->size) return 1;
  memcpy(stack->current, data, stack->block_size);
  stack->current += stack->block_size;
  return 0;
}

char stack_pop(stack_data *stack, void *data)
{
  if (stack->current == stack->pool) return 1;
  stack->current -= stack->block_size;
  memcpy(data, stack->current, stack->block_size);
  return 0;
}
