/**
 * LiveML - LiveML is screen(graphic) controling library using XML.
 *
 * LGPL License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/liveml/
 * All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#include "xmlparser_tinyxml.h"

bool XMLParserTinyXML::loadText(const char *text)
{
  TiXmlDocument doc;
  doc.Parse(text);

  TiXmlElement *root = doc.RootElement();
  if (!root) return false;

  return parse(root) != NULL;
}

bool XMLParserTinyXML::loadFile(const char *file)
{
  TiXmlDocument doc;

  DCODE(printf("load file: %s\n", file);)
  if (!doc.LoadFile(file))
  {
    DCODE(printf("can't load file: %s\n", file);)
    return false;
  }

  TiXmlElement *root = doc.RootElement();
  if (!root) return false;

  XMLElement* rootTag = parse(root);

  DCODE(printf("loaded file: %s\n", file);)

  return rootTag != NULL;
}

XMLElement* XMLParserTinyXML::parse(TiXmlElement *el)
{
  TagType *rt = _tagTypeContainer[el->Value()];

  if (rt == NULL)
  {
    DCODE(printf("undefined tag: %s\n", el->Value());)
    return NULL;
  }

  if (!checkTagLevel(rt))
  {
    DCODE(printf("invalid tag: %s[valid tags: %s]\n", el->Value(), rt->parent);)
    return NULL;
  }

  DCODE(printf("start tag: %s\n", el->Value());)

  XMLElement *tag = new XMLElement(rt);
  if (rootNode == NULL) rootNode = tag;

  setCurrentTag(tag);

  // set parameters
  ParameterOption *elementPo = NULL;
  DCODE(printf("start param\n");)
  for (size_t i = 0; i < rt->countParameter(); i++)
  {
    ParameterOption &po = *rt->getParameter(i);

    DCODE(printf("index: %d name: %s type: %d\n", po.getIndex(), po.getName().c_str(), po.getType());)
    if (po.getName() == "")
    {
      elementPo = &po;
      continue;
    }

    const char *value = el->Attribute(po.getName().c_str());
    if (value != NULL)
    {
      XMLParameter *param = _parameterTypes[po.getType()].func(value, *this);
      if (param != NULL) tag->param.set(po.getIndex(), param);
    }
  }
  DCODE(printf("end param\n");)

  XML_TAGRTN result = XML_TAGRTN_NULL;
  if (rt->hasFunction())
  {
    result = (*rt->getFunction())(tag->param, *this);

    switch (result)
    {
    case XML_TAGRTN_LEVEL:
      {
        XMLElement **ltag = tagLevelList.push_back();
        *ltag = tag;
        DCODE(printf("LEVEL ADD: %s\n", (*ltag)->type->getName().c_str());)
      }
      break;
    case XML_TAGRTN_STOP:
      return NULL;
      break;
    case XML_TAGRTN_SKIP:
      return NULL;
      break;
    }
  }

  XMLNode *childTag = NULL, *childTagPrev = NULL;
  for (TiXmlNode *node = el->FirstChild(); node; node = node->NextSibling())
  {
    switch (node->Type())
    {
    case TiXmlNode::TEXT:
      childTag = new XMLTextNode(node->Value());
      break;
    case TiXmlNode::ELEMENT:
      setParentTag(tag);
      childTag = parse(node->ToElement());
      break;
    default:
      continue;
    }
    if (childTag == NULL) continue;

    if (childTagPrev == NULL) tag->child = childTag;
    else childTagPrev->next = childTag;

    childTagPrev = childTag;
  }

  if (rt->hasCloseFunction())
  {
    (*rt->getCloseFunction())(tag->param, *this);
  }

  if (elementPo != NULL && tag->child)
  {
    setCurrentTag(tag);
    XMLParameter *param = _parameterTypes[elementPo->getType()].func(el->GetText(), *this);
    tag->param.set(elementPo->getIndex(), param);
  }

  if (result == XML_TAGRTN_LEVEL)
  {
    DCODE(XMLElement *ltag = *tagLevelList.back();
    printf("LEVEL DELETE: %s\n", ltag->type->getName().c_str());)
    tagLevelList.remove(tagLevelList.back());
  }

  return tag;
}

