/**
 * LiveML - LiveML is screen(graphic) controling library using XML.
 *
 * LGPL License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/liveml/
 * All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#include "xmlparser.h"

XMLParser::XMLParser(void) :
PARAM_STRING(registerParameterType(paramString))
{
  tagLevelList.resize(20);  // unauthorised
  setCurrentTag(NULL);
  setParentTag(NULL);
  rootNode = NULL;
}

XMLParser::~XMLParser()
{
  clearNode();
}

void XMLParser::clearNode(void)
{
  delete rootNode;
}

param_type XMLParser::registerParameterType(XMLParameter*(*func)(const char*, XMLParser&))
{
  _parameterTypes.resize(_parameterTypes.size() + 1);
  _parameterTypes.back().func = func;

  return _parameterTypes.size() - 1;
}

bool XMLParser::checkTagLevel(TagType *type)
{
  if (type->parent == NULL) return true;

  if (tagLevelList.back() == NULL) return false;

  const char *parentName = (*tagLevelList.back())->type->getName().c_str();
  char pool[100];
  char *tagNames = pool;
  char *cur = tagNames;
  bool found = false, last = false;

  strcpy(tagNames, type->parent);

  while ('\0' != *cur)
  {
    tagNames++;
    switch (*tagNames)
    {
    case '\0':
      last = true;
    case ' ':
      if (!last) *tagNames = '\0';
      found = !strcmp(parentName, cur);
      if (!last)
      {
        *tagNames = ' ';
        tagNames++;
      }
      cur = tagNames;
      break;
    }
    if (found) break;
  }

  return found;
}

// parameter types

PARAMFUNC(XMLParser::paramString)
{
  return new XMLString(value);
}
