/**
 * calcu - original calculation.
 *
 * MIT License
 * Copyright (C) 2010 Nothan
 * http://github.com/nothan/c-utils/
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Nothan
 * private@nothan.xrea.jp
 *
 * Tsuioku Denrai
 * http://tsuioku-denrai.xrea.jp/
 */

#ifndef __CALCU_H__
#define __CALCU_H__

#include "stack.h"
#include "fixed_float.h"

typedef unsigned int variable_size;
typedef struct
{
  fixed_float value;
  const char *ptr;
} calcu_decode_data;

typedef struct
{
  char *text;
  char *first;
  char *last;
} calcu_encode_data;

enum
{
  CALCU_VARIABLE = 'v',
  CALCU_NUMERIC = 'n',
  CALCU_ELEMENT = 'e',
  CALCU_EOC = '\0'
};

#ifdef __cplusplus
extern "C" {
#endif

void calcu_decode_callback(fixed_float (*)(const char**, void*));
void calcu_encode_callback(int (*)(char**, char**, void*));
void calcu_decode_workarea(void *);
void calcu_encode_workarea(void *);

calcu_decode_data calcu_decode(const char *);
calcu_encode_data calcu_encode(char*, char *);

#ifdef __cplusplus
}
#endif

#endif
