#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
#
# mkstatus.pl -- Configure.help ιܤǧ.
# Copyright (C) 1999: by FUKUSHIMA Osamu <fuku@amorph.rim.or.jp>
# $Id: mkstatus.pl,v 1.5 2000/01/12 08:12:36 fuku Exp $
# 

use strict;
use Getopt::Std;
use vars qw(%opts);
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

getopts('has', \%opts);

my $reserve_file = "Reserved.list";
my $non_res_word = "(nobody)";
my @configure = (@ARGV);
my $num_files = @configure;
my $latest    = $configure[$num_files - 1];
my $all_item  = 1 if $opts{'a'};

my $current_version = $num_files - 1;

my $j;
my @HT;
for ($j = 0; $j < $num_files; $j++) {
  tie(%{$HT[$j]}, 'DB_File', "Mod_$configure[$j].db",
      O_RDONLY, 0644, $DB_BTREE) or die "cant open Mod_$configure[$j].db";
}

my $cnf = get_cnflist($latest);
my $res = {};
open(R, $reserve_file) or die;
while (<R>) {
  next if /^\#/;
  next if /^$/;
  chomp;
  my @w = split;
  $res->{$w[0]} = $w[2] if $w[2];
}
close R;

my $C = {};

foreach my $key (@$cnf) {

  my $last_flag = "";
  my $point = 0;
  my @e;

  for ($j = 0; $j < $num_files; $j++) {
    my $e  = " ";
    $e = $HT[$j]{$key} if $HT[$j]{$key};
    
    if ($last_flag) {
      # 2 Ĥʹߤ Config files.

      #  version ̤ä:
      if (($last_flag eq "U") || ($last_flag eq "")) {

	# ⤷ file ǤƤ顢Ϥ version 
	# ʤ줿Ȥˤʤ.
	if ( -r "TRANS-$configure[$j]/$key" ) {
	  $last_flag = "T";
	  $e = "T";
	} else {
	  # file ʤСѤ餺̤Ǥ롣
	  # ⤷status  "-" (same) ʤ顢flag Ѥ餺
	  # ̤ˤʤ.
	  $last_flag = "U";
	  $e = "x" if $e eq "-";
	  $point++;
	}
      } else {
        if ($e eq "*" ) {
	  # ΥСǹ줿
	  if ( -r "TRANS-$configure[$j]/$key" ) {
	    # ⤷ ե뤬СλѤ.
	    $last_flag = "T";
	    $e = "T";
	  } else {
	    # Ǥʤ̤.
	    $last_flag = "U";
	    $point++;
	  }
	}
      }

    } else {
      # ǽ Config file.

      if ( -r "TRANS-$configure[$j]/$key" )  {
	# ⤷ ե뤬СλѤ.
	$last_flag = "T";
	$e = "T";

      } elsif ($e eq "-"){
	# ⤷ status  "-" (same) ޤ trans-file ʤ顢
	# λѤ.
	$last_flag = "T";
	
      }  else {
	# Ǥʤ̤.
	if ($HT[$j]{$key}) {
	  $last_flag = "U";
	  $point++ if $HT[$j]{$key};
	}
      }
      $last_flag = "" unless $e;
    }
    push(@e, $e);
  }
  $C->{$key}->{"stat"} = \@e if ($point || $all_item);
  if ($point) {
    if ($res->{$key}){
      $C->{$key}->{"reserve"} = "$res->{$key}";
    } else {
      $C->{$key}->{"reserve"} = $non_res_word;
    }
  }
}



if ($opts{'h'}) {
  if ($all_item) {
    print "ʲѤߤΤΤդơ٤ɽƤޤ";
    print "<BR><A HREF=\"Configure-Status.html\">";
    print "̤ΤߤΥꥹȤϤ</A><BR>";
  } else {
    print "ʲ̤ΤΤܤΤɽƤޤ";
    print "<BR><A HREF=\"Configure-Status-all.html\">ܥꥹȤϤ</A>";
    print "(ɽʤΤդƤ)<BR>";
  }
  
  print "<TABLE BORDER=\"1\">\n<TD></TD>";
  foreach (@configure) {
    if (/.*\-(.*)/) {
      print "<TD>$1</TD>";
    }
  }
  print "<TD>reservation</TD>\n";
  foreach my $key (@$cnf) {
    unless ($all_item) {
      next unless $C->{$key}->{"stat"};
    }
    print "<TR align=\"left\"><TD><A HREF=\"CONFIG-Configure.help-2.2.$current_version/$key\">$key</A></TD>\n";
    foreach my $s (@{$C->{$key}->{"stat"}}) {
      my $color = "#f0f0f0";
    COLOR_SWITCH: {
	if ($s eq "N") { $color = "#d05050"; last COLOR_SWITCH; }
	if ($s eq "x") { $color = "#d0d090"; last COLOR_SWITCH; }
	if ($s eq "T") { $color = "#c0f0f0"; last COLOR_SWITCH; }
	if ($s eq "*") { $color = "#d09090"; last COLOR_SWITCH; }
      }
      print "  <TD align=\"center\" bgcolor=\"$color\"> $s </TD>\n";
    }
    if ($C->{$key}->{"reserve"}){
      print "  <TD>$C->{$key}->{'reserve'}</TD>\n";
    } else {
      print "  <TD> </TD>\n";
    }
    print "</TR>\n";
  }
  print "\n</TABLE>\n";
} elsif ($opts{'s'}) {

  my $no_wdiff = system("which wdiff>& /dev/null");

  my @vers;
  foreach (@configure) {
    if (/.*\-(.*)/) {
      push(@vers, $1);
    }
  }
  foreach my $key (@$cnf) {
    unless ($all_item) {
      next unless $C->{$key}->{"stat"};
    }
    printf("%-36s", $key);
    printf("%-12s", $C->{$key}->{"reserve"}) if $C->{$key}->{"reserve"};
    print " ";
    my $j = 0;
    my $k = 0;
    foreach my $q (@{$C->{$key}->{"stat"}}) {
      if (($q eq "N") || ($q eq "*")) {
	print "," if $k;
	print " $vers[$j]";
	if ($q eq "N") {
	  print "(N)";
	} else {
	  unless ($no_wdiff) {
	    my @par;
	    open(WD,"wdiff -s3 CONFIG-$configure[$j-1]/$key CONFIG-$configure[$j]/$key | tail -2 |")
	      or die;
	    while (<WD>) {
	      if (/^.*\s(\d+)%\scommon/) 
		{
		  push(@par, $1);
		}
	    }
	    close WD;
	    my $rpar;
	    if ($par[0] > $par[1]) {
	      $rpar = $par[1];
	    } else {
	      $rpar = $par[0];
	    }
	    print "($rpar%)";
	  }
	}
	$k++;
      }
      $j++;
    }
    print "\n";
  }

} else {
  print "                                       ";
  my @vers;
  foreach (@configure) {
    if (/.*\-(.*)/) {
      push(@vers, $1);
      printf("%-7s ", $1);
    }
  }
  print "\n ---------------------------------------------------------------\n";

  foreach my $key (@$cnf) {
    unless ($all_item) {
      next unless $C->{$key}->{"stat"};
    }
    printf("%-38s", $key);
    foreach (@{$C->{$key}->{"stat"}}) {
      print "   $_    ";
    }
    print $C->{$key}->{"reserve"} if $C->{$key}->{"reserve"};
    print "\n";
  }
}
