#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
#
# merge_trans.pl -- Configure.help ޡ.
# Copyright (C) 1999: by FUKUSHIMA Osamu <fuku@amorph.rim.or.jp>
# $Id: merge_trans.pl,v 1.7 2002/04/24 10:30:55 mdk Exp $
# 

use strict;
use DB_File;
use KernelConf qw(:DEFAULT :LOCKS);;

my @configure = @ARGV;
my $num_files = @configure;
my $latest    = $configure[$num_files - 1];

my $jmessage = 
  {"modified" => "ιܤϸŤС󤬸ˤʤäƤޤ",
   "new" => "ιܤϤΥСǿɲä, ̤Ǥ",
   "yet" => "ΥСΤΤ̤Ǥ"};

my $k;
my @HT;

for ($k = 0; $k < $num_files; $k++) {

  my $oldnum       = $k - 1;
     $oldnum       = $k if $k == 0;
  my $oldconfig    = $configure[$oldnum];
  my $oldconfdir   = "CONFIG-$oldconfig";
  my $oldtransdir  = "TRANS-$oldconfig";
  my $newconfig    = $configure[$k];
  my $newconfdir   = "CONFIG-$newconfig";
  my $newtransdir  = "TRANS-$newconfig";
  my $based_ver_dir = "TRANS-$configure[0]";

  mkdir($newtransdir, 0755) unless -d $newtransdir;

  print "$oldconfig -> $newconfig...\n";

  tie(%{$HT[$k]}, 'DB_File', "Mod_$newconfig.db",
      O_RDONLY, 0644, $DB_BTREE) or die "cant open Mod_$newconfig.db";

  open(TR, ">$newconfig.ja") or die;

  &itemcopy(*TR, "$newtransdir/header.txt", 1)
    if -r "$newtransdir/header.txt";

  my $cnf = get_cnflist($newconfig);
  foreach my $key (@$cnf) {

    &itemcopy(*TR, "$newconfdir/$key");

    my $status = $HT[$k]{$key};

    if ($status) {
      
      if ($status eq "-") {
	if ( -r "$oldtransdir/$key" ) {
	  system("cp -up $oldtransdir/$key $newtransdir/$key") if $k;
	  &itemcopy(*TR, "$newtransdir/$key");
	} else {
	  # ˸ŤСλѹä
	  print TR "  ** $jmessage->{'yet'} **\n\n";
	  for (my $i = $oldnum - 1; $i >= 0; $i--) {
	    if (-r "TRANS-$configure[$i]/$key") {
	      &itemcopy(*TR, "TRANS-$configure[$i]/$key");
	      last;
	    }
	  }
	}

      } elsif ($status eq "\*") {

	if ( -r "$newtransdir/$key" ) {
	  &itemcopy(*TR, "$newtransdir/$key");
	} else {
	  # ΥСѹä
	  if ( -r "$oldtransdir/$key" ) {
	    print TR "  ** $jmessage->{'modified'} **\n\n";
	    &itemcopy(*TR, "$oldtransdir/$key");
	  } else {
	    # ˸ŤСλǤѹä
	    print TR "  ** $jmessage->{'yet'} **\n\n";
	    for (my $i = $oldnum - 1; $i >= 0; $i--) {
	      if (-r "TRANS-$configure[$i]/$key") {
		&itemcopy(*TR, "TRANS-$configure[$i]/$key");
		last;
	      }
            }
	  }

	}

      } elsif ($status eq "N") {
	
	if (-r "$newtransdir/$key"){
	  &itemcopy(*TR, "$newtransdir/$key") 
	} else {
	  # ΥСɲä줿
	  print TR "  ** $jmessage->{'new'} **\n\n";
	}
      }
    }
  }
  &itemcopy(*TR, "$newtransdir/translators", 1)
    if -r "$newtransdir/translators";
  my $date = localtime;
  print TR "# $date\n";
  close TR;

}

    
sub itemcopy {

  local(*NEW_FILE) = shift(@_);
  my $file = $_[0];
  my $cut_comment = 1 unless $_[1];
  my $loop_check  = 1 if $_[2];

  unless (open(D, $file)){
    warn "cannot open $file";
    return;
  }

  my $i = 0;
  while (<D>) {
    # link check. (added by fxima in Yamagata City.)
    if (/^USE\s+(.*)\s*$/) {
      die "found error in $file (USE $1)" if $loop_check;
      my $lv = $1;
      my $destfile = $file;
      $destfile =~ s,.*/,TRANS-Configure.help-$lv/,;
      if (-r "$destfile") {
	&itemcopy(*NEW_FILE, "$destfile", 1, 1);
      }else {
	print STDERR "*** faild to link with $destfile\n";
	print STDERR "*** Please check $file\n";
      }
      $i = 1;
      last;
    }
    next if /^\#/ && $cut_comment;

    if (/^\s*$/) {
      next if $i;
      $i = 1;
    } else {
      $i = 0;
    }
    print NEW_FILE $_;
  }
  print NEW_FILE "\n" unless $i;
  close D;
}

