
_echo_red()
{
	echo -e "\e[31m${@}\e[m"
}
_echo_blue()
{
	echo -e "\e[34m${@}\e[m"
}
_echo_green()
{
	echo -e "\e[32m${@}\e[m"
}
_echo_purple()
{
	echo -e "\e[35m${@}\e[m"
}

_logfile()
{
	echo /tmp/bean_pkginst.log
}

_postfile()
{
	echo /tmp/bean_pkginst_post.txt
}

_log()
{
	_echo_green "$@"
	echo "[$(date '+%F %R.%S')] [OK]    $@" >> $(_logfile)
}

_err()
{
	_echo_red "$@"
	echo "[$(date '+%F %R.%S')] [ERROR] $@" >> $(_logfile)
}

_postreg()
{
	echo "$@" >> $(_postfile)
}

_check()
{
	local i
	local pkgs
#	local cache=/tmp/_bean_pkginst_dpkg
	
#	if [ -f "${cache}"] ; then
#		pkgs=$(cat "${cache}")
#	else
		pkgs=$(dpkg -l | grep -v ^rc | awk '{print $2}')
#		echo "${pkgs}" > "${cache}"
#	fi

	# 一つでもインストールされていない場合はnを返す
	for i in $@ ; do
		if [ $(echo "${pkgs}" | grep "${i}" | wc -l) -lt 1 ] ; then
			echo n
			return 0
		fi
	done
	echo y
}

_clean()
{
	echo -----
	echo 不要になったパッケージとキャッシュと消去します。
	echo 
	
	if sudo apt-get autoremove ; then
		_log "不要パッケージのアンインストールに成功しました。"
	else
		_err "不要パッケージのアンインストールに失敗しました。"
		exit 1
	fi
	
	sudo dpkg --purge $(dpkg -l | grep ^rc | cut -f3 -d " ") 2>/dev/null
	sudo apt-get autoclean
	sudo apt-get clean
	echo
	return 0
}

_update()
{
	local tempfile=/tmp/$(mktemp XXXXXXXX)
	
	echo -----
	echo データベースを最新の状態に更新します。
	sudo apt-get update | tee ${tempfile}
	
	if [ $(cat ${tempfile} | grep "エラー" | wc -l) -lt 10 ] ; then
		_log "パッケージデータベースの更新に成功しました。"
	else
		_err "パッケージデータベースのダウンロードに失敗しました。"
		return 1
	fi
	rm -f ${tempfile}
	
	sudo apt-get autoclean
	sudo apt-get clean
	echo
	return 0
}

_install()
{
	echo -----
	echo パッケージ $@ をインストールします。
	echo
	
	if sudo apt-get install --no-install-recommends $@ ; then
		_log "$@ のインストールに成功しました。"
	else
		_err "$@ のインストールに失敗しました。"
		exit 1
	fi
	
	echo
	return 0
}

_purge()
{
	echo -----
	echo パッケージ $@ をアンインストールします。
	echo
	
	if sudo apt-get purge $@ ; then
		_log "$@ のアンインストールに成功しました。"
	else
		_err "$@ のアンインストールに失敗しました。"
		exit 1
	fi
	
	echo
	return 0
}

_desktop()
{
	local desktop
	desktop=$(eval echo $(cat "${HOME}/.config/user-dirs.dirs" | grep ^XDG_DESKTOP_DIR= | grep -o '=.*$' | sed -e 's/"//igm' -e 's/=//igm'))
	if [ ! "$desktop" == "" ] ; then
		echo "$desktop"
	else
		if [ -d "$HOME/デスクトップ" ] ; then
			echo "$HOME/デスクトップ"
		elif [ -d "$HOME/Desktop" ] ; then
			echo "$HOME/Desktop"
		elif [ -d "$HOME/ドキュメント" ] ; then
			echo "$HOME/ドキュメント"
		elif [ -d "$HOME/Documents" ] ; then
			echo "$HOME/Documents"
		else
			echo "$HOME"
		fi
	fi
}
