Bean_PathConv()
{
  # 出力ファイル名の設定
  echo $1 | awk '{gsub("file://","")}{print}' | nkf --url-input --utf8
}

Bean_GetNoExt()
{
  _fname_ext="${1##*/}"
  echo "${_fname_ext%.*}"
}

Bean_TempPath()
{
  if [ -d "$HOME/デスクトップ" ] ; then
    echo "$HOME/デスクトップ"

  elif [ -d "$HOME/Desktop" ] ; then
    echo "$HOME/Desktop"

  elif [ -d "$HOME/ドキュメント" ] ; then
    echo "$HOME/ドキュメント"

  elif [ -d "$HOME/Documents" ] ; then
    echo "$HOME/Documents"

  else
    echo "$HOME"

  fi
}

Bean_ProcExist()
{
  _PE=`ps x | grep "$1" | grep -v grep | wc -l`
  if [ $_PE -ne 0 ] ; then
    printf "y"
  else
    printf "n"
  fi
}

Bean_OpenWithFM()
{
  if   [ `Bean_ProcExist pcmanfm` = "y" ] ; then
    pcmanfm "$1"
  elif [ `Bean_ProcExist thunar` = "y" ] ; then
    thunar "$1"
  elif [ `Bean_ProcExist Thunar` = "y" ] ; then
    Thunar "$1"
  elif [ `Bean_ProcExist nautilus` = "y" ] ; then
    nautilus "$1"
  elif [ `Bean_ProcExist Nautilus` = "y" ] ; then
    Nautilus "$1"
  elif [ -e "/usr/bin/pcmanfm" ] ; then
    pcmanfm "$1"
  elif [ -e "/usr/bin/thunar" ] ; then
    thunar "$1"
  elif [ -e "/usr/bin/Thunar" ] ; then
    Thunar "$1"
  elif [ -e "/usr/bin/nautilus" ] ; then
    nautilus "$1"
  elif [ -e "/usr/bin/Nautilus" ] ; then
    Nautilus "$1"
  fi
}

Bean_CopyToClip()
{
  printf "$1" | xclip -selection primary
  printf "$1" | xclip -selection secondary
  printf "$1" | xclip -selection clipboard
}

Bean_GetActivePID()
{
  _WID=`xprop -root | awk '/_NET_ACTIVE_WINDOW\(WINDOW\)/{print $5}'`
  _PID=`xprop -id $_WID | awk '/_NET_WM_PID\(CARDINAL\)/{print $NF}'`
  printf $_PID
}

Bean_GetActiveWName()
{
  _WID=`xprop -root | awk '/_NET_ACTIVE_WINDOW\(WINDOW\)/{print $5}' | sed -e 's/,//' -e 's/^0x/0x0/'`
  _WName=`wmctrl -l | grep $_WID | sed -e 's/^0x[^ ]\+ \+[^ ]\+ \+[^ ]\+ \+//'`
  echo $_WName
}

Bean_GetPID()
{
  _WID=`wmctrl -l | grep $1 | awk '{print $1}' | sed -e 's/^0x0/0x/'`
  _PID=`xprop -id $_WID | awk '/_NET_WM_PID\(CARDINAL\)/{print $NF}'`
  printf $_PID
}

Bean_GetWName()
{
  _WName=`wmctrl -l | grep $1 | sed -e 's/^0x[^ ]\+ \+[^ ]\+ \+[^ ]\+ \+//'`
  echo $_WName
}

