/*
	tHgǗNX

		Tab(4) Font(10) VC2003.NET

													Make:  2007/11/2
											 Last Update:  2007/11/2
												  Author:  
*/


/*
@߁I
	VXetHgDirectX̃tHg͕ʁI

*/

#include "dxSysAfx.h"
#include "dxSysFontCtrl.h"

FontManager*	g_dxFontManager;

FontManager::FontManager()
{
	for(int i=0;i<MAX_FONT;i++)
	{
		m_SysFont[i]=NULL;
		m_DXFont[i]=NULL;
	}
	m_DXFontMax=0;
	m_SysFontMax=0;
	m_hOldFont = NULL;
	m_systemSet = false;
	m_hwnd = ::GetActiveWindow();
	m_hdc = ::GetDC( m_hwnd );
	Initialize();
}

FontManager::~FontManager()
{	
	DeviceLost();
	for(int i=0;i<MAX_FONT;i++)
	{
		SAFE_DELETE(m_SysFont[i]);
		SAFE_DELETE(m_DXFont[i]);
	}
}

void	FontManager::DeviceLost()
{
	for(int i=0;i<MAX_FONT;i++)
	{
		if(m_SysFont[i]) DeleteObject(m_SysFont[i]->hFont);
		if(m_DXFont[i]) SAFE_RELEASE(m_DXFont[i]->logFont);
	}
	DeleteObject(m_hOldFont);
}

//tHg폜
void	FontManager::DeleteSFont( int fID )
{
	if( fID < 1 && fID >= MAX_FONT ) return;
	if(m_SysFont[fID])
	{
		m_SysFont[fID]->refCnt--;
		if(m_SysFont[fID]->refCnt<=0) DeleteObject(m_SysFont[fID]->hFont);
	}
}

void	FontManager::DeleteDFont( int fID )
{
	if( fID < 1 && fID >= MAX_FONT ) return;
	if(m_DXFont[fID])
	{
		m_DXFont[fID]->refCnt--;
		if(m_DXFont[fID]->refCnt<=0) SAFE_RELEASE(m_DXFont[fID]->logFont);
	}
}

//tHggp
void	FontManager::UseSFont( int fID )
{
	if( fID < 0 && fID >= MAX_FONT ) return;
	if(m_SysFont[fID])
	{
		m_SysFont[fID]->refCnt++;
	}
}
void	FontManager::UseDFont( int fID )
{
	if( fID < 0 && fID >= MAX_FONT ) return;
	if(m_DXFont[fID])
	{
		m_DXFont[fID]->refCnt++;
	}
}

//tHgݒ(VXe)
void	FontManager::SetSystemFont( int fID )
{
	if(m_systemSet){ return; }
	m_hwnd = ::GetActiveWindow();
	m_hdc = ::GetDC( m_hwnd );
	m_hOldFont = (HFONT)SelectObject( m_hdc, this->m_SysFont[fID]->hFont );
	m_systemSet = true;
}

//tHgݒ߂(VXe)
void	FontManager::ReSetSystemFont()
{
	m_hwnd = ::GetActiveWindow();
	m_hdc = ::GetDC( m_hwnd );
	if(m_systemSet) DeleteObject( SelectObject( m_hdc, m_hOldFont ) );
	else return;
	m_systemSet = false;
}

//tHg擾(VXe)
HFONT*	FontManager::GetSFont( int fID )
{
	if( fID < 0 && fID >= MAX_FONT ) return NULL;
	if(m_SysFont[fID])
	{
		return &m_SysFont[fID]->hFont;
	}
	return NULL;
}

//eNX`擾(DirectX)
LPD3DXFONT*	FontManager::GetDFont( int fID )
{
	if( fID < 0 && fID >= MAX_FONT ) return NULL;
	if(m_DXFont[fID])
	{
		return &m_DXFont[fID]->logFont;
	}
	return NULL;
}

/*
	ftHgtHgݒ
*/
void	FontManager::Initialize()
{
	DXFONT dbg_set;

	dbg_set.Setting.Height          = FONT_SIZE;		//tHg̕Z܂͕̍						
	dbg_set.Setting.Width           = 0;				//tHg̕̕ (_P)
//	logdbg_set.Settingfont.Escapement		= ;			//̕XƂ̊px
//	dbg_set.Setting.Orientation		= ;					//x[XCXƂ̊px
	dbg_set.Setting.Weight          = FW_DEMIBOLD;		//tHg̃EFCg (0 ` 1,000 ͈̔)
	dbg_set.Setting.Italic			= FALSE;			//C^bN̎w
//	dbg_set.Setting.Underline		= FALSE;			//tw
//	dbg_set.Setting.StrikeOut		= FALSE;			//łtw
	dbg_set.Setting.CharSet         = SHIFTJIS_CHARSET;	//Zbg
	dbg_set.Setting.OutputPrecision = OUT_TT_PRECIS;	//o͐x
	dbg_set.Setting.Quality         = PROOF_QUALITY /*| ANTIALIASED_QUALITY*/;	//o͕i(25|CgȏłȂƃA`GCAX͂Ȃ)
	dbg_set.Setting.MipLevels       = 0;				//v~bv x̐
	dbg_set.Setting.PitchAndFamily  = DEFAULT_PITCH || FF_MODERN;	//tHg̃sb`ƃt@~
	lstrcpy(dbg_set.Setting.FaceName, "lr@SVbN");			//tHg̖̏w肷 NULL I[

	this->m_DXFont[0] = new DXFONT;
	memcpy( this->m_DXFont[0], &dbg_set, sizeof(DXFONT) );
	HRESULT hr;
	if( FAILED( hr = D3DXCreateFontIndirect( MCR_DEVICE, &this->m_DXFont[0]->Setting, &this->m_DXFont[0]->logFont) ) ){
	}
	else this->m_DXFontMax++;

	this->m_SysFont[0] = new SYSFONT;

	this->m_SysFont[0]->size = FONT_SIZE;					//tHg
	this->m_SysFont[0]->width=0;							//
	this->m_SysFont[0]->arg_t=0;							//eLXg̊px
	this->m_SysFont[0]->arg_base=0;							//x[XCƂƂ̊px
	this->m_SysFont[0]->bold=FW_DEMIBOLD;					//tHg̏dij
	this->m_SysFont[0]->italic=FALSE;						//C^bN
	this->m_SysFont[0]->ubderline=FALSE;					//A_[C
	this->m_SysFont[0]->Stripe=FALSE;						//ł
	this->m_SysFont[0]->charset=SHIFTJIS_CHARSET;			//Zbg
	this->m_SysFont[0]->out=OUT_TT_PRECIS;					//o͐x
	this->m_SysFont[0]->clip=CLIP_DEFAULT_PRECIS;			//NbsOx
	this->m_SysFont[0]->quality=PROOF_QUALITY;				//o͕i
	this->m_SysFont[0]->pitch_f=(FIXED_PITCH | FF_MODERN);	//sb`ƃt@~[
	strcpy( this->m_SysFont[0]->face, "lr@SVbN");	//̖
	if( (this->m_SysFont[0]->hFont = ::CreateFont(
				FONT_SIZE,				// tHg
				0,						// 			
				0,						// eLXg̊px	
				0,						// x[XCƂƂ̊px
				FW_DEMIBOLD,			// tHg̏dij
				FALSE,					// C^bN
				FALSE,					// A_[C
				FALSE,					// ł
				SHIFTJIS_CHARSET,		// Zbg
				OUT_TT_PRECIS,			// o͐x
				CLIP_DEFAULT_PRECIS,	// NbsOx
				PROOF_QUALITY,			// o͕i
				(FIXED_PITCH | FF_MODERN),// sb`ƃt@~[
				"lr@SVbN"		// ̖
			)) == NULL )
	{
	}
	else this->m_SysFontMax++;
}

void	FontManager::DebugWrite( DWORD xDraw, DWORD yDraw, const TCHAR* Str,... )
{
	TCHAR Buffer[4096];
	vsprintf( Buffer, Str, (char *)(&Str + 1) );

	int i=0;
	int width=0,height=1,w=0;
	while( Buffer[i] != NULL )
	{
		w++;
		if( Buffer[i] == '\n' )
		{
			if( w > width ) width = w;
			w=0;
			height++;
		}
		i++;
	}
	if( w > width ) width = w;

	DWORD dw = (DWORD)(this->m_DXFont[0]->Setting.Height*500/400) * width;
	DWORD dh = (DWORD)this->m_DXFont[0]->Setting.Height * height;

	RECT rect={ xDraw, yDraw, xDraw+dw, yDraw+dh };
	this->m_DXFont[0]->logFont->DrawText(NULL,				//Spritẽ|C^ NULLłOK
								Buffer,						//`悷镶̃|C^w肵܂B
								-1,                         //܂B-1̏ꍇ͑SĂ`悵܂B
								&rect,                      //`̈
								DT_LEFT | DT_NOCLIP,        //ōȂǂݒ肵܂B
								0xFFFFFFFF );				//̐F߂܂B
}


//tHg𐶐
int		FontManager::CreateFont( SYSFONT &set )
{
	if( this->m_SysFontMax+1 > MAX_FONT  ) return -1;

	this->m_SysFont[this->m_SysFontMax] = new SYSFONT;
	memcpy( this->m_SysFont[this->m_SysFontMax], &set, sizeof(SYSFONT) );

	SYSFONT* i = this->m_SysFont[this->m_SysFontMax];
	if( (i->hFont = ::CreateFont(
			i->size,		//tHg
			i->width,		//
			i->arg_t,		//eLXg̊px
			i->arg_base,	//x[XCƂƂ̊px
			i->bold,		//tHg̏dij
			i->italic,		//C^bN
			i->ubderline,	//A_[C
			i->Stripe,		//ł
			i->charset,		//Zbg
			i->out,			//o͐x
			i->clip,		//NbsOx
			i->quality,		//o͕i
			i->pitch_f,		//sb`ƃt@~[
			i->face			//̖
			)) == NULL )
	{
		return -1;
	}

	this->m_SysFontMax++;
	return (this->m_SysFontMax-1);
}

int		FontManager::CreateFont( DXFONT  &set )
{
	set.Setting.Height          = FONT_SIZE;		//tHg̕Z܂͕̍						
	set.Setting.Width           = 0;				//tHg̕̕ (_P)
//	set.Settingfont.Escapement	= ;					//̕XƂ̊px
//	set.Setting.Orientation		= ;					//x[XCXƂ̊px
	set.Setting.Weight          = FW_DEMIBOLD;		//tHg̃EFCg (0 ` 1,000 ͈̔)
	set.Setting.Italic			= FALSE;			//C^bN̎w
//	set.Setting.Underline		= FALSE;			//tw
//	set.Setting.StrikeOut		= FALSE;			//łtw
	set.Setting.CharSet         = SHIFTJIS_CHARSET;	//Zbg
	set.Setting.OutputPrecision = OUT_TT_PRECIS;	//o͐x
	set.Setting.Quality         = PROOF_QUALITY /*| ANTIALIASED_QUALITY*/;	//o͕i(25|CgȏłȂƃA`GCAX͂Ȃ)
	set.Setting.MipLevels       = 0;				//v~bv x̐
	set.Setting.PitchAndFamily  = DEFAULT_PITCH || FF_MODERN;	//tHg̃sb`ƃt@~
	lstrcpy(set.Setting.FaceName, "lr@SVbN");			//tHg̖̏w肷 NULL I[

	this->m_DXFont[this->m_DXFontMax] = new DXFONT;
	memcpy( &this->m_DXFont[this->m_DXFontMax]->Setting, &set, sizeof(DXFONT) );
	HRESULT hr;
	if( FAILED( hr = D3DXCreateFontIndirect( MCR_DEVICE, &this->m_DXFont[this->m_DXFontMax]->Setting, &this->m_DXFont[this->m_DXFontMax]->logFont) ) ){
		return -1;
	}

	this->m_DXFontMax++;
	return (this->m_DXFontMax-1);
}