/*
	`nǗNX

		Tab(4) Font(10) VC2003.NET

													Make:  2007/8/21
											 Last Update:  2007/12/25
												  Author:  
*/


/*
@߁I

  h[p[cNX̂̓|S܂B
  h[p[ćA|S悭`悷邽߂́ue@vł܂B

@ʏAh[p[cnNX̓eNX`̘A`ɖȂėpĂ܂
@VF[_gꍇAOIȃv_(XeVȂ)ꍇ
@̃^[QbgNXł̌pĂ܂B
*/

/*
@œKėp̎i]͎l(NH[^jI)ŕ\ׂł̂ŌB
@߂ǂ̂Ō񂵁B
*/

////////////////////////////////////////////////////////////////////////////////////////
// Include

#include "dxSysAfx.h"
#include "dxSysDraw.h"
//#include "dxSysUtility.h"
#include "dxSysTexCtrl.h"
#include "dxSysCamera.h"

////////////////////////////////////////////////////////////////////////////////////////
// Global
RenderingManager*	g_dxRenderMan;


////////////////////////////////////////////////////////////////////////////////////////

/*!
	@breif	`p֐
	@note	GodHand̂݃R[ł܂B
*/
void	DrawRenderingManager()
{
	g_dxRenderMan->Draw();
}

////////////////////////////////////////////////////////////////////////////////////////
// ClassMember


////////////////////////////////////////////////////////////////////////////////////////
// `p[c
////////////////////////////////////////////////////////////////////////////////////////

/*!
	@breif	RXgN^
	@note
*/
DrawParts::DrawParts()
{
	this->m_PriorityLayer	=  0;	//Dxɂ郌C[BႢق獂ق֕`悳Ă䂭B
	this->m_ObjectID		= -1;	//C[̃IuWFNghc
	this->m_TextureID		= -1;	//eNX`[hc

	this->m_VexNums			=  0;	//_
	this->m_IndexNums		= -1;	//CfbNX(0ȉŖ)
	this->m_VexList			= NULL;	//_Xg(_͊Oˑł)
	this->m_IndexList		= NULL;	//CfbNXXg
    this->m_pMesh			= NULL;	//bV|C^

	ZeroMemory( &m_vec3Scale, sizeof(D3DXVECTOR3) );	//g嗦
	ZeroMemory( &m_vec3Rot, sizeof(D3DXVECTOR3) );		//]@
	ZeroMemory( &m_vec3Pos, sizeof(D3DXVECTOR3) );		//ʒu

	D3DXMatrixIdentity( &m_matWorld );					//[h}gbNX

	this->m_eRendStyle		= DRAWPRIMITIVEUP_NOINDEX;		//`X^C
	this->m_ePrimStyle		= TRIANGLELIST;					//|S`X^C
	this->m_FVFState		= 0;							//_tH[}bgݒl

	ZeroMemory( &m_stRenderState, sizeof(RENDERSTATES) );	//_[Xe[g̐ݒ\

	this->m_pMatt = NULL;
	this->m_lpVexBuff = NULL;
}

/*!
	@breif	fXgN^
	@note
*/
DrawParts::~DrawParts()
{
	SAFE_DELETE_ARRAY( this->m_pMatt );
	SAFE_RELEASE( this->m_lpVexBuff );
	SAFE_RELEASE( this->m_pMesh );
//	//o^
//	if( g_dxRenderMan )
//	{
//		g_dxRenderMan->Delete(this);
//	}
}

/*!
	@breif	`X^Cݒ肵܂
	@note	X^C̃ftHgDRAWPRIMITIVEUP_NOINDEXłB
	@param[in]	ERENDERSTYLE	`X^C
*/
void	DrawParts::SetRenderStyle(ERENDERSTYLE eStyle)
{
	this->m_eRendStyle = eStyle;		//`X^C
}

/*!
	@breif	_Xg̔zX^Cݒ肵܂
	@note	X^C̃ftHgTRIANGLELISTłB
	@param[in]	EPRIMITIVESLE	_Xg̔zX^C
*/
void	DrawParts::SetPrimitiveStyle(EPRIMITIVESLE eStyle)
{
	this->m_ePrimStyle = eStyle;		//|S`X^C
}

/*!
	@breif	eNX`ݒ肵܂(hc)
	@note	͂܂B
	@param[in]	int		eNX`hc
*/
void	DrawParts::SetTexture(int texID)
{
	this->m_TextureID = texID;		//eNX`[hc
}

/*!
	@breif	eNX`ݒ肵܂
	@note	t@CeNX`쐬܂B
	@note	(ɂꍇ͂hcݒ肳܂)
	@param[in]	TCHAR*	t@C
*/
void	DrawParts::SetTexture(const TCHAR* fname)
{
	//₢킹EKv	
	//this->m_TextureID = 0;		//eNX`[hc
}

/*!
	@breif	_tH[}bg(eue)ݒ肵܂
	@note	ڂeuelDirectX̃wvQƂĂB
	@param[in]	DWORD	FVFl
*/
void	DrawParts::SetFVF(DWORD FVFState)
{
	this->m_FVFState = FVFState;
}

/*!
	@breif	_Xgݒ肵܂
	@note	_̕`Jnʒu𓊂邱(vex[0]Ȃ)
	@note	|C^(4oCg)^ꍇAx_CAOo܂B
	@param[in]	template<T>VEXTYPE	_Xg̊Jnʒu
	@param[in]	int					_
*/
template<typename VEXTYPE>
void	DrawParts::SetVertexList(VEXTYPE& vl, int vexNums)
{
	this->m_VexList = &vl;
	this->m_VexNums = vexNums;
	this->m_VertexSize = sizeof(VEXTYPE);
	assert(this->m_VertexSize!=4);		//|C^Ă܂x
}

/*!
	@breif	CfbNXXgݒ肵܂
	@note	`INDEXLIST=short*@łB
	@note	4oCg̃CfbNXgpꍇ͒`ύX肢܂B
	@param[in]	INDEXLIST	CfbNXXg
	@param[in]	int			CfbNX
*/
void	DrawParts::SetIndexList(INDEXLIST il, int indexNums)
{
	this->m_IndexList = il;
	this->m_IndexNums = indexNums;
}

/*!
	@breif	_bN
	@note	X^CDrawPrimitiven̂ݗLłBRc_̂ݗLłB
	@param[in]	VERTEX	_Xg̊Jnʒu
*/
//template<typename VT>
void	DrawParts::Send(VERTEX& vl)
{
//	assert(sizeof(VEXTYPE)!=4);		//|C^Ă܂x
//	assert(this->m_VexNums);		//_TCYOŐݒ肳Ă܂x

	//bN
	VERTEX *v;
	if( !m_lpVexBuff ) MCR_DEVICE->CreateVertexBuffer(sizeof(VERTEX) * this->m_VexNums,0,this->m_FVFState,D3DPOOL_MANAGED,&m_lpVexBuff,NULL);
	m_lpVexBuff->Lock(0,0,(void **)&v,0);
	memcpy(v,&vl,sizeof(VERTEX)*this->m_VexNums);
	m_lpVexBuff->Unlock();
}

/*!
	@breif	bVt@C쐬܂
	@note	݂͊ȈՓIȂ̂łB
	@note	Aj[VRei̍쐬܂ł܂ނׂłB
	@param[in]	TCHAR*	fname
	@return	LPD3DXMESH	bV|C^
*/
LPD3DXMESH	DrawParts::MeshLoad(const TCHAR* fname)
{
	LPD3DXBUFFER	pD3DBufMtr;	// D3DBufferIuWFNgւ̃|C^
	HRESULT			hr;			// COMG[R[h
	m_numMatt=0;

	//Ajۂ
	//if( D3DXLoadMeshHierarchyFromX() )
	//{
	//}
	hr = D3DXLoadMeshFromX(
		fname,					// t@C
		D3DXMESH_SYSTEMMEM,		// VXeɃ[h
		MCR_DEVICE,				// Direct3DDeviceIuWFNg
		NULL,
		&pD3DBufMtr,			// D3DXMATERIAL\̂̔z
		NULL,
		&m_numMatt,				// }eÃO[v̐󂯎AhX
		&m_pMesh				// D3DXMESHIuWFNg̃C^[tFCX󂯎AhX
	);

	// D3DXMATERIAL\̂̔zւ̃|C^擾
	D3DXMATERIAL* d3dxmatrs = 
	(D3DXMATERIAL*)pD3DBufMtr->GetBufferPointer(); 

	// D3DMATERIAL9\̂̔zm
	m_pMatt = new D3DMATERIAL9[m_numMatt];
	for (int i = 0; i < (int)m_numMatt; i++)
	{
		m_pMatt[i] = d3dxmatrs[i].MatD3D; // ގ̏Rs[
	} 
	
	pD3DBufMtr->Release(); // D3DXBUFFERIuWFNg

	return m_pMesh;
}

/*!
	@breif	OōbVݒ肵܂
	@note	bV|C^Rs[ۂ́A[NɋCtĂB
	@note	Rs[OɓĂ郁bVJۂ́Aʂ̊֐ĂłB
	@param[in]	LPD3DXMESH	bV|C^
*/
void	DrawParts::AttachMesh(LPD3DXMESH pMesh)
{
	//łɃ|C^ꍇ͊JB
	//if(m_pMesh) SAFE_RELEASE(m_pMesh);
	m_pMesh = pMesh;
}

/*!
	@breif	w肳ꂽDxC[Ƀ_Oo^܂
	@note	Ă΂Ȃƕ`悵܂B
	@note	VC[쐬ꍇAC[ݒ肪V܂B
	@param[in]	int	C[ԍ
*/
void	DrawParts::AddRender( int PriorityLayer )
{
	if( g_dxRenderMan )
	{
		g_dxRenderMan->Addin(this,PriorityLayer);
	}
}

/*!
	@breif	DxC[폜܂
	@note	łB
*/
void	DrawParts::DelRender()
{
	//o^
	if( g_dxRenderMan )
	{
		g_dxRenderMan->Delete(this);
	}
}

/*!
	@breif	DxC[ύX܂B
	@note	łB
	@param[in]	int	VDxC[
*/
void	DrawParts::CngLayer( int PriorityLayer )
{
}

/*!
	@breif	IuWFNg̕`揇𑁂߂ɓւ܂B(-1Ő擪)
	@note	łB
	@param[in]	int	߂鐔B-1Ő擪B
*/
void	DrawParts::CngFaster( int Fast )
{
}

/*!
	@breif	IuWFNg̕`揇x߂ɓւ܂B(-1ōŌ)
	@note	łB
	@param[in]	int	x鐔B-1ōŌB
*/
void	DrawParts::CngLaster( int Last )
{
}

/*!
	@breif	XP[lݒ肵܂(ꊇ)
	@note	S̒lnꂽlɂȂ܂B
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	XP[l
*/
void	DrawParts::SetScale( FLOAT fScale )
{
	this->m_vec3Scale.x = fScale;
	this->m_vec3Scale.y = fScale;
	this->m_vec3Scale.z = fScale;
}

/*!
	@breif	XP[lݒ肵܂(X)
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	wXP[l
	@param[in]	FLOAT	xXP[l
	@param[in]	FLOAT	yXP[l
*/
void	DrawParts::SetScale( FLOAT x,FLOAT y, FLOAT z )
{
	this->m_vec3Scale.x = x;
	this->m_vec3Scale.y = y;
	this->m_vec3Scale.z = z;
}

/*!
	@breif	]lݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	w]l([)
	@param[in]	FLOAT	x]l(sb`)
	@param[in]	FLOAT	y]l([)
*/
void	DrawParts::SetRot( FLOAT x,FLOAT y, FLOAT z )
{
	this->m_vec3Rot.x = x;
	this->m_vec3Rot.y = y;
	this->m_vec3Rot.z = z;
}

/*!
	@breif	w]ݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	w]l([)
*/
void	DrawParts::SetRotX( FLOAT x )
{
	this->m_vec3Rot.x = x;
}

/*!
	@breif	x]lݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	x]l(sb`)
*/
void	DrawParts::SetRotY( FLOAT y )
{
	this->m_vec3Rot.y = y;
}

/*!
	@breif	y]lݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	y]l([)
*/
void	DrawParts::SetRotZ( FLOAT z )
{
	this->m_vec3Rot.z = z;
}

/*!
	@breif	]lZ܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	w]Zl([)
	@param[in]	FLOAT	x]Zl(sb`)
	@param[in]	FLOAT	y]Zl([)
*/
void	DrawParts::AddRot( FLOAT x,FLOAT y, FLOAT z )
{
	this->m_vec3Rot.x += x;
	this->m_vec3Rot.y += y;
	this->m_vec3Rot.z += z;
}

/*!
	@breif	ʒuݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	w[hʒu
	@param[in]	FLOAT	x[hʒu
	@param[in]	FLOAT	y[hʒu
*/
void	DrawParts::SetPos( FLOAT x,FLOAT y, FLOAT z )
{
	this->m_vec3Pos.x = x;
	this->m_vec3Pos.y = y;
	this->m_vec3Pos.z = z;
}

/*!
	@breif	wʒuݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	w[hʒu
*/
void	DrawParts::SetPosX( FLOAT x )
{
	this->m_vec3Pos.x = x;
}

/*!
	@breif	xʒuݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	x[hʒu
*/
void	DrawParts::SetPosY( FLOAT y )
{
	this->m_vec3Pos.y = y;
}

/*!
	@breif	yʒuݒ肵܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	y[hʒu
*/
void	DrawParts::SetPosZ( FLOAT z )
{
	this->m_vec3Pos.z = z;
}

/*!
	@breif	ʒuZ܂
	@note	XV֐Ă΂ȂA}gbNXɂ͔f܂B
	@param[in]	FLOAT	w[hʒuZl
	@param[in]	FLOAT	x[hʒuZl
	@param[in]	FLOAT	y[hʒuZl
*/
void	DrawParts::AddPos( FLOAT x,FLOAT y, FLOAT z )
{
	this->m_vec3Pos.x += x;
	this->m_vec3Pos.y += y;
	this->m_vec3Pos.z += z;
}

/*!
	@breif	sČvZ
	@note	XV֐łBelύXɌĂł(œK̂)B
	@note	Ă΂ȂAߋ̏񂪎gp܂B
*/
void	DrawParts::Refresh()
{
	D3DXMATRIX matScale,matRot,matTrans;
	D3DXMatrixIdentity( &m_matWorld );												//[h}gbNX
	D3DXMatrixScaling(&matScale,m_vec3Scale.x,m_vec3Scale.y,m_vec3Scale.z);			//g	kĂ܂
	D3DXMatrixRotationYawPitchRoll(&matRot,m_vec3Rot.y,m_vec3Rot.x,m_vec3Rot.z);	//Yaw = Y]	Pitch = X]	Roll = Z]
	D3DXMatrixTranslation(&matTrans,m_vec3Pos.x,m_vec3Pos.y,m_vec3Pos.z);			//sړ܂B
	m_matWorld = matScale * matRot * matTrans;										//s̉Zɒ	߂ɂ낢ςĂ݂ĂB
}

/*!
	@breif	`֐
	@note	ėpd֐łBpł̃I[o[Ch𐄏܂B
	@note	F}l[W[ꊇČĂяo܂B@XŌĂԂƂ͔ĂB
*/
void	DrawParts::Rendering()
{
	//===============================================================
	//`悷邽߂̏ݒ肵Ă܂B
	//===============================================================
	MCR_DEVICE->SetFVF(this->m_FVFState);
	MCR_DEVICE->SetTexture(0,MCR_GETTEX(this->m_TextureID));
	MCR_DEVICE->SetTransform(D3DTS_WORLD,&m_matWorld);		//[hsSet

	//===============================================================
	//`悵܂B
	//TRIANGLE_LIST͒_̐3Ŋƃ|S̐߂܂B
	//===============================================================

//`eNX`o
	if( GetAsyncKeyState(VK_SPACE) )
	{ 
		TCHAR Filename[MAX_PATH];
 		sprintf( Filename, "TextureID[%d].bmp",this->m_TextureID );
		D3DXSaveTextureToFile(Filename, D3DXIFF_BMP, MCR_GETTEX(this->m_TextureID), NULL );
	}

	/*
	POINTLIST             = 1,		//_`悵܂Bڍׂ́u|CgXvCgvŌĂB
    LINELIST              = 2,		//`悵܂BXgnłB
    LINESTRIP             = 3,		//`悵܂BXgbvnłB
    TRIANGLELIST          = 4,		//|S`悵܂BXgnłB
    TRIANGLESTRIP         = 5,		//|S`悵܂BXgbvnłB
    TRIANGLEFAN           = 6,		//|S`悵܂B钸_ƂāAɃ|S`悵܂B
*/
	UINT pCnt = 0;
	if( this->m_IndexNums == -1 )
	{
		switch( this->m_ePrimStyle )
		{
		case LINESTRIP:
			pCnt = this->m_VexNums / 2+1;
			break;
		case LINELIST:
			pCnt = this->m_VexNums / 2;
			break;
		case TRIANGLESTRIP:
			pCnt = this->m_VexNums / 3+1;
			break;
		case TRIANGLELIST:
			pCnt = this->m_VexNums / 3;
			break;
		default:
			break;
		}
	}

	HRESULT hr;
	switch( this->m_eRendStyle )
	{
	case DRAWPRIMITIVEUP_NOINDEX:
		hr = MCR_DEVICE->DrawPrimitiveUP((D3DPRIMITIVETYPE)this->m_ePrimStyle,pCnt,this->m_VexList,this->m_VertexSize);
		break;
	case DRAWPRIMITIVE_NOINDEX:
		MCR_DEVICE->SetStreamSource(0,this->m_lpVexBuff,0,this->m_VertexSize);
		hr = MCR_DEVICE->DrawPrimitive((D3DPRIMITIVETYPE)this->m_ePrimStyle,0,pCnt);
		break;
	case DRAWMESH:

		for(int i=0; i<m_numMatt;i++)
		{
			MCR_DEVICE->SetTexture(0,MCR_GETTEX(this->m_TextureID));
			MCR_DEVICE->SetMaterial(&m_pMatt[i]); // foCXɃ}eAݒ
			hr = m_pMesh->DrawSubset(i);
		}
		break;
	}
}



////////////////////////////////////////////////////////////////////////////////////////
//_ݒn

/*!
	@breif	_Fꊇݒ
	@note	VERTEX̐擪|C^PQ`PUoCgڂQƂĂ܂B
	@note@	IWi̒_`gpꍇ͎gpĂB
	@param[in]	D3DCOLOR(DWORD)		F
*/
void	DrawParts::SetColor(D3DCOLOR color)
{
	if(this->m_VexList==NULL) return;
	for(int i=0;i<this->m_VexNums;i++)
	{
		((VERTEX*)this->m_VexList+i)->c = color;
	}
}

/*!
	@breif	_ʒuݒ
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX*	Rc_̃|C^
	@param[in]	float	wʒu
	@param[in]	float	xʒu
	@param[in]	float	yʒu
*/
void	DrawParts::SetPos(VERTEX* v,float x,float y,float z)
{
	v->x = x;	v->y = y;	v->z = z;
}

/*!
	@breif	Fݒ
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX*			Rc_̃|C^
	@param[in]	D3DCOLOR(DWORD)	F
*/
void	DrawParts::SetColor(VERTEX* v,D3DCOLOR color)
{
	v->c = color;
}

/*!
	@breif	eNX`tulݒ
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX*	Rc_
	@param[in]	float	tʒu
	@param[in]	float	uʒu
*/
void	DrawParts::SetUV(VERTEX* v,float tu,float tv)
{
	v->u = tu;	v->v = tv;
}

/*!
	@breif	_ꊇݒ
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX*			Rc_
	@param[in]	float			wʒu
	@param[in]	float			xʒu
	@param[in]	float			yʒu
	@param[in]	D3DCOLOR(DWORD)	F
	@param[in]	float			tʒu
	@param[in]	float			uʒu
*/
void	DrawParts::SetVertex(VERTEX* v,float x,float y,float z,D3DCOLOR color,float tu,float tv)
{
	v->x = x;	v->y = y;	v->z = z;
	v->c = color;
	v->u = tu;	v->v = tv;
}

/*!
	@breif	Qc_ݒ
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX2D*		Qc_
	@param[in]	float			wʒu
	@param[in]	float			xʒu
	@param[in]	float			yʒu
	@param[in]	float			qgvl(1.0fŃXN[lɕϊ܂)
	@param[in]	D3DCOLOR(DWORD)	F
	@param[in]	float			tʒu
	@param[in]	float			uʒu
*/
void	DrawParts::SetVertex2D(VERTEX2D* v,float x,float y,float z,float rhw,D3DCOLOR color,float tu,float tv)
{
	v->x = x;	v->y = y;	v->z = z;
	v->c = color;
	v->rhw = rhw;
	v->u = tu;	v->v = tv;
}

/*!
	@breif	XvbgݒŒ_̋`ݒ肵܂B
	@note	_͂SKvłB
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX2D*		i[Qc_Xg̃|C^
	@param[in]	float			wʒu
	@param[in]	float			xʒu
	@param[in]	float			yʒu
	@param[in]	float			`̕
	@param[in]	float			`̍
	@param[in]	D3DCOLOR(DWORD)	F
*/
void	DrawParts::SetVertexSquareSprit(VERTEX2D* vl,float x,float y,float z,float w,float h,D3DCOLOR col)
{
	SetVertex2D( &vl[0], x		,y		,z,1.0f,col,0.0f,0.0f);
	SetVertex2D( &vl[1], x+w	,y		,z,1.0f,col,1.0f,0.0f);
	SetVertex2D( &vl[2], x		,y+h	,z,1.0f,col,0.0f,1.0f);
	SetVertex2D( &vl[3], x+w	,y+h	,z,1.0f,col,1.0f,1.0f);
}

/*!
	@breif	XgݒŒ_̋`ݒ肵܂B
	@note	_͂UKvłB
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@param[in]	VERTEX2D*		i[Qc_Xg̃|C^
	@param[in]	float			wʒu
	@param[in]	float			xʒu
	@param[in]	float			yʒu
	@param[in]	float			`̕
	@param[in]	float			`̍
	@param[in]	D3DCOLOR(DWORD)	F
*/
void	DrawParts::SetVertexSquareList(VERTEX2D* vl,float x,float y,float z,float w,float h,D3DCOLOR col)
{
	SetVertex2D( &vl[0], x		,y		,z,1.0f,col,0.0f,0.0f);
	SetVertex2D( &vl[1], x+w	,y		,z,1.0f,col,1.0f,0.0f);
	SetVertex2D( &vl[2], x+w	,y+h	,z,1.0f,col,1.0f,1.0f);
	SetVertex2D( &vl[3], x+w	,y+h	,z,1.0f,col,1.0f,1.0f);
	SetVertex2D( &vl[4], x		,y+h	,z,1.0f,col,0.0f,1.0f);
	SetVertex2D( &vl[5], x		,y		,z,1.0f,col,0.0f,0.0f);
}























////////////////////////////////////////////////////////////////////////////////////////////////////////////
// `ǗNX
////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*!
	@breif	
	@note	ɌĂ΂܂B
*/
void	RenderingManager::InitUtility()
{	
	//obNobt@̎擾
	MCR_DEVICE->GetBackBuffer(0, 0, D3DBACKBUFFER_TYPE_MONO, &m_pBackBuffer);
	AddDefaultLayer(0);

	DWORD width = INI("Width");
	DWORD height = INI("Height");
	//ŏI`p_[^[Qbg̐ݒ
	this->m_TextureID = MCR_CREATETEXTURE( width, height, 1, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT );
	D3DSURFACE_DESC desc;
	if( this->m_TextureID != -1 )
	{
		LPDIRECT3DTEXTURE9 lpTex = MCR_GETTEX( this->m_TextureID );
		lpTex->GetLevelDesc( 0, &desc );
	}
	HRESULT hr= MCR_DEVICE->CreateDepthStencilSurface( desc.Width, desc.Height, D3DFMT_D16 , D3DMULTISAMPLE_NONE, 0, TRUE, &m_depthStencilSurface, NULL);
	SetFVF(D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	SetPrimitiveStyle(TRIANGLESTRIP);
	SetScale(1.0f,1.0f,1.0f);							//gAkl
	SetRot(0.0f,0.0f,0.0f);		//XS]AYS],ZS]
	SetPos(0.0f,0.0f,0.0f);		//sړ
	DrawParts::SetVertexSquareSprit( &this->m_ScreenVex[0], 0, 0, 0.0f, (float)width, (float)height, 0xffffffff );
	SetVertexList( m_ScreenVex[0], 4 );
//	Refresh();

	this->m_stNowRenderStyle.bDrawRenderTarget = 0;
	this->m_stNowRenderStyle.iRenderTargetTexID = -1;
	this->m_stNowRenderStyle.bDrawRenderTargetClear = 1;
}

/*!
	@breif	`ǗNXJ
	@note	ɌĂ΂܂B
*/
void	RenderingManager::Release()
{
	for( LTL::LTLPriorityQueue<DrawFlags*>::iterator f = m_stFlagList.begin(); f < m_stFlagList.size(); f++ )
	{
		delete f.now->ptObj;
	}
	m_pBackBuffer->Release();
	m_depthStencilSurface->Release();
}

/*!
	@breif	o^
	@note	DrawPartsĂ΂܂B
	@param[in]		DrawParts*	o^`p[c
	@param[in]		int			DxC[
	@param[in/out]	BOOL*		gp
*/
void	RenderingManager::Addin(DrawParts* parts, int priorityLayer,BOOL* lbDataRet )
{  	
	BOOL ret=-1;
	//o^ɁAC[񂪂邩ȂmFBȂ΃ftHgōB
	if( priorityLayer != 0 ){
		if(ret = IsNewLayer(priorityLayer)){
			AddDefaultLayer(priorityLayer);
		}
	}
	m_stLayerList.push_back( parts, priorityLayer );
	if( lbDataRet!=NULL ) *lbDataRet = ret;	//Ԃ
}

/*!
	@breif	o^
	@note	DrawPartsĂ΂܂B
	@note	ɖ
	@param[in]		DrawParts*	폜`p[c
*/
void	RenderingManager::Delete(DrawParts* parts)
{  	
	BOOL ret=-1;
	//폜ɁAC[񂪂Pł͂ȂmFBPȂ폜B
	///
	m_stLayerList.erase( parts );
}

/*!
	@breif	C[ftHglō쐬
	@note	ɓo^ɃC[񂪖ꍇ܂B
	@param[in]	int		DxC[
*/
void	RenderingManager::AddDefaultLayer(int priorityLayer)
{
	DrawFlags* tmp = new DrawFlags;
	tmp->LayerID = priorityLayer;	//C[hc
	tmp->bDrawRenderTarget = 0;		//_[^[Qbg͎gȂ
	tmp->bDrawRenderTargetClear = 1;//gꍇNA

	m_stFlagList.push_back( tmp, priorityLayer );
}

/*!
	@breif	VKC[ǂ𔻒
	@param[in]	int		DxC[
	@return		BOOL	C[̗L(TRUEłȂAFALSEł)
*/
BOOL	RenderingManager::IsNewLayer(int priorityLayer)
{
	for( LTL::LTLPriorityQueue<DrawFlags*>::iterator f = m_stFlagList.begin(); f < m_stFlagList.size(); f++ )
	{
		if( f->LayerID == priorityLayer ) return FALSE;
	}
	return TRUE;
}

/*!
	@breif	C[ݒ
	@note	C[̃C[hcv\̂ύX܂B
	@param[in]	DrawFlags	C[\	
	@return		DWORD		sԂ(-1EsȃC[)
*/
DWORD	RenderingManager::SetLayerData(DrawFlags d)
{
	for( LTL::LTLPriorityQueue<DrawFlags*>::iterator f = m_stFlagList.begin(); f < m_stFlagList.size(); f++ )
	{
		if( f->LayerID == d.LayerID )
		{
			memcpy( (*f).ptObj, &d, sizeof(DrawFlags) );
			return 0;
		}
	}

	return -1;
}

/*!
	@breif	_[^[Qbg̎gpݒ
	@param[in]	int		DxC[
	@param[in]	BOOL	gp邩ۂ(TRUEŎgp)
	@return		DWORD	sԂ(-1EsȃC[)
*/
DWORD	RenderingManager::SetRenderTarget(int priorityLayer, BOOL use)
{
	for( LTL::LTLPriorityQueue<DrawFlags*>::iterator f = m_stFlagList.begin(); f < m_stFlagList.size(); f++ )
	{
		if( f->LayerID == priorityLayer )
		{
			f->bDrawRenderTarget = use;
			return 0;
		}
	}

	return -1;
}

/*!
	@breif	C[`ݒ
	@note	֐łB`֐Ă΂܂B
	@param[in]	DrawFlags*	`
*/
void	RenderingManager::_StsSetRenderStatus(DrawFlags* stFlag)
{
	HRESULT hr;
	//_[^[QbgXV
	if( this->m_stNowRenderStyle.bDrawRenderTarget != stFlag->bDrawRenderTarget )
	{
		if(stFlag->bDrawRenderTarget && stFlag->iRenderTargetTexID != -1)	//use
		{
            IDirect3DSurface9* surface = MCR_TEXMAN->GetTexSurface(stFlag->iRenderTargetTexID);
			hr = MCR_DEVICE->SetRenderTarget( 0, surface );
			this->m_stNowRenderStyle.bDrawRenderTarget = stFlag->bDrawRenderTarget;
			if( this->m_stNowRenderStyle.bDrawRenderTargetClear )
			{
				MCR_DEVICE->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_ARGB(0,255,255,255), 1.0f, 0 );
			}
		}else{
			//_OobNobt@ɖ߂
			MCR_DEVICE->SetRenderTarget(0, m_pBackBuffer);
			this->m_stNowRenderStyle.bDrawRenderTarget = stFlag->bDrawRenderTarget;
		}                
	}
}

/*!
	@breif	ꊇ`֐
	@note	
*/
void	RenderingManager::Draw()
{
	HRESULT hr;
	//fobOn̗pӂB@
	///@vCIeB̕\ƂB
	LTL::LTLPriorityQueue<DrawFlags*>::iterator f = m_stFlagList.begin();
	LTL::LTLPriorityQueue<DrawParts*>::iterator i = m_stLayerList.begin();

	double time;
	LARGE_INTEGER spd_before,spd_after,freq;
	memset(&spd_before, 0x00,sizeof spd_before);
	memset(&spd_after,  0x00,sizeof spd_after);
	memset(&freq,		0x00,sizeof freq);
	QueryPerformanceCounter(&spd_before);

	IDirect3DSurface9* surface = MCR_TEXMAN->GetTexSurface(this->m_TextureID);
	IDirect3DSurface9* depthStencilSurface;
	MCR_DEVICE->GetDepthStencilSurface( &depthStencilSurface );
	hr = MCR_DEVICE->SetRenderTarget( 0, surface );
	hr = MCR_DEVICE->SetDepthStencilSurface( m_depthStencilSurface );
	MCR_DEVICE->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_ARGB(0,255,255,255), 1.0f, 0 );

	g_dxCameraCtrl->RefreshNowCamera();
	g_dxCameraCtrl->RefreshProjection();

	for( ; f < m_stFlagList.size(); f++ )
	{
		if( !f->bVisivle )
		{
			f++;
			continue;
		}

		_StsSetRenderStatus((*f).ptObj);
		if( i.now )
		{
			while( i.now )
			{
				if( i.now->priority == f->LayerID )
				{
					i->PreRender();
					i->Rendering();
					i->AfterRender();
					i++;
				}else{
					break;
				}
			}
		}
	}

	//_OobNobt@ɖ߂
	MCR_DEVICE->SetRenderTarget(0, m_pBackBuffer);
	MCR_DEVICE->SetDepthStencilSurface( depthStencilSurface );

	PreRender();
	Rendering();
	AfterRender();

	QueryPerformanceFrequency( &freq );
	QueryPerformanceCounter(&spd_after);
	time = (double)(spd_after.QuadPart - spd_before.QuadPart) * 1000 / (double)freq.QuadPart;
	TCHAR tmp[1024];
	sprintf( tmp, "Render MIPS: %1.8f/ms : 60Frame Score: %1.8f ",time, time*60 );
	dbg.DebugLogPut( tmp );

	depthStencilSurface->Release();
//	backbuffer->Release();
}

/*!
	@breif	XN[F̏ݒ
	@note	ŌɃXN[_[^[QbgƂĕ`悷ۂ̐ݒłB
	@param[in]	DWORD	XN[F
*/
void	RenderingManager::SetScreenColor(DWORD col)
{
	for(int i=0;i<6;i++) this->m_ScreenVex[i].c = col;
}

/*!
	@breif	XN[Ŝ̂tuݒ
	@note	ŌɃXN[_[^[QbgƂĕ`悷ۂ̐ݒłB
	@param[in]	tW
	@param[in]	uW
	@param[in]	EtW
	@param[in]	EuW
*/
void	RenderingManager::SetScreenUV(float u0,float v0,float u1,float v1)
{
	this->m_ScreenVex[0].u = u0; this->m_ScreenVex[0].v = v0;
	this->m_ScreenVex[1].u = u1; this->m_ScreenVex[1].v = v0;
	this->m_ScreenVex[2].u = u0; this->m_ScreenVex[2].v = v1;
	this->m_ScreenVex[3].u = u1; this->m_ScreenVex[3].v = v1;
}




/*!
	@breif	vZbg
	@note	X^eBbN֐łB@DrawPartsgpĂȂĂXR[vgpł܂B
	@note	vZbgݒgpāA`p[c𐶐܂B
	@param[in]	DrawParts*	`p[c̃|C^
	@param[in]	DWORD		p[chc	
*/
void	RenderingManager::ImplementalSet( DrawParts* p, DWORD parts )
{
	VERTEX* vex;
	VERTEX2D* vex2;
	int vexnums;
	DWORD my_fvf;
if(parts==DICE)
{
	vex = new VERTEX[36];
	vexnums = 36;
	my_fvf = (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	p->SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	p->SetTexture( 0 );
	MCR_DEVICE->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
}
if(parts==TEXTURE){
	vex2 = new VERTEX2D[6];
	vexnums = 6;
	my_fvf = (D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	p->SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	p->SetTexture(2);
}
if(parts==FIELD){
	vex = new VERTEX[6];
	vexnums = 6;
	my_fvf = (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	p->SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	p->SetTexture(-1);
	MCR_DEVICE->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);
}
if(parts==CHARA){
	vex = new VERTEX[6];
	vexnums = 6;
	my_fvf = (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	p->SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	p->SetTexture(1);
}

	//=====================================================
	//foCX̐ݒ
	//=====================================================
	MCR_DEVICE->SetRenderState(D3DRS_LIGHTING,FALSE);

	//=====================================================
	//`悷IuWFNg̐ݒ
	//=====================================================
	float fPosx = 0.117f / 2.0f;
	float fPosy = 0.117f / 2.0f;
	float fPosz = 0.117f / 2.0f;

if(parts==DICE){
	//O
	DrawParts::SetVertex( &vex[0], fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.25f);
	DrawParts::SetVertex( &vex[1], -fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.0f);
	DrawParts::SetVertex( &vex[2], fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	DrawParts::SetVertex( &vex[3], fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.25f);
	DrawParts::SetVertex( &vex[4], -fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.0f);
	DrawParts::SetVertex( &vex[5], -fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.0f);
	//
	DrawParts::SetVertex( &vex[6], -fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	DrawParts::SetVertex( &vex[7], fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.0f);
	DrawParts::SetVertex( &vex[8], -fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);	
	DrawParts::SetVertex( &vex[9], -fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	DrawParts::SetVertex( &vex[10], fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.0f);
	DrawParts::SetVertex( &vex[11], fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.0f);
	//E
	DrawParts::SetVertex( &vex[12], fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);
	DrawParts::SetVertex( &vex[13], fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.75f,0.0f);
	DrawParts::SetVertex( &vex[14], fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.75f,0.25f);
	DrawParts::SetVertex( &vex[15], fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);
	DrawParts::SetVertex( &vex[16], fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.0f);
	DrawParts::SetVertex( &vex[17], fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.75f,0.0f);
	//
	DrawParts::SetVertex( &vex[18], -fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.75f,0.25f);
	DrawParts::SetVertex( &vex[19], -fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),1.0f,0.0f);
	DrawParts::SetVertex( &vex[20], -fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),1.0f,0.25f);
	DrawParts::SetVertex( &vex[21], -fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.75f,0.25f);
	DrawParts::SetVertex( &vex[22], -fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.75f,0.0f);
	DrawParts::SetVertex( &vex[23], -fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),1.0f,0.0f);
	//
	DrawParts::SetVertex( &vex[24], fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.5f);
	DrawParts::SetVertex( &vex[25], -fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	DrawParts::SetVertex( &vex[26], fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.5f);
	DrawParts::SetVertex( &vex[27], fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.5f);
	DrawParts::SetVertex( &vex[28], -fPosx,fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.25f);
	DrawParts::SetVertex( &vex[29], -fPosx,fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	//
	DrawParts::SetVertex( &vex[30], fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.5f);
	DrawParts::SetVertex( &vex[31], -fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);
	DrawParts::SetVertex( &vex[32], fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.5f);
	DrawParts::SetVertex( &vex[33], fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.5f);
	DrawParts::SetVertex( &vex[34], -fPosx,-fPosy,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	DrawParts::SetVertex( &vex[35], -fPosx,-fPosy,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);
	p->SetVertexList( vex[0], vexnums );
}

if(parts==TEXTURE){
	DrawParts::SetVertexSquareList( &vex2[0], 0,0,0,480,480,D3DCOLOR_RGBA(255,255,255,255));
	p->SetVertexList( vex2[0], vexnums );
}

if(parts==FIELD){
	fPosx = 1000.17f / 4.0f;
	fPosy = 1.17f / 4.0f;
	fPosz = 1.17f / 4.0f;
	DrawParts::SetVertex( &vex[0], fPosx,-0.0f,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.5f);
	DrawParts::SetVertex( &vex[1], -fPosx,-0.0f,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);
	DrawParts::SetVertex( &vex[2], fPosx,-0.0f,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.5f);
	DrawParts::SetVertex( &vex[3], fPosx,-0.0f,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.5f);
	DrawParts::SetVertex( &vex[4], -fPosx,-0.0f,-fPosz,D3DCOLOR_RGBA(255,255,255,255),0.25f,0.25f);
	DrawParts::SetVertex( &vex[5], -fPosx,-0.0f,fPosz,D3DCOLOR_RGBA(255,255,255,255),0.5f,0.25f);
	p->SetVertexList( vex[0], vexnums );
}
if(parts==CHARA){
	fPosx = 0.0217f / 2.0f;
	fPosy = 0.0417f / 2.0f;
	fPosz = 0.0117f / 2.0f;
	DrawParts::SetVertex( &vex[0], fPosx,-fPosy,0.0f,D3DCOLOR_RGBA(255,255,255,255),0.0f,1.0f);
	DrawParts::SetVertex( &vex[1], -fPosx,fPosy,0.0f,D3DCOLOR_RGBA(255,255,255,255),1.0f,0.0f);
	DrawParts::SetVertex( &vex[2], fPosx,fPosy,0.0f,D3DCOLOR_RGBA(255,255,255,255),1.0f,1.0f);
	DrawParts::SetVertex( &vex[3], fPosx,-fPosy,0.0f,D3DCOLOR_RGBA(255,255,255,255),0.0f,1.0f);
	DrawParts::SetVertex( &vex[4], -fPosx,-fPosy,0.0f,D3DCOLOR_RGBA(255,255,255,255),0.0f,0.0f);
	DrawParts::SetVertex( &vex[5], -fPosx,fPosy,0.0f,D3DCOLOR_RGBA(255,255,255,255),1.0f,0.0f);
	p->SetVertexList( vex[0], vexnums );
}

	p->SetFVF( my_fvf );//̒_tH[}bg


if(parts==DICE){
	//=============================================================
	//_obt@쐬
	//=============================================================
	VERTEX *v;
	LPDIRECT3DVERTEXBUFFER9* lpBuff = p->GetVertexBuffer();
	MCR_DEVICE->CreateVertexBuffer(sizeof(VERTEX) * 36,0,my_fvf,D3DPOOL_MANAGED,lpBuff,NULL);
	(*lpBuff)->Lock(0,0,(void **)&v,0);
	memcpy(v,vex,sizeof(VERTEX)*36);
	(*lpBuff)->Unlock();
}

	//=============================================================
	//ϊs̐ݒ
	//=============================================================

	//=================================================================
	//[hϊs̍쐬
	//==================================================================
	p->SetScale(1.0f,1.0f,1.0f);							//gAkl
	p->SetRot(0.0f,0.0f,0.0f * 3.141592f  / 180.0f);		//XS]AYS],ZS]
	p->SetPos(0.0f,0.0f,1.0f);								//sړ
	p->Refresh();
/*
	//=================================================================
	//	r[s̍쐬
	//=================================================================
	D3DXMATRIX matView;
	D3DXVECTOR3 vec3From(0.0f,0.0f,2.0f);					//J̈ʒuSet
	D3DXVECTOR3 vec3At(0.0f,0.0f,1.0f);						//J̑ΏۂSet
	D3DXVECTOR3 vec3Up(0.0f,1.0f,0.0f);						//J̏Set	ʂD3DXVECTOR3(0.0f,1.0f,0.0f)ƂȂ܂B
	D3DXMatrixLookAtLH(&matView,&vec3From,&vec3At,&vec3Up);	//r[s쐬
	MCR_DEVICE->SetTransform(D3DTS_VIEW,&matView);			//r[sSet
	

	//=================================================================
	//vWFNVs̍쐬
	//=================================================================
	D3DXMATRIX matProj;	
	float fAngle = 30 * 3.141592f  / 180.0f;						//p
	float fAspect = 1.0f;											//AXyNg	ʂ1.0f
	float fNear = 0.01f;												//ŋߓ_
	float fFar = 250.0f;											//ŉ_
	D3DXMatrixPerspectiveFovLH(&matProj,fAngle,fAspect,fNear,fFar);	//vWFNVs̍쐬
	MCR_DEVICE->SetTransform(D3DTS_PROJECTION,&matProj);			//vWFNVsSet
	*/
}