
#include "dxEftGlassScr.h"
#include "dxSysAfx.h"
#include <set>
#include <stack>
using namespace std;

struct MESHVERTEX {
	float x,y,z;
	float u,v;
};




void	_LBLGlassPoint::MakeVertex(float x, float y,float u, float v)
{
	m_vexChain = 0;
	m_vexPos.x = x; m_vexPos.y = y; m_vexPos.z = 0.0f;
	m_vexUV.x = u; m_vexUV.y = v;
	SetVertexList( m_stVexdbg[0], 4 );
	SetFVF(D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	SetPrimitiveStyle(TRIANGLESTRIP);
	SetScale(1.0f,1.0f,1.0f);							//gAkl
	SetRot(0.0f,0.0f,0.0f);		//XS]AYS],ZS]
	SetPos(0.0f,0.0f,0.0f);								//sړ
	Refresh();
	DrawParts::SetVertexSquareSprit( &this->m_stVexdbg[0], (float)x-1.0f, (float)y-1.0f, 1.0f, 3.0f, 3.0f, 0xffffffff );
//	AddRender(0);
}

void	_LBLGlassPoly::MakeTriangle(LBLGlassPoint* p1, LBLGlassPoint* p2, LBLGlassPoint* p3)
{
	m_RotPow.y = -0.003f;
	SetVertexList( m_stVex[0], 3 );
	SetFVF(D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);
	SetRenderStyle(DRAWPRIMITIVEUP_NOINDEX);
	SetPrimitiveStyle(TRIANGLELIST);
	SetScale(1.0f,1.0f,1.0f);							//gAkl
	SetRot(0.0f,0.0f,0.0f);		//XS]AYS],ZS]
	SetPos(0.0f,0.0f,0.0f);								//sړ
	SetTexture(1);
	Refresh();

	DrawParts::SetVertex( &this->m_stVex[0], p1->m_vexPos.x, p1->m_vexPos.y, 0.0f,  0xffffffff, p1->m_vexUV.x, p1->m_vexUV.y );
	DrawParts::SetVertex( &this->m_stVex[1], p2->m_vexPos.x, p2->m_vexPos.y, 0.0f,  0xffffffff, p2->m_vexUV.x, p2->m_vexUV.y );
	DrawParts::SetVertex( &this->m_stVex[2], p3->m_vexPos.x, p3->m_vexPos.y, 0.0f,  0xffffffff, p3->m_vexUV.x, p3->m_vexUV.y );
	
	Send(m_stVex[0]);
	//dS߁AɔюU߂
    
	AddRender(0);
}


#define DIV_MAX		50
#define DIV_WIDTH	8
#define DIV_HEIGHT	6

LBLGlass::~LBLGlass()
{
	m_pMesh->Release();
	for( std::vector<LBLGlassPoint*>::iterator i = m_stPoint.begin(); i < m_stPoint.end(); i++ )
	{
		delete (*i);
	}
	for( std::vector<LBLGlassPoly*>::iterator i = m_stPolys.begin(); i < m_stPolys.end(); i++ )
	{
		delete (*i);
	}
}

int	LBLGlass::MakeVertex(float x, float y,float u,float v)
{
	LBLGlassPoint* p = new LBLGlassPoint;
	p->MakeVertex(x,y,u,v);
	p->m_id = m_maxVex++;
	this->m_stPoint.push_back(p);
	return (int)(this->m_stPoint.size()-1);
}

//`FCȉłԋ߂KX̓_T
int	LBLGlass::Search(LBLGlassPoint* p)
{
	float dist=99999.0f;
	int cnt=0;
	int nr=-1;

	for( std::vector<LBLGlassPoint*>::iterator i = m_stPoint.begin(); i < m_stPoint.end(); i++ )
	{
		if( p != (*i) )
		{
			D3DXVECTOR3 d = ((*i)->m_vexPos-p->m_vexPos);
			if( d.x*d.x+d.y*d.y < dist && (*i)->m_vexChain < p->m_vexChain )
			{
				dist = d.x*d.x+d.y*d.y;
				nr = cnt;
			}
		}
		cnt++;
	}

	if( nr > 0 ){
		m_stPoint[nr]->m_vexChain++;
		p->m_vexChain++;
	}
	return nr;
}

//
void	LBLGlass::MakeTriangle(int rp1, int rp2, int rp3)
{
	LBLGlassPoly* v = new LBLGlassPoly;
	LBLGlassPoint* p1 = this->m_stPoint[rp1];
	LBLGlassPoint* p2 = this->m_stPoint[rp2];
	LBLGlassPoint* p3 = this->m_stPoint[rp3];
	v->MakeTriangle(p1,p2,p3);
	this->m_stPolys.push_back(v);
}

void	LBLGlass::Make()
{/*
	//܂ŃKX̕_쐬
	for( int y=0; y<=DIV_HEIGHT; y++)
	{
		//if(y==0||y==DIV_HEIGHT)
		{
			for( int x=0; x<=DIV_WIDTH; x++)
			{
				MakeVertex((float)(600*x/DIV_WIDTH+20),(float)(440*y/DIV_HEIGHT+20));
			}
		}else{
			MakeVertex(20.0f,(float)(440*y/DIV_HEIGHT+20));
			MakeVertex(620.0f,(float)(440*y/DIV_HEIGHT+20));			
		}
	}
	
//	for( int i=0; i<DIV_MAX; i++)
//	{
//		MakeVertex((float)(rand()%600+20),(float)(rand()%440+20));
//	}

	int max_nums = this->m_stPoint.size();	// _

	int p = 0;//rand()%max_nums;
	int rp1=0,rp2=0,rp3=0;

	this->m_stPoint[p]->AddPoint(); rp1=p;
	p = Search(this->m_stPoint[p]); rp2=p;
	p = Search(this->m_stPoint[p]); rp3=p;
	MakeTriangle(rp1,rp2,rp3);
	int tmp = rp3;

	while( 1 )
	{
		rp1 = rp2;
		p = rp2;
		p = Search(this->m_stPoint[p]); rp2=p;
		if( rp1 == -1 || rp2 == -1 || rp3 == -1 ) break;
		p = Search(this->m_stPoint[p]); rp3=p;
		if( rp1 == -1 || rp2 == -1 || rp3 == -1 ) break;
		MakeTriangle(rp1,rp2,rp3);
	}

	rp1 = tmp;
	p = tmp;
	while( 1 )
	{
		rp1 = rp2;
		p = rp2;
		p = Search(this->m_stPoint[p]); rp2=p;
		if( rp1 == -1 || rp2 == -1 || rp3 == -1 ) break;
		p = Search(this->m_stPoint[p]); rp3=p;
		if( rp1 == -1 || rp2 == -1 || rp3 == -1 ) break;
		MakeTriangle(rp1,rp2,rp3);
	}*/
/*
	//ċAIɃKX̖ʂ
	for( int i=0; i<1; i++ )
	{
		rp1 = 0;
		p = Search(this->m_stPoint[p]); rp2=p;
		p = Search(this->m_stPoint[p]); rp3=p;
		if( p > 0 ){
			MakeTriangle(rp1,rp2,rp3);
		}
	}*/
	DWORD			dwNumMaterials;
	HRESULT hr = D3DXLoadMeshFromX( "glass.x", D3DXMESH_SYSTEMMEM, MCR_DEVICE, NULL, NULL, NULL, &dwNumMaterials, &m_pMesh );


	DWORD maxPolys = m_pMesh->GetNumFaces();
	DWORD maxVexs = m_pMesh->GetNumVertices();
	D3DVERTEXELEMENT9 desc[10];
	m_pMesh->GetDeclaration(desc);
	DWORD fvf = m_pMesh->GetFVF();

	MESHVERTEX* v;
	WORD* idx;
	m_pMesh->LockVertexBuffer(D3DLOCK_DISCARD, (void **)&v);
	m_pMesh->LockIndexBuffer(D3DLOCK_DISCARD, (void **)&idx);
	DWORD rp1=0,rp2=0,rp3=0;
	for( int i=0; i<(signed)maxPolys; i++ )
	{
		rp1 = idx[i*3];
		rp2 = idx[i*3+1];
		rp3 = idx[i*3+2];

		if( rp1 > maxVexs ) break;
		if( rp2 > maxVexs ) break;
		if( rp3 > maxVexs ) break;
		MakeVertex(v[rp1].x/2000.0f,-v[rp1].y/2000.0f,v[rp1].u,-v[rp1].v);
		MakeVertex(v[rp2].x/2000.0f,-v[rp2].y/2000.0f,v[rp2].u,-v[rp2].v);
		MakeVertex(v[rp3].x/2000.0f,-v[rp3].y/2000.0f,v[rp3].u,-v[rp3].v);

		MakeTriangle( i*3, i*3+1, i*3+2 );
	}
	m_pMesh->UnlockIndexBuffer();
	m_pMesh->UnlockVertexBuffer();
}

void	LBLGlass::idol()
{
	D3DXMATRIX matWorld,matMove;
	D3DXMatrixScaling(&matWorld,0.001f,0.001f,0.001f);
	D3DXMatrixTranslation(&matMove,-0.5f,0.5f,0.0f);
	matWorld *= matMove;
	MCR_DEVICE->SetTransform(D3DTS_WORLD,&matWorld);		//[hsSet

	if(GetAsyncKeyState(VK_DOWN))
	{
		for( std::vector<LBLGlassPoly*>::iterator i = m_stPolys.begin(); i < m_stPolys.end(); i++ )
		{
			VERTEX* vl = (VERTEX*)(*i)->GetVertexList();
			float yd=(float)(rand()%10)/10000+0.0001f;
			vl[0].x-=0.001f; vl[0].y-=(*i)->m_RotPow.y+yd;
			vl[1].x-=0.0012f; vl[1].y-=(*i)->m_RotPow.y+yd;
			vl[2].x-=0.0012f; vl[2].y-=(*i)->m_RotPow.y+yd;
//			(*i)->AddRot( 0.05f, 0.02f, -0.15f );
			(*i)->Refresh();
			(*i)->m_RotPow.y+=yd;
			(*i)->Send(*vl);
		}
	}

//	MCR_DEVICE->SetMaterial( NULL );
//	MCR_DEVICE->SetTexture( 0, NULL );

	//m_pMesh->DrawSubset(0);
}
