
#include "dxSysAfx.h"
#include "Shader.h"


CShader::CShader()
{
	m_pEffect = NULL;
}

CShader::~CShader()
{
	Init();
}

BOOL CShader::Init()
{
	m_Pass=0;

	return TRUE;
}

BOOL	CShader::LoadEffect(TCHAR* file)
{
    DWORD dwShaderFlags = 0;
    #ifdef DEBUG_VS
        dwShaderFlags |= D3DXSHADER_FORCE_VS_SOFTWARE_NOOPT;
    #endif
    #ifdef DEBUG_PS
        dwShaderFlags |= D3DXSHADER_FORCE_PS_SOFTWARE_NOOPT;
    #endif

	HRESULT hr;
    LPD3DXBUFFER pErr;
	// VF[_̓ǂݍ
    // If this fails, there should be debug output as to 
    // they the .fx file failed to compile
    if( FAILED( hr = D3DXCreateEffectFromFile( MCR_DEVICE, file, NULL, NULL, dwShaderFlags, NULL, &m_pEffect,&pErr )))
	{
        MessageBox( NULL, (LPCTSTR)pErr->GetBufferPointer(), "ERROR", MB_OK);
        DXTRACE_ERR( "CreateEffectFromFile", hr );
		return FALSE;
	}

	return TRUE;
}

int		CShader::Exec()
{
	return -1;
}

// eNjbNݒ
void	CShader::SetTech(TCHAR* techname)
{
	if(m_pEffect) m_pEffect->SetTechnique(techname);
}
/*
// eNjbNݒ
template<typename T>
void	CShader::SetValue(TCHAR* ValueName, T& data )
{
	if(m_pEffect) m_pEffect->SetValue( ValueName, &data, sizeof(T) );
//	m_pEffect->SetValue( ValueName, data, sizeof(T) );
}
*/
// eNX`ݒ
void	CShader::SetTexture(TCHAR* texfile, LPDIRECT3DTEXTURE9 tex )
{
	if(!m_pEffect) return;
	m_pEffect->SetTexture( texfile, tex );
}

// GtFNgɂ`Jn
int		CShader::Begin()
{
	if(!m_pEffect) return-1;
	UINT cPasses=0;
	HRESULT hr;
	m_Pass = -1;
	// KvȃpX擾
	hr = m_pEffect->Begin(&cPasses, 0);

	return cPasses;
}

//`Jn
void	CShader::BeginPass(int Pass)
{
	if(!m_pEffect) return;
	// pX̊Jn
	if(Pass==-1) m_Pass++;
	else m_Pass=Pass;
	m_pEffect->BeginPass(m_Pass);
}

// pX̏I
void	CShader::EndPass()
{
	if(!m_pEffect) return;
	m_pEffect->EndPass();
}

// GtFNgɂ`I
void	CShader::End()
{
	if(!m_pEffect) return;
	m_pEffect->End();
}