package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.EventManager;
import jp.kirikiri.tvp2.env.TimerThread;


public class TimerNI extends NativeInstanceObject {
	private static final int DEFAULT_TIMER_CAPACITY = 6;
	private static final int
		atmNormal = 0,
		atmExclusive = 1,
		atmAtIdle = 2;
	public static boolean LimitTimerCapacity = false;
	private static final String ON_TIMER = "onTimer";
	static private final int
		E_BADPARAMCOUNT	= -1004,
		S_OK			= 0;

	private static Variant[] NULL_ARG;

	/** */
	private Dispatch2 mOwner;
	/** object to send action */
	private VariantClosure mActionOwner;
	/** serial number for event tag */
	private int mCounter;
	/** max queue size for this timer object */
	private int mCapacity;
	private String mActionName;
	/** trigger mode */
	private int mMode;

	private long mInterval;
	private long mNextTick;
	private int mPendingCount;
	private boolean mEnabled;

	public TimerNI() {
		if( NULL_ARG == null ) NULL_ARG = new Variant[0];
		//mOwner = null;
		//mCounter = 0;
		mCapacity = DEFAULT_TIMER_CAPACITY;
		mActionOwner = new VariantClosure(null);
		//mActionOwner.mObject = mActionOwner.mObjThis = null;
		mActionName = EventManager.ActionName;
		mMode = atmNormal;


		//mNextTick = 0;
		mInterval = 1000;
		//mPendingCount = 0;
		//mEnabled = false;
	}
	public int construct( Variant[] param, Dispatch2 tjs_obj ) throws VariantException, TJSException {
		if( param.length < 1 ) return E_BADPARAMCOUNT;

		int hr = super.construct( param, tjs_obj);
		if( hr < 0 ) return hr;
		if( param.length >= 2 && param[1].isVoid() != true )
			mActionName = param[1].asString(); // action function to be called

		mActionOwner = param[0].asObjectClosure();
		mOwner = tjs_obj;

		TimerThread.add(this);
		return S_OK;
	}
	public void invalidate() throws VariantException, TJSException {
		//TVP.TimerThreadr.remove(this);
		zeroPendingCount();
		cancelEvents();

		TVP.EventManager.cancelSourceEvents(mOwner);
		mOwner = null;
		mActionOwner.mObjThis = mActionOwner.mObject = null;
		super.invalidate();
	}

	private void fire( int n ) {
		if(mOwner == null) return;
		int count = TVP.EventManager.countEventsInQueue(mOwner, mOwner, ON_TIMER, 0);

		int cap = LimitTimerCapacity ? 1 : (mCapacity == 0 ? 65535 : mCapacity);
			// 65536 should be considered as to be no-limit.

		int more = cap - count;
		if( more > 0 ) {
			if(n > more) n = more;
			if(mOwner!=null)
			{
				int tag = 1 + (mCounter << 1);
				int flags = EventManager.EPT_POST|EventManager.EPT_DISCARDABLE;
				switch(mMode)
				{
				case atmNormal:			flags |= EventManager.EPT_NORMAL; break;
				case atmExclusive:		flags |= EventManager.EPT_EXCLUSIVE; break;
				case atmAtIdle:			flags |= EventManager.EPT_IDLE; break;
				}
				while( n-- > 0 ) {
					TVP.EventManager.postEvent(mOwner, mOwner, ON_TIMER, tag, flags, NULL_ARG );
				}
			}
			mCounter++;
		}
	}
	public void cancelEvents() {
		// cancel all events
		if( mOwner != null ) {
			TVP.EventManager.cancelEvents( mOwner, mOwner, ON_TIMER, 0 );
		}
	}
	private boolean areEventsInQueue() {
		// are events in event queue ?
		if( mOwner != null ) {
			return TVP.EventManager.areEventsInQueue( mOwner, mOwner, ON_TIMER, 0 );
		}
		return false;
	}

	public VariantClosure getActionOwner() { return mActionOwner; }
	public final String getActionName() { return mActionName; }

	public int getCapacity() { return mCapacity; }
	public void setCapacity( int c ) { mCapacity = c; }

	public int getMode() { return mMode; }
	public void setMode( int mode) { mMode = mode; }

	public void internalSetInterval(long n) { mInterval = n; }
	public void setInterval( long n ) {
		if( TVP.TimerThread != null ) TVP.TimerThread.setInterval(this, n);
	}
	public long getInterval() { return mInterval; }

	public void zeroPendingCount() { mPendingCount = 0; }

	public void setNextTick( long n ) { mNextTick = n; }
	public long getNextTick() { return mNextTick; }

	public void internalSetEnabled(boolean b) { mEnabled = b; }
	public void setEnabled(boolean b) {
		if( TVP.TimerThread != null ) TVP.TimerThread.setEnabled(this, b);
	}
	public boolean getEnabled() { return mEnabled; }

	public void trigger( int n ) {
		if(mPendingCount == 0) TimerThread.registerToPending(this);
		mPendingCount += n;
	}
	public void firePendingEventsAndClear() {
		// fire all pending events and clear the pending event count
		if( mPendingCount != 0) {
			fire(mPendingCount);
			zeroPendingCount();
		}
	}

	// private void cancelTrigger() {}
}
