//
package jp.kirikiri.tvp2.base;

import java.io.UnsupportedEncodingException;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.Error;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;

public class TextWriteStream implements TextWriteStreamInterface {

	private BinaryStream mStream;

	public TextWriteStream(String name, String mode) throws TJSException {
		mStream = Storage.createStream( name, BinaryStream.WRITE );
		if( mStream.getSize() == 0 ) {
			byte[] buf = {(byte) 0xff,(byte) 0xfe};
			mStream.write(buf);
		}
		// TODO 詳しく書く
	}
	public void write( final String val ) throws TJSException {
		if( mStream != null ) {
			try {
				mStream.write(val.getBytes("UTF-16LE"));
			} catch (UnsupportedEncodingException e) {
				throw new TJSException(Error.InternalError);
			}
		}
	}
	public void destruct() {
		mStream.close();
	}
}
