package jp.kirikiri.tvp2.utils;

import java.util.ArrayList;
import java.util.HashMap;

import jp.kirikiri.tjs2.StringStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;

/**
 *
 * KAG パーサー用
 *
 */
public class ScenarioCacheItem {

	private String[] mLines;

	static public class LabelCacheData {
		public int Line;
		public int Count;
		public LabelCacheData( int line, int count ) {
			Line = line;
			Count = count;
		}
	}

	/** Label cache  */
	private HashMap<String,LabelCacheData> mLabelCache;

	private ArrayList<String> mLabelAliases;

	/** whether the label is cached  */
	private boolean mLabelCached;


	public ScenarioCacheItem( final String name, boolean isstring) {
		//mLines = null;
		//mLineCount = 0;
		//mLabelCached = false;
		mLabelAliases = new ArrayList<String>();
		mLabelCache = new HashMap<String,LabelCacheData>();
		try {
			loadScenario(name, isstring);
		} catch( Exception e ) {
			mLines = null;
		}
	}

	/**
	 * load file or string to buffer
	 * @param name
	 * @param isstring
	 * @throws TJSException
	 */
	private final void loadScenario( final String name, boolean isstring ) throws TJSException {
		String buffer;
		if( isstring ) {
			// when onScenarioLoad returns string;
			// assumes the string is scenario
			buffer = name;
		} else {
			// else load from file
			buffer = Storage.readText(name, "");
		}

		StringStream stream = new StringStream( buffer );
		// pass1: count lines
		final int count = stream.getMaxLine();

		if(count == 0) Message.throwExceptionMessage(Message.KAGNoLine, name);
		mLines = new String[count];

		// pass2: split lines
		for( int i = 0; i < count; i++ ) {
			String line = stream.getLine(i);
			if( line.length() != 0 && line.charAt(0) == '\t' ) {
				int tab = 1;
				int length = line.length();
				for( ; tab < length; tab++ ) {
					if( line.charAt(tab) != '\t' ) break;
				}
				mLines[i] = line.substring(tab);
			} else {
				mLines[i] = line;
			}
		}
		stream = null;

		// オリジナルは次のようになっているけど、これはこうなってはいない
		// tab-only last line will not be counted in pass2, thus makes
		// pass2 counted lines are lesser than pass1 lines.
	}

	public final String getLabelAliasFromLine( int line ) {
		return mLabelAliases.get(line);
	}

	/**
	 * construct label cache
	 * @throws TJSException
	 */
	public final void ensureLabelCache() throws TJSException {
		if( !mLabelCached ) {
			// make label cache
			String prevlabel = null;
			final int count = mLines.length;
			mLabelAliases.ensureCapacity(count);
			for( int i = 0; i < count; i++ ) {
				mLabelAliases.add(null);
			}
			StringBuilder builder = new StringBuilder(256);
			for( int i = 0; i < count; i++  ) {
				if( mLines[i].length() >= 2 && mLines[i].charAt(0) == '*' ) {
					String p = mLines[i];
					int vl = p.indexOf('|');
					String label;
					if( vl != -1 ) {
						// page name found
						label = p.substring(0,vl);
					} else {
						label = p;
					}

					if( label.length() == 1) {
						if( prevlabel == null || prevlabel.length() == 0 )
							Message.throwExceptionMessage(Message.KAGCannotOmmitFirstLabelName);
						label = prevlabel;
					}

					prevlabel = label;

					LabelCacheData data = mLabelCache.get(label);
					if( data != null ) {
						// previous label name found (duplicated label)
						data.Count++;
						builder.append(label);
						builder.append(':');
						builder.append( data.Count );
						label = builder.toString();
						builder.delete(0, builder.length() );
					}
					mLabelCache.put(label, new LabelCacheData(i, 1) );
					mLabelAliases.add( i, label );
				}
			}
			mLabelCached = true;
		}
	}

	public final String[] getLines() { return mLines; }
	public final int getLineCount() { return mLines.length; }
	public final HashMap<String,LabelCacheData> getLabelCache() { return mLabelCache; }
}
