package jp.kirikiri.tjs2;

public abstract class NativeClassProperty extends Dispatch {

	static private final int
		E_NATIVECLASSCRASH	= -1008,
		S_TRUE			= 1,
		E_FAIL			= -1;

	public int isInstanceOf( int flag, final String membername, final String classname, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername == null ) {
			if( "Property".equals(classname) ) return S_TRUE;
		}
		return super.isInstanceOf(flag, membername, classname, objthis);
	}
	public int propGet( int flag, final String membername, Variant result, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.propGet( flag, membername, result, objthis );
		if( objthis == null ) return E_NATIVECLASSCRASH;
		if( result == null ) return E_FAIL;

		return get( result, objthis );
	}
	public int propSet( int flag, final String membername, final Variant param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.propSet(flag, membername, param, objthis);
		if( objthis == null ) return E_NATIVECLASSCRASH;
		if( param == null ) return E_FAIL;

		return set( param, objthis );
	}

	abstract public int get( Variant result, Dispatch2 objthis );
	abstract public int set( Variant param, Dispatch2 objthis ) throws VariantException;
}
