package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

public class Rect {
	/** Rect pool 不用意なnew を避け GCが動く回数を減らす */
	private static ArrayList<Rect> mRectPool = new ArrayList<Rect>(128);
	public static Rect allocate() {
		final int count = mRectPool.size();
		if( count > 0 ) {
			int i = count - 1;
			Rect ret = mRectPool.get(i);
			mRectPool.remove(i);
			return ret;
		} else {
			return new Rect();
		}
	}
	public static void release(Rect r) { mRectPool.add(r); }




	public int left;
	public int top;
	public int right;
	public int bottom;

	public Rect( int l, int t, int r, int b ) {
		left = l;
		top = t;
		right = r;
		bottom =b;
	}

	public Rect() {}

	public Rect(Rect rt ) {
		left = rt.left;
		top = rt.top;
		right = rt.right;
		bottom = rt.bottom;
	}

	public final int width() { return right - left; }
	public final int height() { return bottom - top; }

	public final void setWidth( int w) { right = left + w; }
	public final void setHeight( int h) { bottom = top + h; }

	public final void addOffsets( int x, int y) {
		left += x; right += x;
		top += y; bottom += y;
	}

	public final void setOffsets( int x, int y ) {
		int w = width();
		int h = height();
		left = x;
		top = y;
		right = x + w;
		bottom = y + h;
	}

	public final void setSize( int w, int h ) {
		right = left + w;
		bottom = top + h;
	}
	public final void set( Rect rt ) {
		left = rt.left;
		top = rt.top;
		right = rt.right;
		bottom = rt.bottom;
	}
	public void set(int l, int t, int r, int b ) {
		left = l;
		top = t;
		right = r;
		bottom = b;
	}

	public final void clear() {
		left = top = right = bottom = 0;
	}

	public final boolean isEmpty() {
		return left >= right || top >= bottom;
	}

	public final boolean doUnion( final Rect ref ) {
		if(ref.isEmpty()) return false;
		if(left > ref.left) left = ref.left;
		if(top > ref.top) top = ref.top;
		if(right < ref.right) right = ref.right;
		if(bottom < ref.bottom) bottom = ref.bottom;
		return true;
	}

	boolean clip( final Rect ref ) {
		// Clip (take the intersection of) the rectangle with rectangle.
		// returns whether the rectangle remains.
		return intersectRect(this, this, ref);
	}

	public final boolean intersectsWithNoEmptyCheck( final Rect ref ) {
		// returns wether this has intersection with "ref"
		return !(
			left >= ref.right ||
			top >= ref.bottom ||
			right <= ref.left ||
			bottom <= ref.top );
	}

	public final boolean intersectsWith( final Rect ref ) {
		// returns wether this has intersection with "ref"
		if(ref.isEmpty() || isEmpty()) return false;
		return intersectsWithNoEmptyCheck(ref);
	}

	public final boolean includedInNoEmptyCheck( final Rect ref ) {
		// returns wether this is included in "ref"
		return
			ref.left <= left &&
			ref.top <= top &&
			ref.right >= right &&
			ref.bottom >= bottom;
	}

	public final boolean includedIn( final Rect ref ) {
		// returns wether this is included in "ref"
		if(ref.isEmpty() || isEmpty()) return false;
		return includedInNoEmptyCheck(ref);
	}

// comparison operators for sorting
	// <
	public final boolean littlerThan( final Rect rhs ) {
		return top < rhs.top || (top == rhs.top && left < rhs.left);
	}

	// >
	public final boolean greaterThan( final Rect rhs ) {
		return top > rhs.top || (top == rhs.top && left > rhs.left);
	}

	// comparison methods
	// ==
	public final boolean equals( final Rect rhs ) {
		return top == rhs.top && left == rhs.left && right == rhs.right && bottom == rhs.bottom;
	}
	// !=
	public final boolean notEquals( final Rect rhs ) { return !equals(rhs); }

	static public final boolean intersectRect( Rect dest, final Rect src1, final Rect src2 ) {
		int left =		src1.left > src2.left ? src1.left : src2.left;
		int top =		src1.top > src2.top ? src1.top : src2.top;
		int right =		src1.right < src2.right ? src1.right : src2.right;
		int bottom =	src1.bottom < src2.bottom ? src1.bottom : src2.bottom;

		if( right > left && bottom > top ) {
			if( dest != null ){
				dest.left =		left;
				dest.top =		top;
				dest.right =	right;
				dest.bottom =	bottom;
			}
			return true;
		}
		return false;
	}
	static public final boolean unionRect( Rect dest, final Rect src1, final Rect src2 ) {
		int left =		src1.left < src2.left ? src1.left : src2.left;
		int top =		src1.top < src2.top ? src1.top : src2.top;
		int right =		src1.right > src2.right ? src1.right : src2.right;
		int bottom =	src1.bottom > src2.bottom ? src1.bottom : src2.bottom;

		if( right > left && bottom > top ) {

			if( dest != null ) {
				dest.left =	left;
				dest.top =		top;
				dest.right =	right;
				dest.bottom =	bottom;
			}
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder(64);
		builder.append("left:");
		builder.append(left);
		builder.append(", top:");
		builder.append(top);
		builder.append(", right:");
		builder.append(right);
		builder.append(", bottom:");
		builder.append(bottom);
		return builder.toString();
	}
}
