/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;


public interface StorageMedia {

	/**
	 * returns media name like "file", "http" etc.
	 */
	public String getName();

	/**
	 * normalize domain name according with the media's rule
	 */
	public String normalizeDomainName( final String name );

	/**
	 * normalize path name according with the media's rule
	 * "name" below is normalized but does not contain media, eg.
	 * not "media://domain/path" but "domain/path"
	 */
	public String normalizePathName( final String name );

	public String getDefaultDomain();

	/**
	 * check file existence
	 * @throws TJSException
	 */
	public boolean checkExistentStorage( final String name ) throws TJSException;

	/**
	 * open a storage and return a tTJSBinaryStream instance.
	 * name does not contain in-archive storage name but
	 * is normalized.
	 * @throws TJSException
	 */
	public BinaryStream open( final String name, int flags ) throws TJSException;

	/**
	 * list files at given place
	 * @throws TJSException
	 */
	public void getListAt( final String name, StorageLister lister ) throws TJSException;

	/**
	 * basically the same as above,
	 * check wether given name is easily accessible from local OS filesystem.
	 * if true, returns local OS native name. otherwise returns an empty string.
	 */
	public String getLocallyAccessibleName( String name );
}
