package jp.kirikiri.tvp2.visual;

/**
 * Structure for monitor screen mode
 */
public class ScreenMode {
	public int mWidth;	// width of screen in pixel
	public int mHeight;	// height of screen in pixel
	public int mBitsPerPixel;	// bits per pixel (0 = unspecified)

	public ScreenMode(){}
	public ScreenMode( int w, int h, int bpp) {
		mWidth = w;
		mHeight = h;
		mBitsPerPixel = bpp;
	}
	public String dump() {
		StringBuilder builder = new StringBuilder(64);
		builder.append( dumpHeightAndWidth() );
		builder.append("BitsPerPixel=");
		if( mBitsPerPixel != 0 ) {
			builder.append( mBitsPerPixel );
		} else {
			builder.append("unspecified");
		}
		return builder.toString();
	}

	public String dumpHeightAndWidth() {
		StringBuilder builder = new StringBuilder(64);
		builder.append("Width=");
		builder.append(mWidth);
		builder.append(", Height=");
		builder.append(mHeight);
		return builder.toString();
	}

	// operator <
	public boolean littlerThan( final ScreenMode rhs ) {
		int area_this = mWidth * mHeight;
		int area_rhs  = rhs.mWidth * rhs.mHeight;
		if(area_this < area_rhs) return true;
		if(area_this > area_rhs) return false;
		if(mBitsPerPixel < rhs.mBitsPerPixel) return true;
		if(mBitsPerPixel > rhs.mBitsPerPixel) return false;
		return false;
	}
}
