package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.VariantException;

public class StorageClass extends NativeClass {
	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	private static final int
		MEMBERENSURE		= 0x00000200, // create a member if not exists
		MEMBERMUSTEXIST     = 0x00000400, // member *must* exist ( for Dictionary/Array )
		IGNOREPROP			= 0x00000800, // ignore property invoking
		HIDDENMEMBER		= 0x00001000, // member is hidden
		STATICMEMBER		= 0x00010000, // member is not registered to the
										  // object (internal use)
		ENUM_NO_VALUE		= 0x00100000; // values are not retrieved
										  // (for EnumMembers)
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final String CLASS_NAME = "Storage";
	static private final int nitMethod	= 1;


	private static final char ArchiveDelimiter = '>';

	public static String extractStorageExt( final String name ) {
		// extract an extension from name.
		// returned string will contain extension delimiter ( '.' ), except for
		// missing extension of the input string.
		// ( returns null string when input string does not have an extension )

		final int slen = name.length();
		int p = slen - 1;
		while( p >= 0 ){
			char c = name.charAt(p);
			if(c == '\\') break;
			if(c == '/') break;
			if(c == ArchiveDelimiter) break;
			if(c == '.') {
				// found extension delimiter
				//int extlen = slen - p;
				return name.substring( p );
			}
			p--;
		}
		// not found
		return new String();
	}
	public static String extractStorageName( final String name ) {
		// extract "name"'s storage name ( excluding path ) and return it.
		final int slen = name.length();
		int p = slen - 1;
		while( p >= 0 ){
			char c = name.charAt(p);
			if(c == '\\') break;
			if(c == '/') break;
			if(c == ArchiveDelimiter) break;
			p--;
		}
		p++;
		if( p <= 0 ) {
			return name;
		} else {
			return name.substring(p);
		}
	}

	public StorageClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "addAutoPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "removeAutoPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getFullPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getPlacedPath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "isExistentStorage", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "extractStorageExt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "extractStorageName", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "extractStoragePath", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "chopStorageExt", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "clearArchiveCache", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "searchCD", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "getLocalName", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "selectFile", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return E_NOTIMPL;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );
	}
}
