package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;
import java.util.HashMap;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.env.NativeImageBuffer;
import jp.kirikiri.tvp2.env.NativeImageLoader;
import jp.kirikiri.tvp2.msg.Message;

public class GraphicsLoader {
	static final int MEMBERENSURE = 0x00000200; // create a member if not exists


	// enum tTVPGraphicLoadMode
	static public final int
		glmNormal = 0, // normal, ie. 32bit ARGB graphic
		glmPalettized = 1, // palettized 8bit mode
		glmGrayscale = 2; // grayscale 8bit mode

	static private boolean GraphicCacheEnabled = false;
	static class GraphicsSearchData {
		public String Name;
		public int KeyIdx; // color key index
		public int Mode; // image mode
		public int DesW; // desired width ( 0 for original size )
		public int DesH; // desired height ( 0 for original size )

		boolean equals( final GraphicsSearchData rhs ) {
			return KeyIdx == rhs.KeyIdx && Mode == rhs.Mode &&
				Name == rhs.Name && DesW == rhs.DesW && DesH == rhs.DesH;
		}
	}
	static class GraphicMetaInfoPair {
		public String Name;
		public String Value;
		public GraphicMetaInfoPair( final String name, final String value ) {
			Name = name;
			Value = value;
		}
	}
	static class GraphicImageData {
		private BaseBitmap mBitmap;
		private byte[] mRawData;
		private int mWidth;
		private int mHeight;
		private int mPixelSize;

		public String mProvinceName;
		public ArrayList<GraphicMetaInfoPair> mMetaInfo;

		//private int mRefCount;
		private int mSize;

		public GraphicImageData() {
			//mRefCount = 1;
			mSize = 0;
			mBitmap = null;
			mRawData = null;
			mMetaInfo = null;
		}

		/*
		public void assignBitmap( final BaseBitmap bmp ) {
			if(Bitmap) delete Bitmap, Bitmap = NULL;
			if(RawData) delete [] RawData, RawData = NULL;

			Width = bmp->GetWidth();
			Height = bmp->GetHeight();
			PixelSize = bmp->Is32BPP()?4:1;
			Size =  Width*Height*PixelSize;

			if(!TVPAllocGraphicCacheOnHeap)
			{
				// simply assin to Bitmap
				Bitmap = new tTVPBaseBitmap(*bmp);
			}
			else
			{
				// allocate heap and copy to it
				tjs_int h = Height;
				RawData = new tjs_uint8 [ Size ];
				tjs_uint8 *p = RawData;
				tjs_int rawpitch = Width * PixelSize;
				for(h--; h>=0; h--)
				{
					memcpy(p, bmp->GetScanLine(h), rawpitch);
					p += rawpitch;
				}
			}
		}

		public void assignToBitmap( BaseBitmap bmp ) {
			if( !TVPAllocGraphicCacheOnHeap ) {
				// simply assign to Bitmap
				if(Bitmap) bmp->AssignBitmap(*Bitmap);
			} else {
				// copy from the rawdata heap
				if(RawData) {
					bmp->Recreate(Width, Height, PixelSize==4?32:8);
					tjs_int h = Height;
					tjs_uint8 *p = RawData;
					tjs_int rawpitch = Width * PixelSize;
					for(h--; h>=0; h--)
					{
						memcpy(bmp->GetScanLineForWrite(h), p, rawpitch);
						p += rawpitch;
					}
				}
			}
		}
		*/

		int getSize() { return mSize; }
	}
	//
	/**
	 * @return provincename を返す
	 * @throws TJSException
	 */
	public static String loadGraphic( BaseBitmap dest, final String name, int keyidx, int desw, int desh,
			int mode, Holder<Dispatch2> metainfo, boolean src_is_addalpha ) throws TJSException {
		// loading with cache management
		String nname = TVP.StorageMediaManager.normalizeStorageName(name,null);
		String provincename = null;

		/*
		if( GraphicCacheEnabled ) {
			// int hash;
			// GraphicsSearchData searchdata = new GraphicsSearchData();
			searchdata.Name = nname;
			searchdata.KeyIdx = keyidx;
			searchdata.Mode = mode;
			searchdata.DesW = desw;
			searchdata.DesH = desh;

			hash = tTVPGraphicCache::MakeHash(searchdata);

			GraphicImageHolder ptr = TVPGraphicCache.FindAndTouchWithHash(searchdata, hash);
			if( ptr != null ) {
				// found in cache
				ptr.getObject().assignToBitmap(dest);
				if(provincename) provincename = ptr.getObject().mProvinceName;
				if( metainfo != null )
					metainfo.mHolder = TVPMetaInfoPairsToDictionary(ptr->GetObjectNoAddRef()->MetaInfo);
				return;
			}
		}
		// キャッシュには見付からない
		*/

		// load into dest
		// GraphicImageData data = null;

		String pn = null;
		ArrayList<GraphicMetaInfoPair> mi = new ArrayList<GraphicMetaInfoPair>();
		try {
			internalLoadGraphic( dest, nname, keyidx, desw, desh, mi, mode, pn );

			provincename = pn;
			if( metainfo != null )
				metainfo.mValue = metaInfoPairsToDictionary(mi);

			/*
				if( GraphicCacheEnabled ) {
					data = new GraphicImageData();
					data.assignBitmap(dest);
					data.mProvinceName = pn;
					data.mMetaInfo = mi; // now mi is managed under tTVPGraphicImageData
					mi = null;

					// check size limit
					TVPCheckGraphicCacheLimit();

					// push into hash table
					int datasize = data.getSize();
//					if(datasize < TVPGraphicCacheLimit)
//					{
						TVPGraphicCacheTotalBytes += datasize;
						tTVPGraphicImageHolder holder(data);
						TVPGraphicCache.AddWithHash(searchdata, hash, holder);
//					}
				}
				*/
		} finally {
			mi = null;
			// data = null;
		}
		return provincename;
	}
	static private final String GRAPHIC_TYPE[] = {
		".png",
		".jpg",
		".jpeg",
		".bmp",
	};
	static private boolean internalLoadGraphic( BaseBitmap dest, final String _name,
			int keyidx, int desw, int desh, ArrayList<GraphicMetaInfoPair> MetaInfo,
				int mode, String provincename) throws TJSException {

		String name = _name;
		String ext = Storage.extractStorageExt(name);
		if( ext == null || ext.length() == 0 ) {
			// 拡張子が見付からないので、登録されている拡張子で検索する
			final int count = GRAPHIC_TYPE.length;
			int i;
			for( i = 0; i < count; i++ ) {
				String newname = name + GRAPHIC_TYPE[i];
				if( Storage.isExistentStorage(newname) ) {
					name = newname;
					break;
				}
			}
			if( i == count ) {
				Message.throwExceptionMessage(Message.CannotSuggestGraphicExtension, name);
			}
		}

		// TODO 以下仮実装
		HashMap<String,String> metainfo = new HashMap<String,String>();
		BinaryStream stream = Storage.createStream(name,0);
		NativeImageBuffer img = NativeImageLoader.loadImage( stream, ext, metainfo, mode == GraphicsLoader.glmGrayscale );
		if( img == null ) return false;
		dest.setNativeBitmap( img );
		if( ( desw != 0 && desh != 0 ) && (dest.getWidth() != desw || dest.getHeight() != desh) ) {
			dest.setSize( desw, desh, true );
		}
		return true;
	}
	static private Dispatch2 metaInfoPairsToDictionary( ArrayList<GraphicMetaInfoPair> vec ) throws VariantException, TJSException {
		if( vec == null ) return null;
		Dispatch2 dic = TJS.createDictionaryObject();
		final int count = vec.size();
		for( int i = 0; i < count; i++ ) {
			GraphicMetaInfoPair g = vec.get(i);
			Variant val = new Variant(g.Value);
			dic.propSet( MEMBERENSURE, g.Name, val, dic);
		}
		return dic;
	}
	/*
	public static void loadGraphic(BaseBitmap mProvinceImage, String name,
			int i, int width, int height, int glmpalettized2, Object object,
			Object object2) {
		// TODO 自動生成されたメソッド・スタブ

	}
	*/
}
