package jp.kirikiri.tvp2.env;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

import javax.imageio.ImageIO;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.ComplexRect;
import jp.kirikiri.tvp2.visual.LayerNI;
import jp.kirikiri.tvp2.visual.Rect;


public class NativeImageBuffer {
	private static String[] WRITABLE_FORMANT_NAMES;
	private static AffineTransform mLRFilpMatrix;
	private static AffineTransform mUDFilpMatrix;

	public static void initialize() {
		CustomOperationComposite.initialize();
		mLRFilpMatrix = null;
		mUDFilpMatrix = null;
	}

	private BufferedImage mImage;
	private int mWidth;
	private int mHeight;
	private HashMap<Character,GlyphVector> mGlyphHash;
	private java.awt.Font mChecheFont;
	private int mRefCount;

	public NativeImageBuffer( int w, int h ) {
		mWidth = w;
		mHeight = h;
		//mImage = new BufferedImage( w, h, BufferedImage.TYPE_4BYTE_ABGR );
		mImage = new BufferedImage( w, h, BufferedImage.TYPE_INT_ARGB );
		mRefCount = 1;
	}
	public NativeImageBuffer(int w, int h, int bpp) {
		mWidth = w;
		mHeight = h;
		//int type = BufferedImage.TYPE_4BYTE_ABGR;
		int type = BufferedImage.TYPE_INT_ARGB;
		if( bpp == 8 ) {
			type = BufferedImage.TYPE_BYTE_GRAY;
		}
		mImage = new BufferedImage( w, h, type );
		mRefCount = 1;
	}
	public NativeImageBuffer(NativeImageBuffer src) {
		mWidth = src.mWidth;
		mHeight = src.mHeight;
		int type = src.mImage.getType();
		mImage = new BufferedImage( mWidth, mHeight, type );
		Graphics2D g = (Graphics2D)mImage.getGraphics();
		g.setComposite( AlphaComposite.Src );
		g.drawImage( src.mImage, 0, 0, null );
		g.dispose();
		mRefCount = 1;
	}
	public NativeImageBuffer( int w, int h, NativeImageBuffer src ) {
		mWidth = w;
		mHeight = h;
		int type = src.mImage.getType();
		mImage = new BufferedImage( mWidth, mHeight, type );
		Graphics2D g = (Graphics2D)mImage.getGraphics();
		g.setComposite( AlphaComposite.Src );
		g.drawImage( src.mImage, 0, 0, null );
		g.dispose();
		mRefCount = 1;
	}
	public NativeImageBuffer(BufferedImage img) {
		mWidth = img.getWidth();
		mHeight = img.getHeight();
		mImage = img;
		mRefCount = 1;
	}
	public final void addRef() { mRefCount++; }
	public final void release() { if( mRefCount != 1 ) mRefCount--; } // 解放までは行わない(行えない)
	public final boolean isIndependent() { return mRefCount == 1; }
	public final Image getImage() {
		/*
		if( mComponent != null ) {
			if( mImage == null ) {
				mImage = mComponent.createVolatileImage(mWidth, mHeight);
			} else {
				GraphicsConfiguration gc = mComponent.getGraphicsConfiguration();
				// VRAMバッファ用領域に変更があった場合は再度生成処理を実行する
				if( ((VolatileImage)mImage).validate(gc) == VolatileImage.IMAGE_INCOMPATIBLE ) {
					mImage = mComponent.createVolatileImage(mWidth, mHeight);
				}
			}
		}
		*/
		return mImage;
	}
	public final void setImage( BufferedImage img ) {
		mImage = img;
		mWidth = img.getWidth();
		mHeight = img.getHeight();
	}
	public final int getWidth() { return mImage.getWidth(); }
	public final int getHeight() { return mImage.getHeight(); }

	public final void recreate( int w, int h, boolean keepimage ) throws TJSException {
		//if( mComponent != null ) throw new TJSException("オフスクリーンバッファはリサイズできない");

		int imageType = mImage.getType();
		if( w != 0 && h != 0 ) {
			BufferedImage img = new BufferedImage( w, h, imageType );
			if( keepimage && mImage != null ) {
				Graphics dest = img.getGraphics();
				dest.drawImage(mImage , 0, 0, null );
			}
			mImage = null;
			mImage = img;
		} else {
			mImage = null;
		}
		mWidth = w;
		mHeight = h;
	}
	public final int getBPP() { return mImage.getColorModel().getPixelSize(); }
	public final void getScanLine( int l, int[] buff) {
		if( mImage instanceof BufferedImage ) {
			BufferedImage bi = (BufferedImage)mImage;
			final int w = bi.getWidth();
			bi.getRGB( 0, l, w, 1, buff, 0, w );
		}
		// 他の時は何も返さない
	}
	public final int[] getScanLine( int l ) {
		if( mImage instanceof BufferedImage ) {
			BufferedImage bi = (BufferedImage)mImage;
			final int w = bi.getWidth();
			return bi.getRGB( 0, l, w, 1, null, 0, w );
		}
		return null;
	}
	public final int[] getScanLineForWrite( int l ) {
		if( mImage instanceof BufferedImage ) {
			BufferedImage bi = (BufferedImage)mImage;
			WritableRaster wr = bi.getRaster();
			DataBufferInt bdi = (DataBufferInt) wr.getDataBuffer();
			return bdi.getData(); // TODO スキャンライン関係ない……
		}
		return null;
	}
	public final void fill(Rect rect, int value) {
		Graphics2D g = (Graphics2D)mImage.getGraphics();
		g.setComposite( AlphaComposite.Src );
		g.setColor( new Color( value, true) );
		g.fillRect( rect.left, rect.top, rect.width(), rect.height() );
		g.dispose();
	}
	public final void fillColor(Rect rect, int color, int opa ) {
		Graphics2D g = (Graphics2D)mImage.getGraphics();
		g.setComposite(createAlphaComposite( AlphaComposite.SRC, opa ));
		g.setColor( new Color( (color&0xFFFFFF)|(opa<<24), true) );
		g.fillRect( rect.left, rect.top, rect.width(), rect.height() );
		g.dispose();
	}

	public final boolean copyRect(int x, int y, NativeImageBuffer src, Rect refrect) {
		Graphics2D g = (Graphics2D)mImage.getGraphics();
		g.setComposite( AlphaComposite.Src );
		boolean ret = g.drawImage( src.mImage, x, y, x+refrect.width(), y+refrect.height(),
				refrect.left, refrect.top, refrect.right, refrect.bottom, null );
		g.dispose();
		return ret;
	}
	public final boolean copyRect(Rect dstrect, NativeImageBuffer src, Rect srcrect, int method, int opa, boolean hda ) {
		/*
		createAlphaComposite( AlphaComposite.CLEAR, opa );
		createAlphaComposite( AlphaComposite.DST, opa );
		createAlphaComposite( AlphaComposite.DST_ATOP, opa );
		createAlphaComposite( AlphaComposite.DST_IN, opa );
		createAlphaComposite( AlphaComposite.DST_OUT, opa );
		createAlphaComposite( AlphaComposite.DST_OVER, opa );
		createAlphaComposite( AlphaComposite.SRC_ATOP, opa );
		createAlphaComposite( AlphaComposite.SRC_IN, opa );
		createAlphaComposite( AlphaComposite.SRC_OUT, opa );
		createAlphaComposite( AlphaComposite.XOR, opa );
		*/

		Graphics2D g = (Graphics2D)mImage.getGraphics();
		if( method == LayerNI.bmCopy && !hda ) {
			if( opa == 255 ) {
				g.setComposite( AlphaComposite.Src );
			} else {
				g.setComposite(createAlphaComposite( AlphaComposite.SRC, opa ));
			}
		} else if( method == LayerNI.bmCopyOnAlpha ) {
			if( opa == 255 ) {
				g.setComposite( AlphaComposite.Src );
			} else {
				g.setComposite(createAlphaComposite( AlphaComposite.SRC, opa ));
			}
		} else if( method == LayerNI.bmAlpha || method == LayerNI.bmAlphaOnAlpha ) {
			if( opa == 255 ) {
				g.setComposite( AlphaComposite.SrcOver );
			} else {
				g.setComposite(createAlphaComposite( AlphaComposite.SRC_OVER, opa ));
			}
		} else {
			g.setComposite(createAlphaComposite( AlphaComposite.SRC_OVER, opa ));
			// g.setComposite(new CustomOperationComposite( method, opa, hda )); TODO
		}
		boolean ret = g.drawImage( src.mImage, dstrect.left, dstrect.top, dstrect.right, dstrect.bottom,
				srcrect.left, srcrect.top, srcrect.right, srcrect.bottom, null );
		g.dispose();
		return ret;
	}

	/**
	 * 影のぼけと透明度を取り除く処理は実装できていない。
	 * これを実装しようとしたら、ピクセル単位での処理が必要になる。
	 * TODO どうするべきか？
	 * @param font
	 * @param fontChange
	 * @param destrect
	 * @param x
	 * @param y
	 * @param text
	 * @param color
	 * @param bltmode
	 * @param opa
	 * @param holdalpha
	 * @param aa
	 * @param shlevel
	 * @param shadowcolor
	 * @param shwidth
	 * @param shofsx
	 * @param shofsy
	 * @param updaterects
	 */
	public final void drawText( Font fontV, final Rect destrect, int x, int y, final String text,
			int color, int bltmode, int opa, boolean holdalpha, boolean aa,
			int shlevel, int shadowcolor, int shwidth, int shofsx, int shofsy, ComplexRect updaterects ) {
		final int count = text.length();
		if( count == 0 ) return;

		java.awt.Font font = fontV.getFont();
		if( bltmode == LayerNI.bmAlphaOnAlpha ) {
			//if(opa < -255) opa = -255;
			if(opa < 0) opa = 0; // TODO 透明度を取り除く処理していない
			if(opa > 255) opa = 255;
		} else {
			if(opa < 0) opa = 0;
			if(opa > 255 ) opa = 255;
		}
		if(opa == 0) return; // nothing to do

		if( mGlyphHash == null ) {
			mGlyphHash = new HashMap<Character,GlyphVector>();
		}
		boolean fontChange = mChecheFont != font;
		if( fontChange ) {
			mGlyphHash.clear();
			mChecheFont = font;
		}

		Image img = getImage();
		if( img == null ) return;
		Graphics2D g = (Graphics2D)img.getGraphics();
		FontMetrics metrics = g.getFontMetrics(font);
		Composite composite;
		Composite shadowcomposite = null;
		if( bltmode == LayerNI.bmCopy || bltmode == LayerNI.bmCopyOnAlpha ) {
			composite = createAlphaComposite( AlphaComposite.SRC, opa );
			if( shlevel != 0 )
				composite = createAlphaComposite( AlphaComposite.SRC, shlevel );
		} else if( bltmode == LayerNI.bmAlpha || bltmode == LayerNI.bmAlphaOnAlpha ) {
			composite = createAlphaComposite( AlphaComposite.SRC_OVER, opa );
			if( shlevel != 0 )
				shadowcomposite = createAlphaComposite( AlphaComposite.SRC_OVER, shlevel );
		} else {
			composite = createAlphaComposite( AlphaComposite.SRC_OVER, opa );
			if( shlevel != 0 )
				shadowcomposite = createAlphaComposite( AlphaComposite.SRC_OVER, shlevel );
			// g.setComposite(new CustomOperationComposite( method, opa, hda )); TODO
		}
		if( shlevel == 0 ) {
			g.setComposite(composite);
		}
		if( aa ) {
			g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON );
		} else {
			g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF );
		}
		Color fontColor = new Color(color);
		Color shadowColor = new Color(shadowcolor);
		char[] c = text.toCharArray();
		FontRenderContext frc = g.getFontRenderContext();
	    float ox = x;
	    float oy = y + metrics.getMaxAscent();
	    Rect shbound = new Rect();
		Rect srect = new Rect();
		Rect union = new Rect();
		for( int i = 0; i < count; i++ ) {
			boolean shadowdraw = false;
			boolean glyphdraw = false;
			GlyphVector glyph = mGlyphHash.get(c[i]);
			if( glyph == null ) {
				glyph = font.layoutGlyphVector(frc, c, i, i+1, 0 );
				mGlyphHash.put(c[i], glyph );
			}
			if( shlevel != 0 ) { // 影を書く
				g.setStroke(new BasicStroke(shwidth)); // TODO これだとぼやけない、ちまちまピクセルコピーするものを作るべきか？
				Shape shape = glyph.getOutline(ox+shofsx, oy+shofsy);
				Rectangle r = shape.getBounds();
			    if( checkBounds(destrect, r ) ) {
					if( shlevel != 0 ) {
						g.setComposite(shadowcomposite);
					}
			    	g.setPaint( shadowColor );
			    	g.draw(shape);
			    	g.fill(shape);
			    	shbound.set( r.x, r.y, r.x+r.width, r.y+r.height );
			    	shadowdraw = true;
			    	updaterects.or(shbound);
			    }
			}
		    Rectangle r = glyph.getPixelBounds(frc,ox,oy);
		    if( checkBounds(destrect, r ) ) {
				if( shlevel != 0 ) {
					g.setComposite(composite);
				}
				g.setPaint( fontColor );
			    g.drawGlyphVector(glyph,ox,oy);
			    if( updaterects != null ) {
			    	srect.set( r.x, r.y, r.x+r.width, r.y+r.height );
			    	glyphdraw = true;
			    }
		    }
		    if( shadowdraw || glyphdraw ) {
		    	if( shadowdraw && glyphdraw ) {
		    		Rect.unionRect(union, srect, shbound);
			    	updaterects.or(union);
		    	} else if( shadowdraw ) {
			    	updaterects.or(shbound);
		    	} else if( glyphdraw ) {
			    	updaterects.or(srect);
		    	}
		    }
			ox += glyph.getGlyphMetrics(0).getAdvanceX();
		}
	}
	private static final boolean checkBounds( final Rect drect, final Rectangle srect ) {
		// check boundary
		if( srect.x >= drect.right ) return false;
		if( (srect.x+srect.width) < drect.left ) return false;

		if( srect.y >= drect.bottom ) return false;
		if( (srect.y+srect.height) < drect.top ) return false;

		return true;
	}
	private AlphaComposite createAlphaComposite( int type, int opa ) {
		return AlphaComposite.getInstance( type, ((float)opa)/255.0f );
	}

	public final void saveAs( OutputStream output, final String name, final String type ) throws TJSException {
		if( WRITABLE_FORMANT_NAMES == null ) {
	    	WRITABLE_FORMANT_NAMES = ImageIO.getWriterFormatNames();
		}
		BufferedImage img = null;
		if( mImage instanceof BufferedImage ) {
			img = (BufferedImage)mImage;
		} else if( mImage != null ) {
			img = new BufferedImage( mImage.getWidth(null), mImage.getHeight(null), BufferedImage.TYPE_4BYTE_ABGR );
			Graphics2D g = (Graphics2D)img.getGraphics();
			g.setComposite( AlphaComposite.Src );
			g.drawImage( mImage, 0, 0, null );
			g.dispose();
		}
		if( img == null ) {
			Message.throwExceptionMessage(Message.InternalError);
			return;
		}

		boolean foundtype = false;
		if( type.startsWith("bmp") ) {
			final int count = WRITABLE_FORMANT_NAMES.length;
			for( int i = 0; i < count; i++ ) {
				if( WRITABLE_FORMANT_NAMES[i].equals("bmp") ) {
					foundtype = true;
					break;
				}
			}
		} else {
			final int count = WRITABLE_FORMANT_NAMES.length;
			for( int i = 0; i < count; i++ ) {
				if( WRITABLE_FORMANT_NAMES[i].equals(type) ) {
					foundtype = true;
					break;
				}
			}
		}
		if( foundtype == false ) {
			Message.throwExceptionMessage(Message.InvalidImageSaveType, type);
			return;
		}
		String format = type;
		if( "bmp24".equalsIgnoreCase(type) ) {
			BufferedImage dest = img = new BufferedImage( img.getWidth(), img.getHeight(), BufferedImage.TYPE_INT_BGR );
			Graphics2D g = (Graphics2D)dest.getGraphics();
			g.setComposite( AlphaComposite.Src );
			g.drawImage( img, 0, 0, null );
			g.dispose();
			img = null;
			img = dest;
		} else if( "bmp8".equalsIgnoreCase(type) ) {
			/*
			IndexColorModel icm = new IndexColorModel(8, GRAYSIZE, r, g, b );
			byte[] indexout = new byte[datasize];
			int i = 0;
			for (int y = 0; y < height; y++) {
				for (int x = 0; x < width; x++) {
					raster.getPixel(x, y, color);
					indexout[i] = (byte) color[0];
					i++;
				}
			}
			*/
			BufferedImage dest = new BufferedImage( img.getWidth(), img.getHeight(), BufferedImage.TYPE_BYTE_INDEXED );
			Graphics2D g = (Graphics2D)dest.getGraphics();
			g.setComposite( AlphaComposite.Src );
			g.drawImage( img, 0, 0, null );
			g.dispose();
			img = null;
			img = dest;
		} else if( "bmp32".equalsIgnoreCase(type) ) {
			format = "bmp";
		}
		try {
			ImageIO.write( img, format, output );
			output.close();
		} catch (IOException e) {
			img = null;
			Message.throwExceptionMessage(Message.WriteError );
		}
		img = null;
	}
	public final int getPoint(int x, int y) {
		return mImage.getRGB(x, y);
	}
	public final void setPoint(int x, int y, int n) {
		mImage.setRGB(x, y, n);
	}
	public void coerceData(boolean b) {
		mImage.coerceData(b);
	}
	public boolean isAlphaPremultiplied() {
		return mImage.isAlphaPremultiplied();
	}
	public void flipLR(Rect rect) {
		final int w = mImage.getWidth();
		final int h = mImage.getHeight();
		if( mLRFilpMatrix == null ) {
			//mLRFilpMatrix = new AffineTransform( -1.0, 0.0, 0.0, 1.0, 0.0, 0.0 );
			//mLRFilpMatrix = new AffineTransform();
			//mLRFilpMatrix.setToRotation(30 * Math.PI/180);
			mLRFilpMatrix = AffineTransform.getScaleInstance(-1.0,-1.0);
		}
		if( rect.left == 0 && rect.top == 0 && rect.right == w && rect.bottom == h ) {
			// 全体が対象
			/*
			BufferedImage tmp = new BufferedImage( w, h, mImage.getType() );
			Graphics2D g = tmp.createGraphics();
		    //g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC ); // バイキュービック
		    //g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR  ); // バイリニア
		    //g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR  ); // ニアレストネイバー
			g.setTransform( mLRFilpMatrix );
			g.drawImage( mImage, 0,0, null);
			g.drawRenderedImage( mImage, mLRFilpMatrix);
			g.dispose();
			mImage = null;
			mImage = tmp;
			*/

			/* この方法はやはり遅い、WritableRaster を使うのに比べて倍以上, バッファが int だった時は10倍以上遅い
			int[] src = mImage.getRGB( 0, 0, w, h, null, 0, w );
			final int w2 = w / 2;
			for( int y = 0; y < h; y++ ) {
				int ystart = y*w;
				for( int x = 0; x < w2; x++ ) {
					int pos = ystart+x;
					int dst = ystart+w-x-1;
					int c = src[pos];
					src[pos] = src[dst];
					src[dst] = c;
				}
			}
			mImage.setRGB(0, 0, w, h, src, 0, w );
			*/

			WritableRaster src = mImage.getRaster();
			DataBuffer buff = src.getDataBuffer();
			final int type = buff.getDataType();
			if( type == DataBuffer.TYPE_INT ) {
				DataBufferInt srcBuff = (DataBufferInt)buff;
				int[] s = srcBuff.getData();
				final int w2 = w / 2;
				int ystart = 0;
				for( int y = 0; y < h; y++ ) {
					for( int x = 0; x < w2; x++ ) {
						int pos = ystart+x;
						int dst = ystart+w-x-1;
						int c = s[pos];
						s[pos] = s[dst];
						s[dst] = c;
					}
					ystart += w;
				}
			} else if( type == DataBuffer.TYPE_BYTE ) {
				byte[] s = ((DataBufferByte) buff).getData();
				final int w2 = w / 2;
				final int stride = w * 4;
				int ystart = 0;
				for( int y = 0; y < h; y++ ) {
					for( int x = 0; x < w2; x++ ) {
						int pos = ystart+x*4;
						int dst = ystart+stride-(x+1)*4;
						byte c = s[pos];
						s[pos] = s[dst];
						s[dst] = c;
						c = s[pos+1];
						s[pos+1] = s[dst+1];
						s[dst+1] = c;
						c = s[pos+2];
						s[pos+2] = s[dst+2];
						s[dst+2] = c;
						c = s[pos+3];
						s[pos+3] = s[dst+3];
						s[dst+3] = c;
					}
					ystart += stride;
				}
			}
		} else {
			BufferedImage sub = mImage.getSubimage(rect.left, rect.top, rect.width(), rect.height() );
			Graphics2D g = sub.createGraphics();
			g.transform(mLRFilpMatrix);
			g.dispose();
		}
	}
	public void flipUD(Rect rect) {
		final int w = mImage.getWidth();
		final int h = mImage.getHeight();
		if( mUDFilpMatrix == null ) {
			mUDFilpMatrix = new AffineTransform( 1.0, 0.0, 0.0, -1.0, 0.0, 0.0 );
		}
		if( rect.left == 0 && rect.top == 0 && rect.right == w && rect.bottom == h ) {
			// 全体が対象
			BufferedImage tmp = new BufferedImage( w, h, mImage.getType() );
			Graphics2D g = tmp.createGraphics();
			g.drawRenderedImage( mImage,  mUDFilpMatrix);
			g.dispose();
			mImage = null;
			mImage = tmp;
		} else {
			BufferedImage sub = mImage.getSubimage(rect.left, rect.top, rect.width(), rect.height() );
			Graphics2D g = sub.createGraphics();
			g.transform(mUDFilpMatrix);
			g.dispose();
		}
	}
}
