package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.env.DrawTarget;
import jp.kirikiri.tvp2.env.Font;
import jp.kirikiri.tvp2.env.MenuItem;
import jp.kirikiri.tvp2.env.WindowForm;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;

public class WindowNI extends BaseWindowNI {

	private static int S_OK = 0;
	private WindowForm mForm;


	public static final int
		mcsVisible = 0, // the mouse cursor is visible
		mcsTempHidden = 1, // the mouse cursor is temporarily hidden
		mcsHidden = 2; // the mouse cursor is invisible

	static private final int imDisable = 0,
	imClose=1, imOpen=2, imDontCare=3, imSAlpha=4, imAlpha=5, imHira=6, imSKata=7, imKata=8, imChinese=9, imSHanguel=10, imHanguel=11;

	/*
	public WindowNI() {
		super();
	}
	*/
	public int construct( Variant[] param, Dispatch2 tjs_obj ) {
		int hr = super.construct( param, tjs_obj );
		if( hr < 0 ) return hr;
		mForm = new WindowForm( this );
		return S_OK;
	}

	public void invalidate() throws VariantException, TJSException {
		super.invalidate();
		if( mForm != null ) {
			mForm.invalidateClose();
			mForm = null;
		}

		// remove all events
		TVP.EventManager.cancelSourceEvents(mOwner);
		TVP.EventManager.cancelInputEvents(this);

		// Set Owner null
		mOwner = null;
	}
	@Override
	public boolean canDeliverEvents() {
		if( mForm == null ) return false;
		return getVisible() && mForm.getFormEnabled();
	}
	public WindowForm getForm() { return mForm; }
	public void notifyWindowClose() { mForm = null; }
	public void sendCloseMessage() {
		if( mForm != null ) mForm.sendCloseMessage();
	}
	public void tickBeat() throws TJSException {
		if( mForm != null ) mForm.tickBeat();
	}
	@Override
	protected boolean getWindowActive() {
		if( mForm != null ) return mForm.getWindowActive();
		return false;
	}
	public void resetDrawDevice() {
		if( mForm != null ) mForm.resetDrawDevice();
	}
	private static final int
		etUnknown = 0,
		etOnKeyDown = 1,
		etOnKeyUp = 2,
		etOnKeyPress = 3;
	public void postInputEvent( final String name, Dispatch2 params ) throws TJSException {
		// posts input event
		if( mForm == null ) return;

		final String key_name = "key";
		final String shift_name = "shift";

		// check input event name
		int type;

		if( "onKeyDown".equals(name) )
			type = etOnKeyDown;
		else if( "onKeyUp".equals(name) )
			type = etOnKeyUp;
		else if( "onKeyPress".equals(name) )
			type = etOnKeyPress;
		else
			type = etUnknown;

		if( type == etUnknown )
			Message.throwExceptionMessage(Message.SpecifiedEventNameIsUnknown, name);

		if( type == etOnKeyDown || type == etOnKeyUp ) {
			// this needs params, "key" and "shift"
			if(params == null)
				Message.throwExceptionMessage( Message.SpecifiedEventNeedsParameter, name );

			int key = 0;
			int shift = 0;

			Variant val = new Variant();
			int hr = params.propGet(0, key_name, val, params );
			if( hr >= 0 )
				key = val.asInteger();
			else
				Message.throwExceptionMessage( Message.SpecifiedEventNeedsParameter2, name, "key" );

			hr = params.propGet( 0, shift_name, val, params );
			if( hr >= 0  )
				shift = val.asInteger();
			else
				Message.throwExceptionMessage( Message.SpecifiedEventNeedsParameter2, name, "shift" );

			char vcl_key = (char) key;
			if( type == etOnKeyDown )
				mForm.internalKeyDown(key, shift);
			else if( type == etOnKeyUp )
				mForm.onKeyUp( vcl_key, shift );
		} else if( type == etOnKeyPress ) {
			// this needs param, "key"
			if( params == null )
				Message.throwExceptionMessage( Message.SpecifiedEventNeedsParameter, name );
			int key = 0;

			Variant val = new Variant();
			int hr = params.propGet(0, key_name, val, params );
			if( hr >= 0 )
				key = val.asInteger();
			else
				Message.throwExceptionMessage( Message.SpecifiedEventNeedsParameter2, name, "key" );

			char vcl_key = (char) key;
			mForm.onKeyPress( vcl_key);
		}
	}
	@Override
	public void notifySrcResize() throws TJSException {
		super.notifySrcResize();

		// is called from primary layer
		// ( or from WindowForm to reset paint box's size )
		Size s = new Size();
		getSrcSize( s );
		if( mForm != null )
			mForm.setPaintBoxSize( s.width, s.height );
	}
	void getSrcSize( Size s ) {
		s.width = 0;
		s.height = 0;
		LayerManager manager = getLayerManagerAt(mPrimaryLayerManagerIndex);
		if( manager == null ) return;
		if(!manager.getPrimaryLayerSize(s)) {
			s.width = 0;
			s.height = 0;
		}
	}
	@Override
	public void setDefaultMouseCursor() {
		// set window mouse cursor to default
		if( mForm != null ) mForm.setDefaultMouseCursor();
	}
	@Override
	public void setMouseCursor( int handle ) {
		// set window mouse cursor
		if( mForm != null ) mForm.setMouseCursor(handle);
	}

	@Override
	public void getCursorPos( Point pt ) {
		// get cursor pos in primary layer's coordinates
		if( mForm != null ) mForm.getCursorPos( pt );
	}

	@Override
	public void setCursorPos(int x, int y) {
		// set cursor pos in primar layer's coordinates
		if( mForm != null ) mForm.setCursorPos(x, y);
	}

	@Override
	public void windowReleaseCapture() {
		// ::ReleaseCapture(); // Windows API
	}

	@Override
	public void setHintText(String text) {
		// set hint text to window
		if( mForm != null ) mForm.setHintText(text);
	}
	@Override
	public void setAttentionPoint( LayerNI layer, Point pt ) {
		// set attention point to window
		if( mForm != null ) {
			Font font = null;
			if( layer != null ) {
				/*
				BaseBitmap bmp = layer.getMainImage();
				if( bmp != null )
					font = bmp.getFontCanvas().getFont();
				*/
			}
			mForm.setAttentionPoint(pt.x, pt.y, font);
		}
	}

	@Override
	public void disableAttentionPoint() {
		// disable attention point
		if( mForm != null ) mForm.disableAttentionPoint();
	}

	@Override
	public void setImeMode(int mode) {
		// set ime mode
		if( mForm != null ) mForm.setImeMode(mode);
	}

	public void setDefaultImeMode( int mode ) {
		// set default ime mode
		if( mForm != null ) {
//			mForm.setDefaultImeMode( mode, LayerManager.getFocusedLayer() == null );
		}
	}
	@Override
	public int getDefaultImeMode() {
		if( mForm != null ) return mForm.getDefaultImeMode();
		return imDisable;
	}
	@Override
	public void resetImeMode() {
		// set default ime mode ( default mode is imDisable; IME is disabled )
		if( mForm != null ) mForm.resetImeMode();
	}
	public void beginUpdate( final ComplexRect rects ) {
		super.beginUpdate(rects);
	}

	public void endUpdate() {
		super.endUpdate();
	}

	public MenuItem getRootMenuItem() {
		if( mForm == null ) return null;
		return mForm.getMainMenu();
	}

	public void setMenuBarVisible( boolean b ) throws TJSException {
		if( mForm == null ) return;
		if( mForm.getFullScreenMode() )
			Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
		mForm.setMenuBarVisible(b);
	}

	public boolean getMenuBarVisible() {
		if( mForm == null ) return false;
		return mForm.getMenuBarVisible();
	}

	/*
	int getMenuOwnerWindowHandle() {
		if( mForm == null ) return null;
		return mForm.getMenuOwnerWindowHandle();
	}

	int getSurfaceWindowHandle() {
		if( mForm == null ) return null;
		return mForm.getSurfaceWindowHandle();
	}
	*/

	public void zoomRectangle( Rect rect ) {
		if( mForm == null ) return;
		mForm.zoomRectangle( rect );
	}

	/*
	int getWindowHandle( int ofsx, int ofsy) {
		if( mForm == null ) return null;
		return mForm.getWindowHandle(ofsx, ofsy);
	}
	*/

	public void readjustVideoRect() {
		if( mForm == null ) return;

		/* TODO
		// re-adjust video rectangle.
		// this reconnects owner window and video offsets.

		tObjectListSafeLockHolder<BaseVideoOverlayNI> holder(VideoOverlay);
		int count = VideoOverlay.GetSafeLockedObjectCount();

		for( int i = 0; i < count; i++ ) {
			VideoOverlayNI item = (VideoOverlayNI)VideoOverlay.GetSafeLockedObjectAt(i);
			if( item != null ) item.resetOverlayParams();
		}
		*/
	}

	public void windowMoved() {
		// inform video overlays that the window has moved.
		// video overlays typically owns DirectDraw surface which is not a part of
		// normal window systems and does not matter where the owner window is.
		// so we must inform window moving to overlay window.

		/* TODO
		tObjectListSafeLockHolder<BaseVideoOverlayNI> holder(VideoOverlay);
		int count = VideoOverlay.GetSafeLockedObjectCount();
		for( int i = 0; i < count; i++ ) {
			VideoOverlayNI item = (VideoOverlayNI)VideoOverlay.GetSafeLockedObjectAt(i);
			if( item != null ) item.setRectangleToVideoOverlay();
		}
		*/
	}

	public void detachVideoOverlay() {
		// detach video overlay window
		// this is done before the window is being fullscreened or un-fullscreened.
		/* TODO
		tObjectListSafeLockHolder<BaseVideoOverlayNI> holder(VideoOverlay);
		int count = VideoOverlay.GetSafeLockedObjectCount();
		for( int i = 0; i < count; i++) {
			VideoOverlayNI item = (VideoOverlayNI)VideoOverlay.GetSafeLockedObjectAt(i);
			if( item != null ) item.detachVideoOverlay();
		}
		*/
	}

	/*
	public int getWindowHandleForPlugin() {
		if( mForm == null ) return null;
		return mForm.getWindowHandleForPlugin();
	}
	*/

	/*
	public void registerWindowMessageReceiver( int mode, Object proc, final Object userdata ) {
		if( mForm == null ) return;
		mForm.registerWindowMessageReceiver(mode, proc, userdata);
	}
	*/

	public void close() {
		if( mForm != null ) mForm.close();
	}
	/*
	public void onCloseQueryCalled( boolean b ) {
		if( mForm != null ) mForm.onCloseQueryCalled(b);
	}

*/
	public void beginMove() throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidMethodInFullScreen );
			mForm.beginMove();
		}
	}

	public void bringToFront() {
		if( mForm != null ) mForm.bringToFront();
	}

	public void update( int type ) throws VariantException, TJSException {
		if( mForm != null ) mForm.updateWindow(type);
	}

	public void showModal() throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidMethodInFullScreen );

			TVP.WindowList.clearAllWindowInputEvents();
			// cancel all input events that can cause delayed operation

			mForm.showWindowAsModal();
		}
	}

	public void hideMouseCursor() {
		if( mForm != null ) mForm.hideMouseCursor();
	}

	public boolean getVisible() {
		if( mForm == null ) return false;
		return mForm.getVisible();
	}

	public void setVisible(boolean s) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode())
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setVisible(s);
		}
	}


	public String getCaption() {
		if( mForm != null ) return mForm.getCaption();
		else return null;
	}

	public void setCaption( final String v ) {
		if( mForm != null ) mForm.setCaption( v );
	}

	public void setWidth( int w ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setWidth( w );
		}
	}

	public int getWidth() {
		if( mForm == null ) return 0;
		return mForm.getWidth();
	}

	public void setHeight( int h ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setHeight( h );
		}
	}

	public int getHeight() {
		if( mForm == null ) return 0;
		return mForm.getHeight();
	}

	public void setLeft( int l ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setLeft( l );
		}
	}

	public int getLeft() {
		if( mForm == null ) return 0;
		return mForm.getLeft();
	}

	public void setTop( int t ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setTop( t );
		}
	}

	public int getTop() {
		if( mForm == null ) return 0;
		return mForm.getTop();
	}

	public void setSize( int w, int h ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setSize( w, h );
		}
	}

	public void setMinWidth( int v ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setMinWidth( v );
		}
	}

	public int getMinWidth() {
		if( mForm != null ) return mForm.getMinWidth();
		else return 0;
	}

	public void setMinHeight(int v) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setMinHeight( v );
		}
	}

	public int getMinHeight() {
		if( mForm != null ) return mForm.getMinHeight();
		else return 0;
	}

	public void setMinSize(int w, int h) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setMinSize( w, h );
		}
	}

	public void setMaxWidth(int v) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setMaxWidth( v );
		}
	}

	public int getMaxWidth() {
		if( mForm != null ) return mForm.getMaxWidth();
		else return 0;
	}

	public void setMaxHeight(int v) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setMaxHeight( v );
		}
	}

	public int getMaxHeight() {
		if( mForm != null ) return mForm.getMaxHeight();
		else return 0;
	}

	public void setMaxSize(int w, int h) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setMaxSize( w, h );
		}
	}

	public void setPosition( int l, int t) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setPosition( l, t );
		}
	}

	public void setLayerLeft( int l ) {
		if( mForm != null ) mForm.setLayerLeft(l);
	}

	public int getLayerLeft() {
		if( mForm == null ) return 0;
		return mForm.getLayerLeft();
	}

	public void setLayerTop( int t ) {
		if( mForm != null ) mForm.setLayerTop(t);
	}

	public int getLayerTop() {
		if( mForm == null ) return 0;
		return mForm.getLayerTop();
	}

	public void setLayerPosition( int l, int t ) {
		if( mForm != null ) mForm.setLayerPosition(l, t);
	}

	public void setInnerSunken( boolean b ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setInnerSunken( b );
		}
	}

	public boolean getInnerSunken() {
		if( mForm == null ) return true;
		return mForm.getInnerSunken();
	}

	public void setInnerWidth( int w ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setInnerWidth( w );
		}
	}

	public int getInnerWidth() {
		if( mForm == null ) return 0;
		return mForm.getInnerWidth();
	}

	public void setInnerHeight( int h ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setInnerHeight( h );
		}
	}

	public int getInnerHeight() {
		if( mForm != null ) return 0;
		return mForm.getInnerHeight();
	}

	public void setInnerSize( int w, int h ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setInnerSize(w, h);
		}
	}
	public void setBorderStyle( int st ) throws TJSException {
		if( mForm != null ) {
			if( mForm.getFullScreenMode() )
				Message.throwExceptionMessage( Message.InvalidPropertyInFullScreen );
			mForm.setBorderStyle(st);
		}
	}

	public int getBorderStyle() {
		if( mForm == null ) return 0;
		return mForm.getBorderStyle();
	}
	public void setStayOnTop( boolean b ) {
		if( mForm == null ) return;
		mForm.setStayOnTop(b);
	}

	public boolean getStayOnTop() {
		if( mForm == null ) return false;
		return mForm.getStayOnTop();
	}

	public void setShowScrollBars(boolean b) {
		if( mForm != null ) mForm.setShowScrollBars(b);
	}

	public boolean getShowScrollBars() {
		if( mForm == null ) return true;
		return mForm.getShowScrollBars();
	}

	public void setFullScreen(boolean b) {
		if( mForm == null ) return;
		mForm.setFullScreenMode(b);
	}

	public boolean getFullScreen() {
		if( mForm == null ) return false;
		return mForm.getFullScreenMode();
	}

	public void setUseMouseKey(boolean b) {
		if(mForm == null) return;
		mForm.setUseMouseKey(b);
	}

	public boolean getUseMouseKey() {
		if( mForm == null ) return false;
		return mForm.getUseMouseKey();
	}

	public void setTrapKey(boolean b) {
		if( mForm == null ) return;
		mForm.setTrapKey(b);
	}

	public boolean getTrapKey() {
		if( mForm == null ) return false;
		return mForm.getTrapKey();
	}

	public void setMaskRegion( int threshold ) {
		if( mForm == null ) return;

		/* TODO
		if( mDrawDevice == null )
			Message.throwExceptionMessage(Message.WindowHasNoLayer);
		BaseLayerNI lay = mDrawDevice.getPrimaryLayer();
		if( lay == null )
			Message.throwExceptionMessage( Message.WindowHasNoLayer );
		mForm.setMaskRegion(((LayerNI)lay).createMaskRgn( threshold ) );
		*/
	}


	public void removeMaskRegion() {
		if( mForm == null ) return;
		mForm.removeMaskRegion();
	}

	public void setMouseCursorState( int mcs ) {
		if( mForm == null ) return;
		mForm.setMouseCursorState(mcs);
	}

	public int getMouseCursorState() {
		if( mForm == null ) return mcsVisible;
		return mForm.getMouseCursorState();
	}

	public void setFocusable(boolean b) {
		if( mForm == null ) return;
		mForm.setFocusable(b);
	}

	public boolean getFocusable() {
		if( mForm != null ) return true;
		return mForm.getFocusable();
	}

	public void setZoom( int numer, int denom ) {
		if( mForm == null ) return;
		mForm.setZoom(numer, denom);
	}
	public void setZoomNumer( int n ){
		if( mForm == null ) return;
		mForm.setZoomNumer(n);
	}

	public int getZoomNumer() {
		if( mForm == null ) return 1;
		return mForm.getZoomNumer();
	}

	public void setZoomDenom(int n) {
		if( mForm == null ) return;
		mForm.setZoomDenom(n);
	}
	public int getZoomDenom() {
		if( mForm == null ) return 1;
		return mForm.getZoomDenom();
	}
	public static void makeFullScreenModeCandidates(ScreenMode preferred,
			int mode, int zoom_mode, ArrayList<ScreenModeCandidate> candidates) {
		WindowForm.makeFullScreenModeCandidates(preferred, mode, zoom_mode, candidates);
	}

	public void registerWindowMessageReceiver(int asInteger, Dispatch2 asObject, Dispatch2 asObject2) {
		// TODO 自動生成されたメソッド・スタブ
	}

	@Override
	void createOffscreenImage() {
		/* TODO 要らないかな？
		if( mForm != null ) {
			mOffscreenBuffer = mForm.createOffscreenImage();
		}
		*/
	}

	public void onCloseQueryCalled(boolean b) throws VariantException, TJSException {
		if(mForm!=null) mForm.onCloseQueryCalled(b);
	}
}
