package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.env.PadForm;
import jp.kirikiri.tvp2.env.SystemColor;


public class PadNI extends NativeInstanceObject {
	private static final int S_OK = 0;
	private PadForm mForm;
	/**
	 * true if this form was created by the userscript,
	 * otherwise (when created by the system as "Script Editor") this will be false
	 */
	private boolean mUserCreationMode;
	//private boolean mMultilineMode;

	public int construct( Variant[] param, Dispatch2 dsp ) throws VariantException, TJSException {
		int hr = super.construct(param, dsp);
		if( hr < 0 ) return hr;

		mForm = new PadForm();
		mForm.setExecButtonEnabled(false);

		return S_OK;
	}
	public void invalidate() throws VariantException, TJSException {
		if(mForm!=null) mForm = null;
		super.invalidate();
	}

	// methods
	public void openFromStorage( final String name) {
	}
	public void saveToStorage( final String name) {
	}

	// properties
	public int getColor() {
		return mForm.getEditColor();
	}
	public void setColor(int color) {
		mForm.setEditColor(color);
	}
	public boolean getVisible() {
		return mForm.getVisible();
	}
	public void setVisible(boolean state) {
		mForm.setVisible(state);
	}
	public String getFileName() {
		return mForm.getFileName();
	}
	public void setFileName( final String name) {
		mForm.setFileName(name);
	}
	public void setText( final String content) {
		mForm.setLines(content);
	}
	public String getText() {
		return mForm.getLines();
	}
	public void setTitle( final String title) {
		mForm.setTitle( title );
	}
	public String getTitle() {
		return mForm.getTitle();
	}

	public int getFontColor() {
		return mForm.getFontColor();
	}
	public void setFontColor(int color) {
		mForm.setFontColor(color);
	}
	public int getFontHeight() {
		return mForm.getFontHeight();
	}	// pixel
	public void setFontHeight(int height) {
		mForm.setFontHeight(height);
	}

	public int getFontSize() {
		return mForm.getFontSize();
	}	// point
	public void setFontSize(int size) {
		mForm.setFontSize(size);
	}

	public boolean containsFontStyle(int style) {
		return mForm.containsFontStyle(style);
	}
	public void addFontStyle(int style) {
		mForm.addFontStyle(style);
	}
	public void removeFontStyle(int style) {
		mForm.removeFontStyle(style);
	}

	public boolean getFontBold() {
		return mForm.getFontBold();
	}
	public void setFontBold( boolean b ) {
		mForm.setFontBold(b);
	}
	public boolean getFontItalic() {
		return mForm.getFontItalic();
	}
	public void setFontItalic( boolean b ) {
		mForm.setFontItalic(b);
	}
	public boolean getFontUnderline() {
		return mForm.getFontUnderline();
	}
	public void setFontUnderline( boolean b ) {
		mForm.setFontUnderline(b);
	}
	public boolean getFontStrikeOut() {
		return mForm.getFontStrikeOut();
	}
	public void setFontStrikeOut( boolean b ) {
		mForm.setFontStrikeOut(b);
	}

	public String getFontName() {
		return mForm.getFontName();
	}
	public void setFontName( final String name ) {
		mForm.setFontName(name);
	}

	public boolean isReadOnly() {
		return mForm.getReadOnly();
	}
	public void setReadOnly(boolean ro) {
		mForm.setReadOnly(ro);
	}

	public boolean getWordWrap() {
		return mForm.getWordWrap();
	}
	public void setWordWrap(boolean ww) {
		mForm.setWordWrap(ww);
	}

	public int getOpacity() {
		return mForm.getOpacity();
	}
	public void setOpacity(int opa) {
		mForm.setOpacity(opa);
	}

	public boolean getStatusBarVisible() {
		return mForm.getStatusBarVisible();
	}
	public void setStatusBarVisible(boolean vis) {
		mForm.setStatusBarVisible(vis);
	}

	public int getScrollBarsVisible() {
		return mForm.getScrollBarsVisible();
	}
	public void setScrollBarsVisible(int vis) {
		mForm.setScrollBarsVisible(vis);
	}

	public int getBorderStyle() {
		return mForm.getBorderStyle();
	}
	public void setBorderStyle(int style) {
		mForm.setBorderStyle(style);
	}

	public String getStatusText() {
		return mForm.getStatusText();
	}
	public void setStatusText( final String title) {
		mForm.setStatusText(title);
	}

	// form position and size
	public int getFormHeight() {
		return mForm.getFormHeight();
	}
	public int getFormWidth() {
		return mForm.getFormWidth();
	}
	public int getFormTop() {
		return mForm.getFormTop();
	}
	public int getFormLeft() {
		return mForm.getFormLeft();
	}
	public void setFormHeight(int value) {
		mForm.setFormHeight(value);
	}
	public void setFormWidth(int value) {
		mForm.setFormWidth(value);
	}
	public void setFormTop(int value) {
		mForm.setFormTop(value);
	}
	public void setFormLeft(int value) {
		mForm.setFormLeft(value);
	}

	//
	public boolean getUserCreationMode() {
		return mUserCreationMode;
	}
	public void setUserCreationMode(boolean user) {
		mUserCreationMode = user;
		if( user ) {
			mForm.setToolBarVisible(false);
			mForm.setToolBarEnabled(false);
			mForm.setExecuteButtonVisible(false);
			mForm.setExecuteButtonEnabled(false);
			mForm.setStatusBarLeft(0);

			mForm.setEditColor(SystemColor.clWindow);
			mForm.setFontColor(SystemColor.clWindowText);
			mForm.setStatusBarWidth( mForm.getWidth() );
		}
	}

}
