package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.Logger;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.msg.Message;

public class DebugClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_MEMBERNOTFOUND = -1001,
		E_NOTIMPL		= -1002,
		E_BADPARAMCOUNT	= -1004,
		E_INVALIDOBJECT	= -1006,
		E_ACCESSDENYED	= -1007,
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0,
		S_TRUE			= 1;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static final private int STATICMEMBER	= 0x00010000;

	static private final String CLASS_NAME = "Debug";

	public static void addLog( String mes ) {
		TVP.DebugLog.addLog( mes );
	}
	public static void addImportantLog( String mes ) {
		TVP.DebugLog.addImportantLog( mes );
	}

	protected NativeInstance createNativeInstance() {
		return null;
	}

	public DebugClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );

		registerNCM( "message", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( param.length == 1 ) {
					addLog( param[0].asString() );
				} else {
					// display the arguments separated with ", "
					StringBuilder builder = new StringBuilder(512);
					for( int i = 0; i < param.length; i++ ) {
						if( i != 0 ) builder.append(", ");
						builder.append( param[i].asString() );
					}
					addLog( builder.toString() );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "notice", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				if( param.length < 1 ) return E_BADPARAMCOUNT;
				if( param.length == 1 ) {
					addImportantLog( param[0].asString() );
				} else {
					// display the arguments separated with ", "
					StringBuilder builder = new StringBuilder(512);
					for( int i = 0; i < param.length; i++ ) {
						if( i != 0 ) builder.append(", ");
						builder.append( param[i].asString() );
					}
					addImportantLog( builder.toString() );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "startLogToFile", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				boolean clear = false;
				if( param.length >= 1) clear = param[0].asBoolean();
				TVP.DebugLog.startLogToFile(clear);
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		registerNCM( "logAsError", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException {
				TVP.DebugLog.onError();
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, STATICMEMBER );

		// property
		registerNCM( "logLocation", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DebugLog.getLogLocation() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException, TJSException {
				TVP.DebugLog.setLogLocation( param.asString() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "logToFileOnError", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DebugLog.getAutoLogToFileOnError() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.DebugLog.setAutoLogToFileOnError( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "clearLogFileOnError", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				result.set( TVP.DebugLog.getAutoClearLogOnError() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TVP.DebugLog.setAutoClearLogOnError( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "controller", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				Dispatch2 dsp = TVP.getControllerClass();
				result.set( dsp, dsp );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		registerNCM( "console", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				Dispatch2 dsp = TVP.getConsoleClass();
				result.set( dsp, dsp );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) { return E_ACCESSDENYED; }
		}, CLASS_NAME, nitProperty, STATICMEMBER );

		// put version information to DMS
		addImportantLog( TVP.Application.getVersionInformation() );
		addImportantLog( Message.VersionInformation2  );
	}

}
