package jp.kirikiri.tvp2.env;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class CustomOperationComposite implements Composite {

	/* Opacity の影響を受けないものは、事前に生成して置いてそれを返す方がいいな
	 * */
	public static byte[] OpacityOnOpacityTable;
	public static byte[] NegativeMulTable;
	public static void initialize() {
		OpacityOnOpacityTable = new byte[256*256];
		NegativeMulTable = new byte[256*256];

		int a,b;
		for( a = 0; a < 256; a++ ) {
			for( b = 0; b < 256; b++ ) {
				float c;
				int ci;
				int addr = b*256+ a;
				if( a != 0 ) {
					float at = a/255.0f, bt = b/255.0f;
					c = bt / at;
					c /= (1.0 - bt + c);
					ci = (int)(c*255);
					if(ci>=256) ci = 255; /* will not overflow... */
				} else {
					ci=255;
				}
				OpacityOnOpacityTable[addr]=(byte)(ci&0xff);
					/* higher byte of the index is source opacity */
					/* lower byte of the index is destination opacity */
				NegativeMulTable[addr] = (byte)(( 255 - (255-a)*(255-b)/ 255 )&0xff);
			}
		}
	}

	static private final int
		bmCopy = 0,
		bmCopyOnAlpha = 1,
		bmAlpha = 2,
		bmAlphaOnAlpha = 3,
		bmAdd = 4,
		bmSub = 5,
		bmMul = 6,
		bmDodge = 7,
		bmDarken = 8,
		bmLighten = 9,
		bmScreen = 10,
		bmAddAlpha = 11,
		bmAddAlphaOnAddAlpha = 12,
		bmAddAlphaOnAlpha = 13,
		bmAlphaOnAddAlpha = 14,
		bmCopyOnAddAlpha = 15,
		bmPsNormal = 16,
		bmPsAdditive = 17,
		bmPsSubtractive = 18,
		bmPsMultiplicative = 19,
		bmPsScreen = 20,
		bmPsOverlay = 21,
		bmPsHardLight = 22,
		bmPsSoftLight = 23,
		bmPsColorDodge = 24,
		bmPsColorDodge5 = 25,
		bmPsColorBurn = 26,
		bmPsLighten = 27,
		bmPsDarken = 28,
		bmPsDifference = 29,
		bmPsDifference5 = 30,
		bmPsExclusion = 31;

	private int mMethod;
	private int mOpacity;
	private boolean mHoldAlpha;
	public CustomOperationComposite( int method, int opacity, boolean hda ) {
		mMethod = method;
		mOpacity = opacity;
		mHoldAlpha = hda;
	}
	@Override
	public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
		switch( mMethod ) {
		case bmCopy:
			if( mOpacity == 255 && mHoldAlpha ) { // CopyColor
				return new CopyColor();
			} else if( !mHoldAlpha ) { // ConstAlphaBlend
				return new ConstAlphaBlend(mOpacity);
			} else { // ConstAlphaBlend_HDA
				return new ConstAlphaBlend_HDA(mOpacity);
			}
		case bmCopyOnAlpha:
			if( mOpacity == 255 ) { // CopyOpaqueImage
				return new CopyOpaqueImage();
			} else { // ConstAlphaBlend_d
				return new ConstAlphaBlend_d(mOpacity);
			}
		case bmAlpha:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // AlphaBlend
					return new AlphaBlend();
				} else { // AlphaBlend_HDA
					return new AlphaBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // AlphaBlend_o
					return new AlphaBlend_o(mOpacity);
				} else { // AlphaBlend_HDA_o
					return new AlphaBlend_HDA_o(mOpacity);
				}
			}
		case bmAlphaOnAlpha:
			if( mOpacity == 255 ) { // AlphaBlend_d
				return new AlphaBlend_d(mOpacity);
			} else { // AlphaBlend_do
				return new AlphaBlend_do(mOpacity);
			}
		case bmAdd:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // AddBlend
					return new AddBlend(mOpacity);
				} else { // AddBlend_HDA
					return new AddBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // AddBlend_o
					return new AddBlend_o(mOpacity);
				} else { // AddBlend_HDA_o
					return new AddBlend_HDA_o(mOpacity);
				}
			}
		case bmSub:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // SubBlend
					return new SubBlend(mOpacity);
				} else { // SubBlend_HDA
					return new SubBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // SubBlend_o
					return new SubBlend_o(mOpacity);
				} else { // SubBlend_HDA_o
					return new SubBlend_HDA_o(mOpacity);
				}
			}
		case bmMul:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // MulBlend
					return new MulBlend(mOpacity);
				} else { // MulBlend_HDA
					return new MulBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // MulBlend_o
					return new MulBlend_o(mOpacity);
				} else { // MulBlend_HDA_o
					return new MulBlend_HDA_o(mOpacity);
				}
			}
		case bmDodge:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // ColorDodgeBlend
					return new ColorDodgeBlend(mOpacity);
				} else { // ColorDodgeBlend_HDA
					return new ColorDodgeBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // ColorDodgeBlend_o
					return new ColorDodgeBlend_o(mOpacity);
				} else { // ColorDodgeBlend_HDA_o
					return new ColorDodgeBlend_HDA_o(mOpacity);
				}
			}
		case bmDarken:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // DarkenBlend
					return new DarkenBlend(mOpacity);
				} else { // DarkenBlend_HDA
					return new DarkenBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // DarkenBlend_o
					return new DarkenBlend_o(mOpacity);
				} else { // DarkenBlend_HDA_o
					return new DarkenBlend_HDA_o(mOpacity);
				}
			}
		case bmLighten:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // LightenBlend
					return new LightenBlend(mOpacity);
				} else { // LightenBlend_HDA
					return new LightenBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // LightenBlend_o
					return new LightenBlend_o(mOpacity);
				} else { // LightenBlend_HDA_o
					return new LightenBlend_HDA_o(mOpacity);
				}
			}
		case bmScreen:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // ScreenBlend
					return new ScreenBlend(mOpacity);
				} else { // ScreenBlend_HDA
					return new ScreenBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // ScreenBlend_o
					return new ScreenBlend_o(mOpacity);
				} else { // ScreenBlend_HDA_o
					return new ScreenBlend_HDA_o(mOpacity);
				}
			}
		case bmAddAlpha:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // AdditiveAlphaBlend
					return new AdditiveAlphaBlend(mOpacity);
				} else { // AdditiveAlphaBlend_HDA
					return new AdditiveAlphaBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // AdditiveAlphaBlend_o
					return new AdditiveAlphaBlend_o(mOpacity);
				} else { // AdditiveAlphaBlend_HDA_o
					return new AdditiveAlphaBlend_HDA_o(mOpacity);
				}
			}
		case bmAddAlphaOnAddAlpha:
			if( mOpacity == 255 ) { // AdditiveAlphaBlend_a
				return new AdditiveAlphaBlend_a(mOpacity);
			} else { // AdditiveAlphaBlend_ao
				return new AdditiveAlphaBlend_ao(mOpacity);
			}
		case bmAddAlphaOnAlpha:
			// additive alpha on simple alpha
			// Not yet implemented
			break;
		case bmAlphaOnAddAlpha:
			if( mOpacity == 255 ) { // AlphaBlend_a
				return new AlphaBlend_a(mOpacity);
			} else { // AlphaBlend_ao
				return new AlphaBlend_ao(mOpacity);
			}
		case bmCopyOnAddAlpha:
			if( mOpacity == 255 ) { // CopyOpaqueImage
				return new CopyOpaqueImage();
			} else { // ConstAlphaBlend_a
				return new ConstAlphaBlend_a(mOpacity);
			}
		case bmPsNormal:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsAlphaBlend
					return new PsAlphaBlend(mOpacity);
				} else { // PsAlphaBlend_HDA
					return new PsAlphaBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsAlphaBlend_o
					return new PsAlphaBlend_o(mOpacity);
				} else { // PsAlphaBlend_HDA_o
					return new PsAlphaBlend_HDA_o(mOpacity);
				}
			}
		case bmPsAdditive:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsAddBlend
					return new PsAddBlend(mOpacity);
				} else { // PsAddBlend_HDA
					return new PsAddBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsAddBlend_o
					return new PsAddBlend_o(mOpacity);
				} else { // PsAddBlend_HDA_o
					return new PsAddBlend_HDA_o(mOpacity);
				}
			}
		case bmPsSubtractive:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsSubBlend
					return new PsSubBlend(mOpacity);
				} else { // PsSubBlend_HDA
					return new PsSubBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsSubBlend_o
					return new PsSubBlend_o(mOpacity);
				} else { // PsSubBlend_HDA_o
					return new PsSubBlend_HDA_o(mOpacity);
				}
			}
		case bmPsMultiplicative:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsMulBlend
					return new PsMulBlend(mOpacity);
				} else { // PsMulBlend_HDA
					return new PsMulBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsMulBlend_o
					return new PsMulBlend_o(mOpacity);
				} else { // PsMulBlend_HDA_o
					return new PsMulBlend_HDA_o(mOpacity);
				}
			}
		case bmPsScreen:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsScreenBlend
					return new PsScreenBlend(mOpacity);
				} else { // PsScreenBlend_HDA
					return new PsScreenBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsScreenBlend_o
					return new PsScreenBlend_o(mOpacity);
				} else { // PsScreenBlend_HDA_o
					return new PsScreenBlend_HDA_o(mOpacity);
				}
			}
		case bmPsOverlay:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsOverlayBlend
					return new PsOverlayBlend(mOpacity);
				} else { // PsOverlayBlend_HDA
					return new PsOverlayBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsOverlayBlend_o
					return new PsOverlayBlend_o(mOpacity);
				} else { // PsOverlayBlend_HDA_o
					return new PsOverlayBlend_HDA_o(mOpacity);
				}
			}
		case bmPsHardLight:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsHardLightBlend
					return new PsHardLightBlend(mOpacity);
				} else { // PsHardLightBlend_HDA
					return new PsHardLightBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsHardLightBlend_o
					return new PsHardLightBlend_o(mOpacity);
				} else { // PsHardLightBlend_HDA_o
					return new PsHardLightBlend_HDA_o(mOpacity);
				}
			}
		case bmPsSoftLight:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsSoftLightBlend
					return new PsSoftLightBlend(mOpacity);
				} else { // PsSoftLightBlend_HDA
					return new PsSoftLightBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsSoftLightBlend_o
					return new PsSoftLightBlend_o(mOpacity);
				} else { // PsSoftLightBlend_HDA_o
					return new PsSoftLightBlend_HDA_o(mOpacity);
				}
			}
		case bmPsColorDodge:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsColorDodgeBlend
					return new PsColorDodgeBlend(mOpacity);
				} else { // PsColorDodgeBlend_HDA
					return new PsColorDodgeBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsColorDodgeBlend_o
					return new PsColorDodgeBlend_o(mOpacity);
				} else { // PsColorDodgeBlend_HDA_o
					return new PsColorDodgeBlend_HDA_o(mOpacity);
				}
			}
		case bmPsColorDodge5:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsColorDodge5Blend
					return new PsColorDodge5Blend(mOpacity);
				} else { // PsColorDodge5Blend_HDA
					return new PsColorDodge5Blend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsColorDodge5Blend_o
					return new PsColorDodge5Blend_o(mOpacity);
				} else { // PsColorDodge5Blend_HDA_o
					return new PsColorDodge5Blend_HDA_o(mOpacity);
				}
			}
		case bmPsColorBurn:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsColorBurnBlend
					return new PsColorBurnBlend(mOpacity);
				} else { // PsColorBurnBlend_HDA
					return new PsColorBurnBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsColorBurnBlend_o
					return new PsColorBurnBlend_o(mOpacity);
				} else { // PsColorBurnBlend_HDA_o
					return new PsColorBurnBlend_HDA_o(mOpacity);
				}
			}
		case bmPsLighten:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsLightenBlend
					return new PsLightenBlend(mOpacity);
				} else { // PsLightenBlend_HDA
					return new PsLightenBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsLightenBlend_o
					return new PsLightenBlend_o(mOpacity);
				} else { // PsLightenBlend_HDA_o
					return new PsLightenBlend_HDA_o(mOpacity);
				}
			}
		case bmPsDarken:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsDarkenBlend
					return new PsDarkenBlend(mOpacity);
				} else { // PsDarkenBlend_HDA
					return new PsDarkenBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsDarkenBlend_o
					return new PsDarkenBlend_o(mOpacity);
				} else { // PsDarkenBlend_HDA_o
					return new PsDarkenBlend_HDA_o(mOpacity);
				}
			}
		case bmPsDifference:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsDiffBlend
					return new PsDiffBlend(mOpacity);
				} else { // PsDiffBlend_HDA
					return new PsDiffBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsDiffBlend_o
					return new PsDiffBlend_o(mOpacity);
				} else { // PsDiffBlend_HDA_o
					return new PsDiffBlend_HDA_o(mOpacity);
				}
			}
		case bmPsDifference5:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsDiff5Blend
					return new PsDiff5Blend(mOpacity);
				} else { // PsDiff5Blend_HDA
					return new PsDiff5Blend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsDiff5Blend_o
					return new PsDiff5Blend_o(mOpacity);
				} else { // PsDiff5Blend_HDA_o
					return new PsDiff5Blend_HDA_o(mOpacity);
				}
			}
		case bmPsExclusion:
			if( mOpacity == 255 ) {
				if( !mHoldAlpha ) { // PsExclusionBlend
					return new PsExclusionBlend(mOpacity);
				} else { // PsExclusionBlend_HDA
					return new PsExclusionBlend_HDA(mOpacity);
				}
			} else {
				if( !mHoldAlpha ) { // PsExclusionBlend_o
					return new PsExclusionBlend_o(mOpacity);
				} else { // PsExclusionBlend_HDA_o
					return new PsExclusionBlend_HDA_o(mOpacity);
				}
			}
		}
		return AlphaComposite.Src.createContext(srcColorModel, dstColorModel, hints);
	}

	static class CopyColor implements CompositeContext {
		public CopyColor() {}
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = (d[i]&0xff000000) | (s[i]&0x00ffffff);
			}
		}
	}

	static class ConstAlphaBlend implements CompositeContext {
		private int mOpacity;
		public ConstAlphaBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			int d1, s0, d0;
			int opa = mOpacity;
			for( int i = 0; i < length; i++ ) {
				s0 = s[i];
				d0 = d[i];
				d1 = d0 & 0xff00ff;
				d1 = ((d1 + (((s0 & 0xff00ff) - d1) * opa >>> 8)) & 0xff00ff);
				d0 &= 0xff00;
				s0 &= 0xff00;
				o[i] = d1 | ((d0 + ((s0 - d0) * opa >>> 8)) & 0xff00);
			}
		}
	}

	static class ConstAlphaBlend_HDA implements CompositeContext {
		private int mOpacity;
		public ConstAlphaBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			int d1, s0, d0;
			int opa = mOpacity;
			for( int i = 0; i < length; i++ ) {
				s0 = s[i];
				d0 = d[i];
				d1 = d0 & 0xff00ff;
				d1 = ((d1 + (((s0 & 0xff00ff) - d1) * opa >>> 8)) & 0xff00ff) | (d0 & 0xff000000);
				d0 &= 0xff00;
				s0 &= 0xff00;
				o[i] = d1 | ((d0 + ((s0 - d0) * opa >>> 8)) & 0xff00);
			}
		}
	}

	static class CopyOpaqueImage implements CompositeContext {
		public CopyOpaqueImage() {}
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			//DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			//int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = (s[i] | 0xff000000);
			}
		}
	}

	static class ConstAlphaBlend_d implements CompositeContext {
		private int mOpacity;
		public ConstAlphaBlend_d( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			int d1, s0, d0, addr;
			int alpha;
			int opa = mOpacity << 8;
			for( int i = 0; i < length; i++ ) {
				s0 = s[i];
				d0 = d[i];
				addr = opa + (d0>>>24);
				alpha = OpacityOnOpacityTable[addr];
				d1 = d0 & 0xff00ff;
				d1 = ((d1 + (((s0 & 0xff00ff) - d1) * alpha >>> 8)) & 0xff00ff) | (NegativeMulTable[addr]<<24);
				d0 &= 0xff00;
				s0 &= 0xff00;
				o[i] = d1 | ((d0 + ((s0 - d0) * alpha >> 8)) & 0xff00);
			}
		}
	}

	static class AlphaBlend implements CompositeContext {
		public AlphaBlend() {}
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			int d1, s0, d0, sopa;
			for( int i = 0; i < length; i++ ) {
				s0 = s[i];
				d0 = d[i];
				sopa = s0 >>> 24;
				d1 = d0 & 0xff00ff;
				d1 = (d1 + (((s0 & 0xff00ff) - d1) * sopa >>> 8)) & 0xff00ff;
				d0 &= 0xff00;
				s0 &= 0xff00;
				o[i] = d1 + ((d0 + ((s0 - d0) * sopa >>> 8)) & 0xff00);
			}
		}
	}

	static class AlphaBlend_HDA implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AlphaBlend_o implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AlphaBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AlphaBlend_d implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_d( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AlphaBlend_do implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_do( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AddBlend implements CompositeContext {
		private int mOpacity;
		public AddBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AddBlend_HDA implements CompositeContext {
		private int mOpacity;
		public AddBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AddBlend_o implements CompositeContext {
		private int mOpacity;
		public AddBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AddBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public AddBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class SubBlend implements CompositeContext {
		private int mOpacity;
		public SubBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class SubBlend_HDA implements CompositeContext {
		private int mOpacity;
		public SubBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class SubBlend_o implements CompositeContext {
		private int mOpacity;
		public SubBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class SubBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public SubBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class MulBlend implements CompositeContext {
		private int mOpacity;
		public MulBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class MulBlend_HDA implements CompositeContext {
		private int mOpacity;
		public MulBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class MulBlend_o implements CompositeContext {
		private int mOpacity;
		public MulBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class MulBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public MulBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ColorDodgeBlend implements CompositeContext {
		private int mOpacity;
		public ColorDodgeBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ColorDodgeBlend_HDA implements CompositeContext {
		private int mOpacity;
		public ColorDodgeBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ColorDodgeBlend_o implements CompositeContext {
		private int mOpacity;
		public ColorDodgeBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ColorDodgeBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public ColorDodgeBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class DarkenBlend implements CompositeContext {
		private int mOpacity;
		public DarkenBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class DarkenBlend_HDA implements CompositeContext {
		private int mOpacity;
		public DarkenBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class DarkenBlend_o implements CompositeContext {
		private int mOpacity;
		public DarkenBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class DarkenBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public DarkenBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class LightenBlend implements CompositeContext {
		private int mOpacity;
		public LightenBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class LightenBlend_HDA implements CompositeContext {
		private int mOpacity;
		public LightenBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class LightenBlend_o implements CompositeContext {
		private int mOpacity;
		public LightenBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class LightenBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public LightenBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ScreenBlend implements CompositeContext {
		private int mOpacity;
		public ScreenBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ScreenBlend_HDA implements CompositeContext {
		private int mOpacity;
		public ScreenBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ScreenBlend_o implements CompositeContext {
		private int mOpacity;
		public ScreenBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ScreenBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public ScreenBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AdditiveAlphaBlend implements CompositeContext {
		private int mOpacity;
		public AdditiveAlphaBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AdditiveAlphaBlend_HDA implements CompositeContext {
		private int mOpacity;
		public AdditiveAlphaBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AdditiveAlphaBlend_o implements CompositeContext {
		private int mOpacity;
		public AdditiveAlphaBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AdditiveAlphaBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public AdditiveAlphaBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AdditiveAlphaBlend_a implements CompositeContext {
		private int mOpacity;
		public AdditiveAlphaBlend_a( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AdditiveAlphaBlend_ao implements CompositeContext {
		private int mOpacity;
		public AdditiveAlphaBlend_ao( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AlphaBlend_a implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_a( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class AlphaBlend_ao implements CompositeContext {
		private int mOpacity;
		public AlphaBlend_ao( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class ConstAlphaBlend_a implements CompositeContext {
		private int mOpacity;
		public ConstAlphaBlend_a( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAlphaBlend implements CompositeContext {
		private int mOpacity;
		public PsAlphaBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAlphaBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsAlphaBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAlphaBlend_o implements CompositeContext {
		private int mOpacity;
		public PsAlphaBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAlphaBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsAlphaBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAddBlend implements CompositeContext {
		private int mOpacity;
		public PsAddBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAddBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsAddBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAddBlend_o implements CompositeContext {
		private int mOpacity;
		public PsAddBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsAddBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsAddBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSubBlend implements CompositeContext {
		private int mOpacity;
		public PsSubBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSubBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsSubBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSubBlend_o implements CompositeContext {
		private int mOpacity;
		public PsSubBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSubBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsSubBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsMulBlend implements CompositeContext {
		private int mOpacity;
		public PsMulBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsMulBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsMulBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsMulBlend_o implements CompositeContext {
		private int mOpacity;
		public PsMulBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsMulBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsMulBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsScreenBlend implements CompositeContext {
		private int mOpacity;
		public PsScreenBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsScreenBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsScreenBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsScreenBlend_o implements CompositeContext {
		private int mOpacity;
		public PsScreenBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsScreenBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsScreenBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsOverlayBlend implements CompositeContext {
		private int mOpacity;
		public PsOverlayBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsOverlayBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsOverlayBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsOverlayBlend_o implements CompositeContext {
		private int mOpacity;
		public PsOverlayBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsOverlayBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsOverlayBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsHardLightBlend implements CompositeContext {
		private int mOpacity;
		public PsHardLightBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsHardLightBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsHardLightBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsHardLightBlend_o implements CompositeContext {
		private int mOpacity;
		public PsHardLightBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsHardLightBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsHardLightBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSoftLightBlend implements CompositeContext {
		private int mOpacity;
		public PsSoftLightBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSoftLightBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsSoftLightBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSoftLightBlend_o implements CompositeContext {
		private int mOpacity;
		public PsSoftLightBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsSoftLightBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsSoftLightBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodgeBlend implements CompositeContext {
		private int mOpacity;
		public PsColorDodgeBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodgeBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsColorDodgeBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodgeBlend_o implements CompositeContext {
		private int mOpacity;
		public PsColorDodgeBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodgeBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsColorDodgeBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodge5Blend implements CompositeContext {
		private int mOpacity;
		public PsColorDodge5Blend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodge5Blend_HDA implements CompositeContext {
		private int mOpacity;
		public PsColorDodge5Blend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodge5Blend_o implements CompositeContext {
		private int mOpacity;
		public PsColorDodge5Blend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorDodge5Blend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsColorDodge5Blend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorBurnBlend implements CompositeContext {
		private int mOpacity;
		public PsColorBurnBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorBurnBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsColorBurnBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorBurnBlend_o implements CompositeContext {
		private int mOpacity;
		public PsColorBurnBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsColorBurnBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsColorBurnBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsLightenBlend implements CompositeContext {
		private int mOpacity;
		public PsLightenBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsLightenBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsLightenBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsLightenBlend_o implements CompositeContext {
		private int mOpacity;
		public PsLightenBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsLightenBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsLightenBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDarkenBlend implements CompositeContext {
		private int mOpacity;
		public PsDarkenBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDarkenBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsDarkenBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDarkenBlend_o implements CompositeContext {
		private int mOpacity;
		public PsDarkenBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDarkenBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsDarkenBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiffBlend implements CompositeContext {
		private int mOpacity;
		public PsDiffBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiffBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsDiffBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiffBlend_o implements CompositeContext {
		private int mOpacity;
		public PsDiffBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiffBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsDiffBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiff5Blend implements CompositeContext {
		private int mOpacity;
		public PsDiff5Blend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiff5Blend_HDA implements CompositeContext {
		private int mOpacity;
		public PsDiff5Blend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiff5Blend_o implements CompositeContext {
		private int mOpacity;
		public PsDiff5Blend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsDiff5Blend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsDiff5Blend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsExclusionBlend implements CompositeContext {
		private int mOpacity;
		public PsExclusionBlend( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsExclusionBlend_HDA implements CompositeContext {
		private int mOpacity;
		public PsExclusionBlend_HDA( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsExclusionBlend_o implements CompositeContext {
		private int mOpacity;
		public PsExclusionBlend_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}

	static class PsExclusionBlend_HDA_o implements CompositeContext {
		private int mOpacity;
		public PsExclusionBlend_HDA_o( int opa ) { mOpacity = opa; }
		@Override
		public void dispose() {}
		@Override
		public void compose(Raster src, Raster dst, WritableRaster dstOut) {
			DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
			int[] s = srcBuff.getData();
			DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
			int[] d = dstBuff.getData();
			DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
			int[] o = outBuff.getData();

			int srcLen = s.length;
			int dstLen = o.length;
			int length = srcLen < dstLen ? srcLen : dstLen;
			for( int i = 0; i < length; i++ ) {
				o[i] = s[i];
			}
		}
	}
}
