package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.VariantException;

/**
 * base class of draw-able objects.
 */
public interface Drawable {

	/**
	 * returns target bitmap which has given size
	 * (rect.get_width() * rect.get_height()).
	 * put actually to be drawn rectangle to "cliprect"
	 * @param rect
	 * @param cliprect
	 * @return
	 * @throws TJSException
	 */
	public BaseBitmap getDrawTargetBitmap( final Rect rect, Rect cliprect ) throws TJSException;

	/**
	 * returns target layer type
	 */
	public int getTargetLayerType();

	/**
	 * call this when the drawing is completed, passing
	 * the bitmap containing the image, and its clip region.
	 * @throws TJSException
	 * @throws VariantException
	 */
	public void drawCompleted( final Rect destrect, BaseBitmap bmp, final Rect cliprect, int type, int opacity ) throws VariantException, TJSException;
}
