package jp.kirikiri.tjs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NativeClassConstructor extends NativeClassMethod {

	private static final int
		E_INVALIDPARAM = (-1003),
		E_ACCESSDENYED = (-1007);

	public NativeClassConstructor(Method processfunc) {
		super(processfunc);
	}
	public int funcCall( int flag, final String membername, IntWrapper hint, Variant result, Variant[] param, Dispatch2 objthis ) throws VariantException, TJSException {
		if( membername != null ) return super.funcCall(flag, membername, hint, result, param, objthis );
		if( result != null ) result.clear();

		int er = 0;
		Object[] args = new Object[3];
		args[0] = result;
		args[1] = param;
		args[2] = objthis;
		Object ret;
		try {
			ret = mProcess.invoke( objthis, args );
			er = ((Integer)ret).intValue();
		} catch (IllegalArgumentException e) {
			er = E_INVALIDPARAM;
		} catch (IllegalAccessException e) {
			er = E_ACCESSDENYED;
		} catch (InvocationTargetException e) {
			Throwable t = e.getCause();
			if( t instanceof VariantException ) {
				throw (VariantException)t;
			} else if( t instanceof TJSException ) {
				throw (TJSException)t;
			} else {
				throw new TJSException( t.toString() );
			}
		}
		return er;
	}
}
