﻿using System;
using System.Drawing;
using System.Reflection;
using System.Text;

namespace Kasuga.StandardPlugins.Formats
{
    public class BorderWipe
    {
        public static string GenerateClipTags(
            FormatBase format,
            SideKind side,
            Size resolution,
            float clipStart,
            float clipEnd,
            PlayTimeSpan duration,
            bool isShadow)
        {
            try
            {
                StringBuilder builder = new StringBuilder();
                switch (side)
                {
                    case SideKind.Left:
                        builder.Append(@"{\clip(").Append(clipStart + (isShadow ? format.ShadowDepthX : 0)).Append(",").Append(0).Append(",").Append(resolution.Width).Append(",").Append(resolution.Height).Append(")")
                            .Append(@"\t(").Append(0).Append(",").Append((int)((duration).TotalSeconds * 1000)).Append(",")
                            .Append(@"\clip(").Append(clipEnd + (isShadow ? format.ShadowDepthX : 0)).Append(",").Append(0).Append(",").Append(resolution.Width).Append(",").Append(resolution.Height).Append("))}");
                        break;
                    case SideKind.Top:
                        builder.Append(@"{\clip(").Append(0).Append(",").Append(clipStart + (isShadow ? format.ShadowDepthY : 0)).Append(",").Append(resolution.Width).Append(",").Append(resolution.Height).Append(")")
                            .Append(@"\t(").Append(0).Append(",").Append((int)((duration).TotalSeconds * 1000)).Append(",")
                            .Append(@"\clip(").Append(0).Append(",").Append(clipEnd + (isShadow ? format.ShadowDepthY : 0)).Append(",").Append(resolution.Width).Append(",").Append(resolution.Height).Append("))}");
                        break;
                    case SideKind.Right:
                        builder.Append(@"{\clip(").Append(0).Append(",").Append(0).Append(",").Append(clipStart + (isShadow ? format.ShadowDepthX : 0)).Append(",").Append(resolution.Height).Append(")")
                            .Append(@"\t(").Append(0).Append(",").Append((int)((duration).TotalSeconds * 1000)).Append(",")
                            .Append(@"\clip(").Append(0).Append(",").Append(0).Append(",").Append(clipEnd + (isShadow ? format.ShadowDepthX : 0)).Append(",").Append(resolution.Height).Append("))}");
                        break;
                    case SideKind.Bottom:
                        builder.Append(@"{\clip(").Append(0).Append(",").Append(0).Append(",").Append(0).Append(",").Append(clipStart + (isShadow ? format.ShadowDepthY : 0)).Append(")")
                            .Append(@"\t(").Append(0).Append(",").Append((int)((duration).TotalSeconds * 1000)).Append(",")
                            .Append(@"\clip(").Append(0).Append(",").Append(0).Append(",").Append(0).Append(",").Append(clipEnd + (isShadow ? format.ShadowDepthY : 0)).Append("))}");
                        break;
                }
                return builder.ToString();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }
    }
}
