﻿using System;
using System.ComponentModel;
using System.Reflection;
using System.Windows.Forms;

namespace Kasuga
{
    public class LineArrangementPropertyDescriptor : PropertyDescriptor
    {
        public LineArrangementPropertyDescriptor(PropertyDescriptor descriptor)
            : base(descriptor)
        {
            try
            {
                _descriptor = descriptor;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        private PropertyDescriptor _descriptor;

        public override object GetValue(object component)
        {
            try
            {
                IHasLineArrangementDictionary element = (IHasLineArrangementDictionary)component;
                return element.LineArrangementDictionary[_descriptor.Name];
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override void SetValue(object component, object value)
        {
            try
            {
                IHasLineArrangementDictionary element = (IHasLineArrangementDictionary)component;
                element.SetLineArrangementProperty(_descriptor.Name, value, true);
                if (MessageBox.Show("該当ページの構成要素を再配置しますか？", "再配置", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    if (element is KsgSubtitle)
                    {
                        ((KsgSubtitle)element).PageArrange();
                    }
                    else if (element is KsgPart)
                    {
                        ((KsgPart)element).PageArrange();
                    }
                    else if (element is KsgPage)
                    {
                        ((KsgPage)element).PageArrange();
                    }
                    else if (element is KsgLine)
                    {
                        ((KsgLine)element).ParentPage.PageArrange();
                    }
                }
                else if (MessageBox.Show("該当行の構成要素を再配置しますか？", "再配置", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    if (element is KsgSubtitle)
                    {
                        ((KsgSubtitle)element).LineArrange();
                    }
                    else if (element is KsgPart)
                    {
                        ((KsgPart)element).LineArrange();
                    }
                    else if (element is KsgPage)
                    {
                        ((KsgPage)element).LineArrange();
                    }
                    else if (element is KsgLine)
                    {
                        ((KsgLine)element).LineArrange();
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool CanResetValue(object component)
        {
            try
            {
                IHasLineArrangementDictionary element = (IHasLineArrangementDictionary)component;
                return element.BaseLineArrangement != null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override void ResetValue(object component)
        {
            try
            {
                IHasLineArrangementDictionary element = (IHasLineArrangementDictionary)component;
                ILineArrangement baseLineArrangement = element.BaseLineArrangement;
                if (baseLineArrangement != null)
                {
                    PropertyDescriptorCollection descriptors = TypeDescriptor.GetProperties(baseLineArrangement);
                    PropertyDescriptor descriptor = descriptors.Find(_descriptor.Name, true);
                    SetValue(component, descriptor.GetValue(baseLineArrangement));
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool ShouldSerializeValue(object component)
        {
            try
            {
                IHasLineArrangementDictionary element = (IHasLineArrangementDictionary)component;
                ILineArrangement baseLineArrangement = element.BaseLineArrangement;
                if (baseLineArrangement == null)
                {
                    return true;
                }
                else
                {
                    PropertyDescriptorCollection descriptors = TypeDescriptor.GetProperties(baseLineArrangement);
                    PropertyDescriptor descriptor = descriptors.Find(_descriptor.Name, true);
                    return !descriptor.GetValue(baseLineArrangement).Equals(GetValue(component));
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override Type ComponentType
        {
            get
            {
                try
                {
                    return typeof(IHasLineArrangementDictionary);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        public override bool IsReadOnly
        {
            get
            {
                try
                {
                    return _descriptor.IsReadOnly;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return false;
                }
            }
        }

        public override Type PropertyType
        {
            get
            {
                try
                {
                    return _descriptor.PropertyType;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }
    }
}
